#ifndef ARROCROP_H
#define ARROCROP_H

#define MARK00                                  (26325)
#define MARK01                                  (25501)
#define MARK02                                  (24881)
#define MARK03                                  (20668)
#define MARK04                                  (21289)
#define MARK05                                  (22316)
#define MARK06                                  (21332)
#define MARK07                                  (16530)
#define MARK08                                  (12517)
#define MARK09                                  (11892)
#define MARK10                                  (16105)
#define MARK11                                  (15859)
#define MARK12                                  (11469)
#define MARK13                                  (16885)

#define MIN_CRITTERS                            get_ini_setting("Mr Fixit Stims.ini|SETTINGS|Min_Critters")
#define MAX_CRITTERS                            get_ini_setting("Mr Fixit Stims.ini|SETTINGS|Max_Critters")
#define MIN_PID_MUTATED_FRUIT                   get_ini_setting("Mr Fixit Stims.ini|SETTINGS|Min_Herbs") * get_ini_setting("Mr Fixit Stims.ini|SETTINGS|Fruit_Multiplier")
#define MAX_PID_MUTATED_FRUIT                   get_ini_setting("Mr Fixit Stims.ini|SETTINGS|Max_Herbs") * get_ini_setting("Mr Fixit Stims.ini|SETTINGS|Fruit_Multiplier")
#define MIN_PID_RUINED_MUTATED_FRUIT            get_ini_setting("Mr Fixit Stims.ini|SETTINGS|Min_Herbs") * get_ini_setting("Mr Fixit Stims.ini|SETTINGS|Fruit_Multiplier")
#define MAX_PID_RUINED_MUTATED_FRUIT            get_ini_setting("Mr Fixit Stims.ini|SETTINGS|Max_Herbs") * get_ini_setting("Mr Fixit Stims.ini|SETTINGS|Fruit_Multiplier")

#define MVAR_Respawn_Timer                      (0)
#define MVAR_Last_Spot                          (1)
#define MVAR_Elev_0_counter                     (2)
#define MVAR_Elev_1_counter                     (3)
#define MVAR_Elev_2_counter                     (4)


procedure Next_Hex;
procedure Next_Hex_Spot;
procedure Make_Critters(variable Elev);
procedure Make_Plants(variable Elev);
procedure Make;
procedure Spawn_Bone_Containers(variable Elev);

procedure Next_Hex begin
   call Next_Hex_Spot;
   while (map_var(MVAR_Last_Spot) == -1) do begin
      call Next_Hex_Spot;
   end
end

procedure Next_Hex_Spot begin
   if (map_var(MVAR_Last_Spot) == MARK00) or not(map_var(MVAR_Last_Spot))  then begin
      set_map_var(MVAR_Last_Spot,MARK01);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK01) then begin
      set_map_var(MVAR_Last_Spot,MARK02);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK02) then begin
      set_map_var(MVAR_Last_Spot,MARK03);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK03) then begin
      set_map_var(MVAR_Last_Spot,MARK04);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK04) then begin
      set_map_var(MVAR_Last_Spot,MARK05);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK05) then begin
      set_map_var(MVAR_Last_Spot,MARK06);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK06) then begin
      set_map_var(MVAR_Last_Spot,MARK07);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK07) then begin
      set_map_var(MVAR_Last_Spot,MARK08);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK08) then begin
      set_map_var(MVAR_Last_Spot,MARK09);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK09) then begin
      set_map_var(MVAR_Last_Spot,MARK10);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK10) then begin
      set_map_var(MVAR_Last_Spot,MARK11);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK11) then begin
      set_map_var(MVAR_Last_Spot,MARK12);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK12) then begin
      set_map_var(MVAR_Last_Spot,MARK13);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK13) then begin
      set_map_var(MVAR_Last_Spot,MARK00);
   end 
end

procedure Make_Critters(variable Elev) begin
   variable Critter_Counter:=0;
   variable New_Critter:=0;
   variable Item;
   variable Item_Hex;
   variable Critter_PID;

// Critter
   New_Critter:=random(MIN_CRITTERS,MAX_CRITTERS);
   while (Critter_Counter < New_Critter) do begin
      call Next_Hex;
      Critter_PID := Pick_Alien_PID; //Pick_Fruit_Fly_PID;
	  //Critter_PID := Pick_Ant_PID;
      //display_msg("PID : " + Pick_Cockroach_PID);
	  Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,15));
      call Spawn_Critter(Critter_PID,Item_Hex,SCRIPT_ECALIEN,Elev);	
      Critter_Counter+=1;
   end
end

procedure Make_Plants(variable Elev) begin
   variable New_Fruit:=0;
   variable Fruit:=0;
   variable New_Ruined_Fruit:=0;
   variable Ruined_Fruit:=0;
   variable Item:=0;
   variable Item_Hex:=0;

// Fruit
   Fruit:=random(MIN_PID_MUTATED_FRUIT,MAX_PID_MUTATED_FRUIT);
   if (Fruit < New_Fruit) then begin
      while (Fruit < New_Fruit) do begin
         call Next_Hex;
         Item:=create_object(PID_MUTATED_FRUIT,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,12));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,12));
         end
         move_to(Item,Item_Hex,Elev);
         Fruit := Fruit +1;
      end
   end
// Ruined Fruit
   New_Ruined_Fruit:=random(MIN_PID_RUINED_MUTATED_FRUIT,MAX_PID_RUINED_MUTATED_FRUIT);
   if (Ruined_Fruit < New_Ruined_Fruit) then begin
      while (Ruined_Fruit < New_Ruined_Fruit) do begin
         call Next_Hex;
         Item:=create_object(PID_RUINED_MUTATED_FRUIT,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,12));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,12));
         end
         move_to(Item,Item_Hex,Elev);
         Ruined_Fruit := Ruined_Fruit +1;
      end
   end
end

procedure Spawn_Bone_Containers(variable Elev) begin
   variable num_of_bones := random(12,24);
   variable item_hex,bones;
   variable count;
   //call Next_Hex;
   while (count < num_of_bones) do begin
      call Next_Hex;
      item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
      while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
      end
      bones := create_object_sid(PID_HUMAN_BONES,item_hex,Elev,-1);
	  if (tile_num(bones) != item_hex) then begin
	     destroy_object(bones);
	  end
	  count := count + 1;
   end
end

procedure Make begin
   set_map_var(MVAR_Elev_0_counter, 0);
   set_map_var(MVAR_Elev_1_counter, 0);
   set_map_var(MVAR_Elev_2_counter, 0);
   //display_msg("spawned");
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Critters(0);
   //display_msg("critter 0");
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Critters(1);
   //display_msg("critter 1");
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Critters(2);
   //display_msg("critter 2");
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Plants(0);
   //display_msg("herbs 0");
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Plants(1);
   //display_msg("herbs 1");
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Plants(2);
   //display_msg("herbs 2");
end


#endif // ARROCROP_H