#ifndef TIME_INC_H
#define TIME_INC_H

// *******************************************************************************************
// *************************** added by cubik2k **********************************************
// *******************************************************************************************
#define THIRD_GAME_SECOND           (3)
#define HALF_GAME_SECOND            (5)
// *******************************************************************************************
// *************************** added by cubik2k **********************************************
// *******************************************************************************************

#define ONE_REAL_SECOND             (1000)

#define ONE_GAME_SECOND             (10)
#define ONE_GAME_MINUTE             (60*ONE_GAME_SECOND)
#define ONE_GAME_HOUR               (60*ONE_GAME_MINUTE)
#define ONE_GAME_DAY                (24*ONE_GAME_HOUR)
#define ONE_GAME_WEEK               (7*ONE_GAME_DAY)
#define ONE_GAME_MONTH              (30*ONE_GAME_DAY)

#define GAME_TIME_SUBSECOND_RESOLUTION  (10)
#define SECONDS_PER_MINUTE              (60)
#define MINUTES_PER_HOUR                (60)
#define HOURS_PER_DAY                   (24)
#define DAYS_PER_YEAR                   (365)
                                // Seconds Minutes Hours Days Months ==> Year
#define GAME_TIME_IN_YEARS   (game_time / (GAME_TIME_SUBSECOND_RESOLUTION * SECONDS_PER_MINUTE * MINUTES_PER_HOUR * HOURS_PER_DAY * DAYS_PER_YEAR))
#define GAME_TIME_IN_DAYS    (game_time / (GAME_TIME_SUBSECOND_RESOLUTION * 60 * 60 * 24))
#define GAME_TIME_IN_HOURS   (game_time / (GAME_TIME_SUBSECOND_RESOLUTION * SECONDS_PER_MINUTE * MINUTES_PER_HOUR))
#define GAME_TIME_IN_MINUTES (game_time / (GAME_TIME_SUBSECOND_RESOLUTION * SECONDS_PER_MINUTE))
#define GAME_TIME_IN_SECONDS (game_time / GAME_TIME_SUBSECOND_RESOLUTION)

#define ticks_til_hour(x)                 ((ONE_GAME_DAY * (game_time_hour > (x))) + ((((x)/100) - (game_time_hour/100)) * ONE_GAME_HOUR) + ((((x)%100) - (game_time_hour%100)) * ONE_GAME_MINUTE))
#define game_time_advance_hour(x)         game_time_advance(ticks_til_hour(x))

#define time_has_passed(old_time, passed_time)      ((passed_time + old_time) <= game_time)

#define amt_time_has_passed(old_time, time_unit)  ((game_time - old_time) / time_unit)


// *******************************************************************************************
// *************************** added by cubik2k **********************************************
// *******************************************************************************************
#define third_second_passed(old_time)     time_has_passed(old_time,THIRD_GAME_SECOND)
#define half_second_passed(old_time)      time_has_passed(old_time,HALF_GAME_SECOND)
// *******************************************************************************************
// *************************** added by cubik2k **********************************************
// *******************************************************************************************

#define one_second_passed(old_time)       time_has_passed(old_time,ONE_GAME_SECOND)
#define one_minute_passed(old_time)       time_has_passed(old_time,ONE_GAME_MINUTE)
#define one_hour_passed(old_time)         time_has_passed(old_time,ONE_GAME_HOUR)
#define one_day_passed(old_time)          time_has_passed(old_time,ONE_GAME_DAY)
#define one_week_passed(old_time)         time_has_passed(old_time,ONE_GAME_WEEK)
#define one_month_passed(old_time)        time_has_passed(old_time,ONE_GAME_MONTH)

#endif // TIME_INC_H





