/*
	Copyright 1998-2003 Interplay Entertainment Corp.  All rights reserved.
*/

#ifndef MAPS_H
#define MAPS_H

/*****************************************************************
   Filename: Maps.h

   Purpose: This file is used to store the defines pertaining
            to the maps. All defines from define.h have been
            placed in here for ease of reading and finding
            the the proper defines.

   Contents: The file is broken down in the following manner:
            I.      Map name Defines.
            II.     Map Entrance Points
            III.    Elevator Defines
            IV.     Random Encounter Defines
*****************************************************************/

/*****************************************************************
********************       Area Names       ***********************
*****************************************************************/

#define AREA_ARROYO                 (0)
#define AREA_DEN                    (1)
#define AREA_KLAMATH                (2)
#define AREA_MODOC                  (3)
#define AREA_VAULT_CITY             (4)
#define AREA_GECKO                  (5)
#define AREA_BROKEN_HILLS           (6)
#define AREA_NEW_RENO               (7)
#define AREA_SIERRA_ARMY_BASE       (8)
#define AREA_VAULT_15               (9)
#define AREA_NCR                    (10)
#define AREA_VAULT_13               (11)
#define AREA_MILITARY_BASE          (12)
#define AREA_REDDING                (13)
#define AREA_SAN_FRANCISCO          (14)
#define AREA_NAVARRO                (15)
#define AREA_THE_ENCLAVE            (16)
#define AREA_ABBEY_OLD              (17)
#define AREA_PRIMITIVE_TRIBE_OLD    (18)
#define AREA_EPA_OLD                (19)
#define AREA_GHOST_TOWN             (20)
#define AREA_CAR_OUTTA_GAS          (21)
#define AREA_ARROYO_DESTROYED       (22)
#define AREA_KLAMATH_TOXIC_CAVES    (23)
#define AREA_DEN_SLAVE_RUN          (24)
#define AREA_RAIDERS                (25)
#define AREA_RND_DESERT             (26)
#define AREA_RND_MOUNTAIN           (27)
#define AREA_RND_CITY               (28)
#define AREA_RND_COAST              (29)
#define AREA_GOLGATHA               (30)
#define AREA_SPECIAL_RND_WHALE      (31)
#define AREA_SPECIAL_RND_WOODSMAN   (32)
#define AREA_SPECIAL_RND_HEAD       (33)
#define AREA_SPECIAL_RND_SHUTTLE    (34)
#define AREA_SPECIAL_RND_UNWASHED   (35)
#define AREA_SPECIAL_RND_BRIDGE     (36)
#define AREA_SPECIAL_RND_CAFE       (37)
#define AREA_SPECIAL_RND_HOLY1      (38)
#define AREA_SPECIAL_RND_HOLY2      (39)
#define AREA_SPECIAL_RND_GUARDIAN   (40)
#define AREA_SPECIAL_RND_TOXIC      (41)
#define AREA_SPECIAL_RND_PARIAH     (42)
#define AREA_SPECIAL_RND_MAD_COW    (43)
#define AREA_CARAVAN_ENCOUNTER      (44)
#define AREA_FAKE_VAULT_13A         (45)
#define AREA_FAKE_VAULT_13B         (46)
#define AREA_SHADOW_MAPS            (47)
#define AREA_RENO_STABLES           (48)
#define AREA_EPA                    (49)
#define AREA_TRUCK                  (50)
#define AREA_B21                    (51)
#define AREA_ABBEY                  (52)
#define AREA_SCRAPTOWN              (53)
#define AREA_PRIMITIVE_TRIBE        (54)
#define AREA_SPECIAL_POSTMAN        (55)
#define AREA_VAULT_23               (56)
#define AREA_BROHDENT               (57)
#define AREA_SVESH                  (58)
#define AREA_SOUZNIKI               (59)
#define AREA_HAB                    (60)
#define AREA_SOBOR                  (61)
#define AREA_ADITUM                 (62)
#define AREA_NECROPOLIS             (63)
#define AREA_NEW_MILITARY_BASE      (64)
#define AREA_NARTEMPL               (65)
#define AREA_LARS_CITY_A            (66)
#define AREA_BH_REATOR_A            (67)
#define AREA_FERMA_BRAD             (68)
#define AREA_MIRAGE                 (69)
#define AREA_MASTER_ARMY_DEAD       (70)
#define AREA_VAULT_14               (71)
#define AREA_COLLYWEB               (72)
#define AREA_MIRRANDAS_HOUSE        (73)
#define AREA_SALVATOR_GUN_STASH     (74)
#define AREA_SPECIAL_SALVATOR       (75)
#define AREA_SALVATOR_MEETING       (76)
#define AREA_LARS_CITY_B            (77)
#define AREA_SCORPION_SQUARE        (78)
#define AREA_BH_REATOR_B            (79)
#define AREA_BOS_BUNKER             (80)
#define AREA_BOS_HELP               (81)
#define AREA_BOS_FACILITY           (82)
#define AREA_BROTHERHOOD            (83)
#define AREA_PRIMITIVE_TRIBES       (84)

/*****************************************************************
********************       Map Names       ***********************
*****************************************************************/
                                                                                 /* Map Actual File Name*/
#define MAP_RND_DESERT_1            (0)                                          //desert1
#define MAP_RND_DESERT_2            (1)                                          //desert2
#define MAP_RND_DESERT_3            (2)                                          //desert3
#define MAP_ARROYO_CAVES            (3)                                          //arcaves
#define MAP_ARROYO_VILLAGE          (4)                                          //arvillag
#define MAP_ARROYO_BRIDGE           (5)                                          //arbridge
#define MAP_DEN_ENTRANCE            (6)                                          //denbus1
#define MAP_DEN_BUSINESS            (7)                                          //denbus2
#define MAP_DEN_RESIDENTIAL         (8)                                          //denres1
#define MAP_KLAMATH_1               (9)                                          //kladwtwn
#define MAP_KLAMATH_MALL            (10)                                         //klamall
#define MAP_KLAMATH_RATCAVES        (11)                                         //klaratcv
#define MAP_KLAMATH_TOXICCAVES      (12)                                         //klatoxcv
#define MAP_KLAMATH_TRAPCAVES       (13)                                         //klatrap
#define MAP_KLAMATH_GRAZE           (14)                                         //klagraz
#define MAP_VAULTCITY_COURTYARD     (15)                                         //vctyctyd
#define MAP_VAULTCITY_DOWNTOWN      (16)                                         //vctydwtn
#define MAP_VAULTCITY_COUNCIL       (17)                                         //vctycocl
#define MAP_MODOC_MAINSTREET        (18)                                         //modmain
#define MAP_MODOC_BEDNBREAKFAST     (19)                                         //modinn
#define MAP_MODOC_BRAHMINPASTURES   (20)                                         //modbrah
#define MAP_MODOC_GARDEN            (21)                                         //modgard
#define MAP_MODOC_DOWNTHESHITTER    (22)                                         //modshit
#define MAP_MODOC_WELL              (23)                                         //modwell
#define MAP_GHOST_FARM              (24)                                         //gstfarm
#define MAP_GHOST_CAVERN            (25)                                         //gstcav1
#define MAP_GHOST_LAKE              (26)                                         //gstcav2
#define MAP_SIERRA_BATTLE           (27)                                         //depolv1
#define MAP_SIERRA_123              (28)                                         //depolva
#define MAP_SIERRA_4                (29)                                         //depolvb
#define MAP_VAULT_CITY_VAULT        (30)                                         //vctyvlt
#define MAP_GECKO_SETTLEMENT        (31)                                         //gecksetl
#define MAP_GECKO_POWER_PLANT       (32)                                         //geckpwpl
#define MAP_GECKO_JUNKYARD          (33)                                         //geckjunk
#define MAP_GECKO_ACCESS_TUNNELS    (34)                                         //gecktunl
#define MAP_ARROYO_WILDERNESS       (35)                                         //argarden
#define MAP_VAULT_15                (36)                                         //vault15
#define MAP_THE_SQUAT_A             (37)                                         //v15ent
#define MAP_THE_SQUAT_B             (38)                                         //v15entb
#define MAP_VAULT_15_EAST_ENTRANCE  (39)                                         //v15sent
#define MAP_VAULT_13                (40)                                         //vault13
#define MAP_VAULT_13_ENTRANCE       (41)                                         //v13ent
#define MAP_NCR_DOWNTOWN            (42)                                         //ncr1
#define MAP_NCR_COUNCIL             (43)                                         //ncr2
#define MAP_NCR_WESTIN_RANCH        (44)                                         //ncr3
#define MAP_NCR_GRAZING_LANDS       (45)                                         //ncr4
#define MAP_NCR_BAZAAR              (46)                                         //ncrent
//#define MAP_NCR_COUNCIL             (47)                                         //ncrex
#define MAP_KLAMATH_CANYON          (48)                                         //klacanyn
#define MAP_MILITARY_BASE_12        (49)                                         //mbase12
#define MAP_MILITARY_BASE_34        (50)                                         //mbase34
#define MAP_MILITARY_BASE_ENTRANCE  (51)                                         //mbclose
#define MAP_DEN_SLAVE_RUN           (52)                                         //dnslvrun
#define MAP_CAR_DESERT              (53)                                         //cardesrt
#define MAP_NEW_RENO_1              (54)                                         //newr1
#define MAP_NEW_RENO_2              (55)                                         //newr2
#define MAP_NEW_RENO_3              (56)                                         //newr3
#define MAP_NEW_RENO_4              (57)                                         //newr4
#define MAP_NEW_RENO_CHOP_SHOP      (58)                                         //newrcs
#define MAP_NEW_RENO_GOLGATHA       (59)                                         //newrgo
#define MAP_NEW_RENO_STABLES        (60)                                         //newrst
#define MAP_NEW_RENO_BOXING         (61)                                         //newrba
#define MAP_REDDING_WANAMINGO_ENT   (62)                                         //redwame
#define MAP_REDDING_WANAMINGO_12    (63)                                         //redwan1
#define MAP_REDDING_DOWNTOWN        (64)                                         //reddown
#define MAP_REDDING_MINE_ENT        (65)                                         //redment
#define MAP_REDDING_DTOWN_TUNNEL    (66)                                         //reddtun
#define MAP_REDDING_MINE_TUNNEL     (67)                                         //redmtun
#define MAP_RND_CITY1               (68)                                         //city1
#define MAP_RND_CAVERN0             (69)                                         //cave0
#define MAP_RND_CAVERN1             (70)                                         //cave1
#define MAP_RND_CAVERN2             (71)                                         //cave2
#define MAP_RND_CAVERN3             (72)                                         //cave3
#define MAP_RND_CAVERN4             (73)                                         //cave4
#define MAP_RND_MOUNTAIN1           (74)                                         //mountn1
#define MAP_RND_MOUNTAIN2           (75)                                         //mountn2
#define MAP_RND_COAST1              (76)                                         //coast1
#define MAP_RND_COAST2              (77)                                         //coast2
#define MAP_BROKEN_HILLS1           (78)                                         //broken1
#define MAP_BROKEN_HILLS2           (79)                                         //broken2
#define MAP_RND_CAVERN5             (80)                                         //cave5
#define MAP_RND_DESERT4             (81)                                         //desert4
#define MAP_RND_DESERT5             (82)                                         //desert5
#define MAP_RND_DESERT6             (83)                                         //desert6
#define MAP_RND_DESERT7             (84)                                         //desert7
#define MAP_RND_COAST3              (85)                                         //coast3
#define MAP_RND_COAST4              (86)                                         //coast4
#define MAP_RND_COAST5              (87)                                         //coast5
#define MAP_RND_COAST6              (88)                                         //coast6
#define MAP_RND_COAST7              (89)                                         //coast7
#define MAP_RND_COAST8              (90)                                         //coast8
#define MAP_RND_COAST9              (91)                                         //coast9
#define MAP_RAIDERS_CAMP1           (92)                                         //raiders1
#define MAP_RAIDERS_CAMP2           (93)                                         //raiders2
#define MAP_BH_RND_DESERT           (94)                                         //bhrnddst
#define MAP_BH_RND_MOUNTAIN         (95)                                         //bhrndmnt
#define MAP_SPECIAL_RND_WHALE       (96)                                         //rndwhale
#define MAP_SPECIAL_RND_WOODSMAN    (97)                                         //rndtinwd
#define MAP_SPECIAL_RND_HEAD        (98)                                         //rndbhead
#define MAP_SPECIAL_RND_SHUTTLE     (99)                                         //rndshutl
#define MAP_SPECIAL_RND_UNWASHED    (100)                                        //rnduvilg
#define MAP_SPECIAL_RND_BRIDGE      (101)                                        //rndbridg
#define MAP_SPECIAL_RND_CAFE        (102)                                        //rndcafe
#define MAP_SPECIAL_RND_HOLY1       (103)                                        //rndholy1
#define MAP_SPECIAL_RND_HOLY2       (104)                                        //rndholy2
#define MAP_SPECIAL_RND_GUARDIAN    (105)                                        //rndforvr
#define MAP_SPECIAL_RND_TOXIC       (106)                                        //rndtoxic
#define MAP_SPECIAL_RND_PARIAH      (107)                                        //rndparih
#define MAP_SPECIAL_RND_MAD_COW     (108)                                        //rndexcow
#define MAP_NAVARRO_ENTRANCE        (109)                                        //navarro
#define MAP_RND_COAST_10            (110)                                        //coast10
#define MAP_RND_COAST_11            (111)                                        //coast11
#define MAP_RND_COAST_12            (112)                                        //07desert
#define MAP_RND_DESERT_8            (113)                                        //desert8
#define MAP_RND_DESERT_9            (114)                                        //desert9
#define MAP_RND_DESERT_10           (115)                                        //desrt10
#define MAP_RND_DESERT_11           (116)                                        //desrt11
#define MAP_RND_DESERT_12           (117)                                        //desrt12
#define MAP_RND_CAVERN_5            (118) //desert 13 in maps.txt                //dsrt13
#define MAP_RND_CAVERN_6            (119)                                        //cave6
#define MAP_RND_CAVERN_7            (120)                                        //cave7
#define MAP_RND_MOUNTAIN_3          (121)                                        //mountn3
#define MAP_RND_MOUNTAIN_4          (122)                                        //mountn4
#define MAP_RND_MOUNTAIN_5          (123)                                        //Mountn5
#define MAP_RND_MOUNTAIN_6          (124)                                        //mountn6
#define MAP_RND_CITY_2              (125)                                        //city2
#define MAP_ARROYO_TEMPLE           (126)                                        //artemple
#define MAP_DESTROYED_ARROYO_BRIDGE (127)                                        //ardead
#define MAP_ENCLAVE_DETENTION       (128)                                        //encdet
#define MAP_ENCLAVE_DOCK            (129)                                        //encdock
#define MAP_ENCLAVE_END_FIGHT       (130)                                        //encfite
#define MAP_ENCLAVE_BARRACKS        (131)                                        //encgd
#define MAP_ENCLAVE_PRESIDENT       (132)                                        //encpres
#define MAP_ENCLAVE_REACTOR         (133)                                        //encrctr
#define MAP_ENCLAVE_TRAP_ROOM       (134)                                        //enctrp
#define MAP_SAN_FRAN_TANKER         (135)                                        //sftanker
#define MAP_SAN_FRAN_DOCK           (136)                                        //sfdock
#define MAP_SAN_FRAN_CHINATOWN      (137)                                        //sfchina
#define MAP_SHUTTLE_EXTERIOR        (138)                                        //SFSHUTL1
#define MAP_SHUTTLE_INTERIOR        (139)                                        //SFSHUTL2
#define MAP_ELRONOLOGIST_BASE       (140)                                        //sfelronb
#define MAP_RND_CITY_3              (141)                                        //city3
#define MAP_RND_CITY_4              (142)                                        //city4
#define MAP_RND_CITY_5              (143)                                        //city5
#define MAP_RND_CITY_6              (144)                                        //city6
#define MAP_RND_CITY_7              (145)                                        //city7
#define MAP_RND_CITY_8              (146)                                        //city8
#define MAP_NEW_RENO_VB             (147)                                        //newrvb
#define MAP_SHI_TEMPLE              (148)                                        //sfchina2
#define MAP_IN_GAME_MOVIE1          (149)                                        //gammovie
//Megamod Added
#define MAP_BESS_DEAD               (150)                                        //rndbess
#define MAP_EPA                     (151)                                        //epax
#define MAP_DEATHCLAW_ENCOUNTER_A   (152)                                        //rndbd
#define MAP_EPA_SUBLEVELS           (153)                                        //EPAMain
#define MAP_WAREHOUSE               (154)                                        //epawrhse
#define MAP_ABBEY_1                 (155)                                        //Abbey - 2 of these
#define MAP_TRUCK                   (156)                                        //truck
#define MAP_B21                     (157)                                        //B21
#define MAP_MAD_DOG_ENCOUNTER       (158)                                        //rndmddg
#define MAP_DEATHCLAW_ENCOUNTER_B   (159)                                        //rndbd
#define MAP_JENNINGS_FARM           (160)                                        //jenfarm7
#define MAP_KLAMATH_RAT_CAVE_ENTER  (161)                                        //KLACVENT
#define MAP_SCRAPTOWN               (162)                                        //scrapt
#define MAP_PRIMITIVE_TRIBE         (163)                                        //tribe01
#define MAP_SPECIAL_POSTMAN         (164)                                        //glow34
#define MAP_GLOW_LOWER              (165)                                        //glow12
#define MAP_GLOW_UPPER              (166)                                        //glowent
#define MAP_GLOW                    (167)                                        //svesh  - map not present
#define MAP_RANGER_SAFE_HOUSE_1     (168)                                        //safehs1
#define MAP_RANGER_SAFE_HOUSE_2     (169)                                        //safehs2
#define MAP_RANGER_SAFE_HOUSE_3     (170)                                        //safehs3
//#define MAP_BASED                   (171)                                        //based - map not present
//#define MAP_HAB                     (172)                                        //hab - map not present
//#define MAP_JAKLADB                 (173)                                        //JNKLADB - map not present
//#define MAP_KRATER                  (174)                                        //krater - map not present
#define MAP_LABLADES                (175)                                        //Lablades
#define MAP_LAFOLLOWR               (176)                                        //Lafollwr
#define MAP_LAADYTUM                (177)                                        //Laadytum
//#define MAP_TPMBENTR                (178)                                        //Tpmbentr - map not present
#define MAP_GHOST_TOWN              (179)                                        //A12 map name,ghost town in maps.txt
#define MAP_LABLADE                 (180)                                        //Lablade
//#define MAP_TPMB01                  (181)                                        //tpmb01 - map not present
//#define MAP_TPMB03                  (182)                                        //tpmb03 - map not present
//#define MAP_TPMB12                  (183)                                        //tpmb12 - map not present
//#define MAP_TPMB02                  (184)                                        //tpmb02 - map not present
//#define MAP_TPMB34                  (185)                                        //tpmb34 - map not present
//#define MAP_TPMB04                  (186)                                        //tpmb04 - map not present
//#define MAP_TPMBAR                  (187)                                        //tpmbar - map not present
#define MAP_BROHD1K                 (188)                                        //Brohd1k
//#define MAP_BAZE                    (189)                                        //baze - crashes mapper2
//#define MAP_NECRNCR                 (190)                                        //Necrncr - map not present
//#define MAP_NECHALL                 (191)                                        //Nechall - map not present
//#define MAP_NECHOTEL                (192)                                        //Nechotel - map not present
//#define MAP_HISTORY1                (193)                                        //history1 - map not present
//#define MAP_XABMYR01                (194)                                        //xabmyr01 - map not present
#define MAP_LARS_STREET             (195)                                        //lars1
#define MAP_LARS_BH                 (196)                                        //lars2
#define MAP_LARS_REAKTOR            (197)                                        //lars3
#define MAP_DESTROYED_LAB           (198)                                        //map name a10,destroyed lab
//#define MAP_MIRAGE                  (199)                                        //mirage - map not present
//#define MAP_LARIPPER                (200)                                        //LARIPPER - map not present
//#define MAP_LAGUNRUN                (201)                                        //LAGUNRUN - map not present
#define MAP_VAULT23EN               (202)                                        //CrisiEnt
#define MAP_VT23IN                  (203)                                        //CrisiVT
#define MAP_VLT23BOS                (204)                                        //v23Boss
#define MAP_VAULT23CAV              (205)                                        //CrisiCav
//#define MAP_HAB1                    (206)                                        //hab1 - map not present
//#define MAP_HAB2                    (207)                                        //hab2 - map not present
//#define MAP_HABWATER                (208)                                        //habwater - map not present
//#define MAP_ADITUMC                 (209)                                        //aditumC - map not present
//#define MAP_ADITUMB                 (210)                                        //aditumb - map not present
//#define MAP_HABOLDTN                (211)                                        //haboldtn - map not present
//#define MAP_BASEDVX                 (212)                                        //basedvx - map not present
#define MAP_BROHDENT                (213)                                        //Brohdent
#define MAP_BROHD12                 (214)                                        //Brohd12
#define MAP_BROHD34                 (215)                                        //Brohd34
#define MAP_DEAD_MASTER_ARMY        (216)                                        //rndmstr
#define MAP_VAULT14                 (217)                                        //VAULT14
#define MAP_VAULT14_ENTRANCE        (218)                                        //V14ENT
#define MAP_VAULT14B                (219)                                        //VAULT14B
#define MAP_COLLY_GARBAGE           (220)                                        //Colly
#define MAP_COLLY_HIDEOUT           (221)                                        //Colly1
//#define MAP_MIRANDAS_HOUSE          (222)                                        //comhouse - map not present
#define MAP_MODOC_THIEVES_GUILD     (223)                                        //modoct
#define MAP_SALVATORE_GUN_STASH     (224)                                        //modoct2
#define MAP_SPECIAL_SALVATOR_ENCNTR (225)                                        //modoct3
#define MAP_DESERT_MEETING          (226)                                        //modoct4
//#define MAP_BROTHERHOOD             (227)                                        //citychst - map not present
//#define MAP_BROTHERHOOD12           (228)                                        //citychs - map not present
//#define MAP_BROTHERHOOD34           (229)                                        //citych3 - map not present
//#define MAP_ABBEY_2                 (230)                                        //Abbey   - Duplicate
#define MAP_PRIMITIVE_TRIBES        (231)                                        //primit
#define MAP_CARSON_MAIN             (232)                                        //crsnmain
//#define MAP_LARS_STREET             (233)                                        //lars2 - Duplicate
//#define MAP_LARSBH                  (234)                                        //lars3 - Duplicate
#define MAP_LARS_SCORPION_SQUARE    (235)                                        //larsscrp
#define MAP_EPA2                    (236)                                        //epa2
#define MAP_EPA_LVL_2               (237)                                        //epalvl2
#define MAP_BOS_ENTRANCE            (238)                                        //brohdent
#define MAP_BOS_LEVEL_12            (229)                                        //brohd12
#define MAP_BOS_LEVEL_34            (240)                                        //brohd34
#define MAP_BOS_NEED_HELP           (241)                                        //brhdhlp
#define MAP_EPA_ENTRANCE            (242)                                        //epaent
#define MAP_ENCLAVE_DOC_WITH_VERT   (243)                                        //encvert
#define MAP_ENCLAVE_FIGHT_WO_FRANK  (244)                                        //encft2
#define MAP_RESERVE _00             (245)
#define MAP_SLAVER_VAULT            (246)
#define MAP_RESERVE_00              (247)
#define MAP_RESERVE_01              (248)
#define MAP_CAR_BREAKDOWN           (249)
#define MAP_ABANDONED_MINE_3_4      (250)
#define MAP_ABANDONED_MINE_1_2      (251)
#define MAP_ABANDONED_MINE_FARM     (252)
#define MAP_PRIMITIVE_WATERSLIDE    (253)
#define MAP_SLAVER_CAMP             (254)
#define MAP_DARK_CAVE               (255)
#define MAP_ARROYO_CROP_ENTRANCE    (256)
#define MAP_ARROYO_CROP_FIELDS      (257)
#define MAP_KLAMATH_FORREST_ENTRANCE (258)
#define MAP_KLAMATH_FORREST         (259)
#define MAP_RUINED_CITY_ENTRANCE    (260)
#define MAP_RUINED_CITY             (261)
#define MAP_CAVE_ENTRANCE           (262)
#define MAP_LARGE_CAVE              (263)
#define MAP_ORCHARD_ENTRANCE        (264)
#define MAP_ORCHARD                 (265)
#define MAP_GRAVEYARD_ENTRANCE      (266)
#define MAP_GRAVEYARD               (267)
#define MAP_ABANDONED_MINE_ENTRANCE (268)
#define MAP_V32_ENTRANCE            (269)
#define MAP_V32                     (270)
#define MAP_V33_ENTRANCE            (271)
#define MAP_V33                     (272)
#define MAP_V34_ENTRANCE            (273)
#define MAP_V34                     (274)

#define MAP_RND_DESERT_13           (MAP_RND_CAVERN_5)
/*****************************************************************
********************   Map String Defines  ***********************
*****************************************************************/
#define MAPSTR_ARBRDIGE             "arbridge.map"
#define MAPSTR_ARCAVES              "arcaves.map"
#define MAPSTR_ARGARDEN             "ARGARDEN.MAP"
#define MAPSTR_ARVILLAG             "arvillag.map"
#define MAPSTR_CARDSERT             "cardesrt.map"
#define MAPSTR_DEBBUS1              "denbus1.map"
#define MAPSTR_DENBUS2              "denbus2.map"
#define MAPSTR_DENRES1              "denres1.map"
#define MAPSTR_DEPOLV1              "depolv1.map"
#define MAPSTR_DEPOLVA              "depolvA.map"
#define MAPSTR_DEPOLVB              "depolvB.map"
#define MAPSTR_DNSLVRUN             "DNSlvRun.map"
#define MAPSTR_GECKPWPL             "GECKPWPL.map"
#define MAPSTR_GECKSETL             "GECKSETL.map"
#define MAPSTR_GSTCAV1              "gstcav1.map"
#define MAPSTR_GSTCAV2              "gstcav2.map"
#define MAPSTR_GSTFARM              "gstfarm.map"
#define MAPSTR_KLADWTWN             "kladwtwn.map"
#define MAPSTR_KLAGRAZ              "klagraz.map"
#define MAPSTR_KLAMALL              "KLAMALL.map"
#define MAPSTR_KLARATCV             "KLARATCV.map"
#define MAPSTR_KLATOXCV             "klatoxcv.map"
#define MAPSTR_KLATRAP              "klatrap.map"
#define MAPSTR_MODBRAH              "modbrah.map"
#define MAPSTR_MODGARD              "modgard.map"
#define MAPSTR_MODINN               "modinn.map"
#define MAPSTR_MODMAIN              "modmain.map"
#define MAPSTR_MODSHIT              "modshit.map"
#define MAPSTR_MODWELL              "modwell.map"
#define MAPSTR_NCR1                 "NCR1.MAP"
#define MAPSTR_NCR2                 "NCR2.MAP"
#define MAPSTR_NCR3                 "NCR3.MAP"
#define MAPSTR_NCR4                 "NCR4.MAP"
#define MAPSTR_NCRENT               "NCRENT.MAP"
#define MAPSTR_NCREX                "NCREX.MAP"
#define MAPSTR_V13ENT               "V13ENT.MAP"
#define MAPSTR_V13_ORIG             "V13_ORIG.map"
#define MAPSTR_V15ENTA              "V15ENTA.MAP"
#define MAPSTR_V15ENTB              "V15ENTB.MAP"
#define MAPSTR_V15SENT              "V15SENT.MAP"
#define MAPSTR_V15_ORIG             "V15_ORIG.map"
#define MAPSTR_VAULT13              "VAULT13.MAP"
#define MAPSTR_VAULT15              "VAULT15.MAP"
#define MAPSTR_VCTYCOCL             "VCTYCOCL.map"
#define MAPSTR_VCTYCTYD             "VCTYCTYD.map"
#define MAPSTR_VCTYDWTN             "VCTYDWTN.map"
#define MAPSTR_VCTYVLT              "VCTYVLT.map"
#define MAPSTR_NEWRBA               "NEWRBA.map"
#define MAPSTR_NEWR1                "newr1.map"
#define MAPSTR_REDWAME              "REDWAME.map"
#define MAPSTR_REDWAN1              "REDWAN1.map"
#define MAPSTR_REDDOWN              "REDDOWN.map"
#define MAPSTR_REDMENT              "REDMENT.map"
#define MAPSTR_REDDTUN              "REDDTUN.map"
#define MAPSTR_REDMTUN              "REDMTUN.map"
#define MAPSTR_CITY1                "CITY1.map"
#define MAPSTR_CAVE0                "CAVE0.map"
#define MAPSTR_CAVE1                "CAVE1.map"
#define MAPSTR_CAVE2                "CAVE2.map"
#define MAPSTR_CAVE3                "CAVE3.map"
#define MAPSTR_CAVE4                "CAVE4.map"
#define MAPSTR_MOUNTN1              "MOUNTN1.map"
#define MAPSTR_MOUNTN2              "MOUNTN2.map"
#define MAPSTR_COAST1               "COAST1.MAP"
#define MAPSTR_COAST2               "COAST2.MAP"
#define MAPSTR_BROKEN1              "BROKEN1.MAP"
#define MAPSTR_BROKEN2              "BROKEN2.MAP"
#define MAPSTR_CAVE5                "CAVE5.MAP"
#define MAPSTR_DESERT4              "DESERT4.MAP"
#define MAPSTR_DESERT5              "DESERT5.MAP"
#define MAPSTR_DESERT6              "DESERT6.MAP"
#define MAPSTR_DESERT7              "DESERT7.MAP"
#define MAPSTR_COAST3               "COAST3.MAP"
#define MAPSTR_COAST4               "COAST4.MAP"
#define MAPSTR_COAST5               "COAST5.MAP"
#define MAPSTR_COAST6               "COAST6.MAP"
#define MAPSTR_COAST7               "COAST7.MAP"
#define MAPSTR_COAST8               "COAST8.MAP"
#define MAPSTR_COAST9               "COAST9.MAP"
#define MAPSTR_RAIDERS1             "RAIDERS1.MAP"
#define MAPSTR_RAIDERS2             "RAIDERS2.MAP"
#define MAPSTR_BHRNDDST             "BHRNDDST.MAP"
#define MAPSTR_BHRNDMNT             "BHRNDMNT.MAP"
#define MAPSTR_RNDWHALE             "RNDWHALE.MAP"
#define MAPSTR_RNDTINWD             "RNDTINWD.MAP"
#define MAPSTR_RNDBHEAD             "RNDBHEAD.MAP"
#define MAPSTR_RNDSHUTL             "RNDSHUTL.MAP"
#define MAPSTR_RNDUWILG             "RNDUWILG.MAP"
#define MAPSTR_RNDBRIDG             "RNDBRIDG.MAP"
#define MAPSTR_RNDCAFE              "RNDCAFE.MAP"
#define MAPSTR_RNDHOLY1             "RNDHOLY1.MAP"
#define MAPSTR_RNDHOLY2             "RNDHOLY2.MAP"
#define MAPSTR_RNDFORVR             "RNDFORVR.MAP"
#define MAPSTR_RNDTOXIC             "RNDTOXIC.MAP"
#define MAPSTR_RNDPARIH             "RNDPARIH.MAP"
#define MAPSTR_RNDEXCOW             "RNDEXCOW.MAP"
#define MAPSTR_NAVARRO              "NAVARRO.MAP"

/*****************************************************************
********************    Map Entrance Points  *********************
*****************************************************************/

#define override_map_start_hex(x,y,z)   override_map_start(x%200,x/200,y,z)

#define DEN_SLAVE_RUN_SUCCESS       (10)

/*****************************************************************
********************       Elevators       ***********************
*****************************************************************/


/*****************************************************************
********************    Random Encounters  ***********************
*****************************************************************/

/* The following define is to force critter X to face critter Y */
#define Face_Critter(Y,X)           anim(X,ANIMATE_ROTATION,rotation_to_tile(tile_num(X),tile_num(Y)))

/* The following define will set a rotation arc for placement
   of critters. */
#define FixRotationArc(X)           while (X < 0) do begin      \
                                        X += 6;                 \
                                    end                         \
                                    if (X > 5) then             \
                                        X := X%6


/* The following define will give you the inverse (Y) of a
   rotation (X) */
#define InvertRotation(X,Y)         X+=3;                       \
                                    FixRotationArc(X)

#endif // MAPS_H









