/*
	Copyright 1998-2003 Interplay Entertainment Corp.  All rights reserved.
*/

#ifndef ENCTRP_H
#define ENCTRP_H

/* Terminal Locations based on the map

   _____ _____ _____
  |     |     |     |
  |  1  |  2  |  3  |
  |_____|_____|_____|
   _____ _____ _____
  |     |     |     |
  |  4  |  5  |  6  |
  |_____|_____|_____|
   _____ _____ _____
  |     |     |     |
  |  7  |  8  |  9  |
  |_____|_____|_____|
*/

#define TERM_1                      (17911)
#define TERM_2                      (17702)
#define TERM_3                      (17891)

#define TERM_4                      (19712)
#define TERM_5                      (19901)
#define TERM_6                      (19692)

#define TERM_7                      (21911)
#define TERM_8                      (21702)
#define TERM_9                      (21891)

// Door Locations
#define DOOR_1E                     (18510)
#define DOOR_1S                     (19516)
#define DOOR_2N                     (17506)
#define DOOR_2E                     (18500)
#define DOOR_2S                     (19506)
#define DOOR_3S                     (19496)

#define DOOR_4E                     (20510)
#define DOOR_4S                     (21516)
#define DOOR_4W                     (20520)
#define DOOR_5E                     (20500)
#define DOOR_5S                     (21506)
#define DOOR_6E                     (20490)
#define DOOR_6S                     (21496)

#define DOOR_7E                     (22510)
#define DOOR_8E                     (22500)
#define DOOR_8S                     (23506)

// Map Vars
#define MVAR_Found_Easter_Egg       (0)
#define MVAR_Egg_Counter            (1)
#define MVAR_Electric_Floor         (2)
#define MVAR_Lockpick_Penalty       (3)


#define FLOOR_ACTIVE                (0)
#define FLOOR_INACTIVE              (1)

#define EGG_HIDDEN                  (0)
#define EGG_FOUND                   (1)

#endif // ENCTRP_H
