#ifndef SPAWNS_H

#include "D:\Game Files\Fallout 2\HEADERS\RANDOMMAP.H"

procedure Pick_Large_Cockroach_PID;
procedure Pick_Small_Cockroach_PID;
procedure Pick_Cockroach_PID;
procedure Pick_Centaur_PID;
procedure Pick_Floater_PID;
procedure Pick_Aliens_PID;
procedure Pick_Alien_PID;
procedure Pick_Fire_Gecko_PID;
procedure Pick_Golden_Gecko_PID;
procedure Pick_Silver_Gecko_PID;
procedure Pick_Gecko_PID;
procedure Pick_Mole_Rat_PID;
procedure Pick_Pig_Rat_PID;
procedure Pick_Rats_PID;
procedure Pick_Rat_PID;
procedure Pick_Large_Deathclaw_PID;
procedure Pick_Small_Deathclaw_PID;
procedure Pick_Deathclaw_PID;
procedure Spawn_Critter(variable picked, Variable Critter_Hex,variable Script,variable Elev);
procedure Delete_All_Critters;
procedure Delete_All_Blockers(variable top_left,variable top_right,variable bottom_left,variable bottom_right);
procedure Pick_Fruit_Fly_PID;
procedure Pick_Black_Ant_PID;
procedure Pick_Mantis_PID;
procedure Pick_Red_Ant_PID;
procedure Pick_Vanilla_Art_Ant_PID;
procedure Pick_Ant_PID;
procedure Pick_Spore_Plant_PID;
procedure Pick_Mutant_PID;
procedure Pick_Ghoul_PID;
procedure Pick_Sentry_Bot_PID;
procedure Pick_Humans_PID;
procedure Pick_Woman_PID;
procedure Pick_Man_PID;
procedure Pick_Large_Radscorpion_PID;
procedure Pick_Small_Radscorpion_PID;
procedure Pick_Brahmin_PID;
procedure Pick_Dog_PID;
procedure Pick_Radscorpion_PID;
procedure DeleteBones;
procedure Delete_All_Outside_Main(variable top_left,variable top_right,variable bottom_left,variable bottom_right);

#define MVAR_Spawned          0
#define MVAR_Elev_One_Count   1
#define MVAR_Elev_Two_Count   2
#define MVAR_Spam_Critters    3

variable Spam_Critters;

procedure Delete_All_Critters begin
variable count, critter_pid, item_list, item; 
   if (cur_map_index == MAP_ARROYO_CROP_FIELDS) or (cur_map_index == MAP_KLAMATH_FORREST) or (cur_map_index == MAP_RUINED_CITY)  or (cur_map_index == MAP_ORCHARD) or (cur_map_index == MAP_GRAVEYARD) or (cur_map_index == MAP_ABANDONED_MINE_FARM) then begin
      if (cur_map_index != MAP_ABANDONED_MINE_FARM) then begin
	     while (count < 1500) do begin
            critter_pid := 16777216 + count;
            kill_critter_type(critter_pid,KILL_DONT_LEAVE_BODY);
	        count := count + 1;
         end
	  end  
   end
end

procedure Delete_All_Blockers(variable top_left,variable top_right,variable bottom_left,variable bottom_right) begin
   variable count, critter_pid, item_list, item; 
   item_list:=list_begin(LIST_SCENERY);
   while(item_list != 0) do begin
      item:=list_next(item_list);
      if (item) then begin
	     if not(tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item))) then begin
		    if (obj_pid(item) == PID_BLOCKING_HEX) or (obj_pid(item) == PID_NO_LIGHT_BLOCKING_HEX) then begin //((scenery_base_number + 67) or (scenery_base_number + 128))) then begin
               move_to(item,0,0);
               destroy_object(item);
	           //display_msg("PID_BLOCKING_HEX");
	        end
		 end
	  end
      else begin
         list_end(item_list);
         item_list:=0;
      end
   end
end

procedure Delete_All_Outside_Main(variable top_left,variable top_right,variable bottom_left,variable bottom_right) begin
   variable count, critter_pid, item_list, item; 
   item_list:=list_begin(LIST_CRITTERS);
   while(item_list != 0) do begin
      item:=list_next(item_list);
      if (item) then begin
	     if tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) then begin
		 end
		 else begin 
            move_to(item,0,0);
            destroy_object(item);
	     end
	  end
      else begin
         list_end(item_list);
         item_list:=0;
      end
   end
   item_list:=list_begin(LIST_GROUNDITEMS);
   while(item_list != 0) do begin
      item:=list_next(item_list);
      if (item) then begin
	     if (tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) == 1) then begin
		 end
		 else
	     if (tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) == 0) then begin
            move_to(item,0,0);
            destroy_object(item);
	     end
	  end
      else begin
         list_end(item_list);
         item_list:=0;
      end
   end
   item_list:=list_begin(LIST_SCENERY);
   while(item_list != 0) do begin
      item:=list_next(item_list);
      if (item) then begin
	     if (tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) == 1) then begin
		 end
		 else
	     if (tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) == 0) then begin
            move_to(item,0,0);
            destroy_object(item);
	     end
	  end
      else begin
         list_end(item_list);
         item_list:=0;
      end
   end
   item_list:=list_begin(LIST_WALLS);
   while(item_list != 0) do begin
      item:=list_next(item_list);
      if (item) then begin
	     if (tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) == 1) then begin
		 end
		 else
	     if (tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) == 0) then begin
            move_to(item,0,0);
            destroy_object(item);
	     end
	  end
      else begin
         list_end(item_list);
         item_list:=0;
      end
   end
   item_list:=list_begin(LIST_MISC);
   while(item_list != 0) do begin
      item:=list_next(item_list);
      if (item) then begin
	     if (tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) == 1) then begin
		 end
		 else
	     if (tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) == 0) then begin
            move_to(item,0,0);
            destroy_object(item);
	     end
	  end
      else begin
         list_end(item_list);
         item_list:=0;
      end
   end
   item_list:=list_begin(LIST_SPATIAL);
   while(item_list != 0) do begin
      item:=list_next(item_list);
      if (item) then begin
	     if (tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) == 1) then begin
		 end
		 else
	     if (tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item)) == 0) then begin
            move_to(item,0,0);
            destroy_object(item);
	     end
	  end
      else begin
         list_end(item_list);
         item_list:=0;
      end
   end
/*    item_list:=list_begin(LIST_ALL);
   while(item_list != 0) do begin
      item:=list_next(item_list);
      if (item) then begin
	     if not(tile_in_tile_rect(top_left, top_right, bottom_left, bottom_right, tile_num(item))) then begin
            move_to(item,0,0);
            destroy_object(item);
		 end
	  end
      else begin
         list_end(item_list);
         item_list:=0;
      end
   end */
end

procedure DeleteBones begin
   variable count, critter_pid, item_list, item; 
   item_list:=list_begin(LIST_GROUNDITEMS);
   while(item_list != 0) do begin
      item:=list_next(item_list);
      if (item) then begin
	     if (obj_item_subtype(item) == item_type_container) then begin
		    if (obj_pid(item) == PID_HUMAN_BONES) then begin
               move_to(item,0,0);
               destroy_object(item);
	           //display_msg("PID_BLOCKING_HEX");
	        end
		 end
	  end
      else begin
         list_end(item_list);
         item_list:=0;
      end
   end
end

procedure Spawn_Critter(variable picked, Variable Critter_Hex,variable Script,variable Elev) begin
   //display_msg("picked : " + picked);
   variable critter_ptr := create_object_sid(picked, 0, 0, Script);
   if (critter_ptr) then begin
      critter_attempt_placement(critter_ptr, Critter_Hex, Elev);
	  //display_msg("Spawn_Critter : critter_pid is " + picked + " Ptr is " + critter_ptr);
   end else if (not(game_loaded)) then begin
      display_msg("Spawn_Critter procedure error : critter_pid is " + picked);
	  return;
   end
   if (get_ini_setting("Random_Encounters.ini|SETTINGS|Spam_Critter_Message")) and Is_Random_Encounter_Map and not(Spam_Critters) then begin
      Spam_Critters := 1;
	  float_msg(dude_obj, obj_name(critter_ptr),FLOAT_MSG_GREEN);
      display_msg(obj_name(critter_ptr));
   end 
   //display_msg("tile_num(critter_ptr) " + tile_num(critter_ptr) + " critter_ptr " + critter_ptr + " Critter_Hex " + Critter_Hex + " Elev " + Elev);
   if (cur_map_index == MAP_BROKEN_HILLS2) then begin
      if (Elev == 1) then begin
         set_map_var(30, map_var(30) + 1);
		 //display_msg("Add Elev 1 Map Var : " + map_var(30));
      end
      else
      if (Elev == 2) then begin
         set_map_var(29, map_var(29) + 1);
		 //display_msg("Add Elev 2 Map Var : " + map_var(29));
      end
   end
   else
   if(cur_map_index == MAP_SAN_FRAN_TANKER) then begin
      set_global_var(GVAR_SANFRAN_MOB_COUNTER, global_var(GVAR_SANFRAN_MOB_COUNTER) +1);
   end 
   else 
   if(cur_map_index == MAP_MODOC_GARDEN) then begin
      set_global_var(GVAR_MODOC_MOB_COUNTER, global_var(GVAR_MODOC_MOB_COUNTER) +1);
   end 
   else 
   if(cur_map_index == MAP_REDDING_DTOWN_TUNNEL) then begin
      set_global_var(GVAR_REDDING_D_MOB_COUNTER, global_var(GVAR_REDDING_D_MOB_COUNTER) +1);
   end 
   else 
   if(cur_map_index == MAP_REDDING_MINE_TUNNEL) then begin
      set_global_var(GVAR_REDDING_M_MOB_COUNTER, global_var(GVAR_REDDING_M_MOB_COUNTER) +1);
   end 
   else 
   if (cur_map_index == MAP_REDDING_WANAMINGO_12) then begin
      if (Elev == 1) then begin
		 set_map_var(1, map_var(1) + 1);
	  end
	  else
	  if (Elev == 0) then begin
		 set_map_var(0, map_var(0) + 1);
	  end
   end 
   else
   if (cur_map_index == MAP_ABANDONED_MINE_3_4) then begin
      if (Elev == 0) then begin
         set_map_var(0, map_var(0) + 1);
      end
      else
      if (Elev == 1) then begin
         set_map_var(1, map_var(1) + 1);
      end
   end
   else
   if (cur_map_index == MAP_ABANDONED_MINE_1_2) then begin
      if (Elev == 0) then begin
         set_map_var(0, map_var(0) + 1);
      end
      else
      if (Elev == 1) then begin
         set_map_var(1, map_var(1) + 1);
      end
   end
   else
   if (cur_map_index == MAP_ABANDONED_MINE_FARM) then begin
      if (Elev == 0) then begin
         set_map_var(6, map_var(6) + 1);
      end
      else
      if (Elev == 1) then begin
         set_map_var(7, map_var(7) + 1);
      end
      else
      if (Elev == 2) then begin
         set_map_var(8, map_var(8) + 1);
      end
   end
   else
   if (cur_map_index == MAP_ARROYO_CROP_FIELDS) then begin
      if (Elev == 0) then begin
         set_map_var(2, map_var(2) + 1);
      end
      else
      if (Elev == 1) then begin
         set_map_var(3, map_var(3) + 1);
      end
      else
      if (Elev == 2) then begin
         set_map_var(4, map_var(4) + 1);
      end
   end
   else
   if (cur_map_index == MAP_KLAMATH_FORREST) then begin
      if (Elev == 0) then begin
         set_map_var(2, map_var(2) + 1);
      end
      else
      if (Elev == 1) then begin
         set_map_var(3, map_var(3) + 1);
      end
      else
      if (Elev == 2) then begin
         set_map_var(4, map_var(4) + 1);
      end
   end
   else
   if (cur_map_index == MAP_RUINED_CITY) then begin
      if (Elev == 0) then begin
         set_map_var(2, map_var(2) + 1);
      end
      else
      if (Elev == 1) then begin
         set_map_var(3, map_var(3) + 1);
      end
      else
      if (Elev == 2) then begin
         set_map_var(4, map_var(4) + 1);
      end
   end
   else
   if (cur_map_index == MAP_LARGE_CAVE) then begin
      if (Elev == 0) then begin
         set_map_var(0, map_var(0) + 1);
		 //display_msg("Added To Elv 0");
      end
      else
      if (Elev == 1) then begin
         set_map_var(1, map_var(1) + 1);
		 //display_msg("Added To Elv 1");
      end
      else
      if (Elev == 2) then begin
         set_map_var(2, map_var(2) + 1);
		 //display_msg("Added To Elv 2");
      end
   end
   else
   if (Is_Random_Encounter_Map) then begin
      if (Elev == 1) then begin
         set_map_var(1, map_var(1) + 1);
		 //display_msg("Added To Elv 1 " + map_var(1));
      end
      else
      if (Elev == 2) then begin
         set_map_var(2, map_var(2) + 1);
		 //display_msg("Added To Elv 2 " + map_var(2));
      end
   end
   else
   if (cur_map_index == MAP_ORCHARD) then begin
      if (Elev == 0) then begin
         set_map_var(2, map_var(2) + 1);
	     //display_msg("Added To Elv 0 " + map_var(2));
      end
      else
      if (Elev == 1) then begin
         set_map_var(3, map_var(3) + 1);
	     //display_msg("Added To Elv 2 " + map_var(3));
      end
      else
       if (Elev == 2) then begin
         set_map_var(4, map_var(4) + 1);
	     //display_msg("Added To Elv 3 " + map_var(4));
      end
   end //MAP_VT23IN
   else
   if (cur_map_index == MAP_VT23IN) then begin
      if (Elev == 0) then begin
         set_map_var(3, map_var(3) + 1);
	     //display_msg("Added To Elv 0 " + map_var(3));
      end
      else
      if (Elev == 1) then begin
         set_map_var(4, map_var(4) + 1);
	     //display_msg("Added To Elv 2 " + map_var(4));
      end
      else
       if (Elev == 2) then begin
         set_map_var(5, map_var(5) + 1);
	     //display_msg("Added To Elv 3 " + map_var(5));
      end
   end 
   else
   if (cur_map_index == MAP_GRAVEYARD) then begin
      if (Elev == 0) then begin
         set_map_var(0, map_var(0) + 1);
	     //display_msg("Added To Elv 0 " + map_var(0));
      end
      else
      if (Elev == 1) then begin
         set_map_var(1, map_var(1) + 1);
	     //display_msg("Added To Elv 2 " + map_var(1));
      end
      else
       if (Elev == 2) then begin
         set_map_var(2, map_var(2) + 1);
	     //display_msg("Added To Elv 3 " + map_var(2));
      end
   end 
   else
   if (cur_map_index == MAP_V32) then begin
      if (Elev == 0) then begin
         set_map_var(1, map_var(1) + 1);
	     //display_msg("Added To Elv 0 " + map_var(1));
      end
      else
      if (Elev == 1) then begin
         set_map_var(2, map_var(2) + 1);
	     //display_msg("Added To Elv 2 " + map_var(2));
      end
      else
       if (Elev == 2) then begin
         set_map_var(3, map_var(3) + 1);
	     //display_msg("Added To Elv 3 " + map_var(3));
      end
   end 
   else
   if (cur_map_index == MAP_V33) then begin
      if (Elev == 0) then begin
         set_map_var(1, map_var(1) + 1);
	     //display_msg("Added To Elv 0 " + map_var(1));
      end
      else
      if (Elev == 1) then begin
         set_map_var(2, map_var(2) + 1);
	     //display_msg("Added To Elv 2 " + map_var(2));
      end
      else
       if (Elev == 2) then begin
         set_map_var(3, map_var(3) + 1);
	     //display_msg("Added To Elv 3 " + map_var(3));
      end
   end 
   else
   if (cur_map_index == MAP_V34) then begin
      if (Elev == 0) then begin
         set_map_var(1, map_var(1) + 1);
	     //display_msg("Added To Elv 0 " + map_var(1));
      end
      else
      if (Elev == 1) then begin
         set_map_var(2, map_var(2) + 1);
	     //display_msg("Added To Elv 2 " + map_var(2));
      end
      else
       if (Elev == 2) then begin
         set_map_var(3, map_var(3) + 1);
	     //display_msg("Added To Elv 3 " + map_var(3));
      end
   end
   if (tile_num(critter_ptr) != Critter_Hex) then begin
      critter_heal(critter_ptr, -50000);
      set_obj_visibility(critter_ptr, 1);
      if (cur_map_index == MAP_BROKEN_HILLS2) then begin
         if (Elev == 1) then begin
            set_map_var(30, map_var(30) - 1);
			//display_msg("Sub Elev 1 Map Var : " + map_var(30));
         end
         else
         if (Elev == 2) then begin
            set_map_var(29, map_var(29) - 1);
			//display_msg("Sub Elev 2 Map Var : " + map_var(29));
         end
      end
      else
      if(cur_map_index == MAP_SAN_FRAN_TANKER) then begin
         set_global_var(GVAR_SANFRAN_MOB_COUNTER, global_var(GVAR_SANFRAN_MOB_COUNTER) -1);
      end 
      else 
      if(cur_map_index == MAP_MODOC_GARDEN) then begin
         set_global_var(GVAR_MODOC_MOB_COUNTER, global_var(GVAR_MODOC_MOB_COUNTER) -1);
      end 
      else 
      if(cur_map_index == MAP_REDDING_DTOWN_TUNNEL) then begin
         set_global_var(GVAR_REDDING_D_MOB_COUNTER, global_var(GVAR_REDDING_D_MOB_COUNTER) -1);
      end 
      else 
      if(cur_map_index == MAP_REDDING_MINE_TUNNEL) then begin
         set_global_var(GVAR_REDDING_M_MOB_COUNTER, global_var(GVAR_REDDING_M_MOB_COUNTER) -1);
      end 
      else 
      if (cur_map_index == MAP_REDDING_WANAMINGO_12) then begin
        if (Elev == 1) then begin
		    set_map_var(1, map_var(1) - 1);
		end
		 else
		 if (Elev == 0) then begin
		    set_map_var(0, map_var(0) - 1);
		end
      end 
      else
      if (cur_map_index == MAP_ABANDONED_MINE_3_4) then begin
         if (Elev == 0) then begin
            set_map_var(0, map_var(0) - 1);
         end
         else
         if (Elev == 1) then begin
            set_map_var(1, map_var(1) - 1);
         end
      end
      else
      if (cur_map_index == MAP_ABANDONED_MINE_1_2) then begin
         if (Elev == 0) then begin
            set_map_var(0, map_var(0) - 1);
         end
         else
         if (Elev == 1) then begin
            set_map_var(1, map_var(1) - 1);
         end
      end
      else
      if (cur_map_index == MAP_ABANDONED_MINE_FARM) then begin
         if (Elev == 0) then begin
            set_map_var(6, map_var(6) - 1);
         end
         else
         if (Elev == 1) then begin
            set_map_var(7, map_var(7) - 1);
         end
         else
         if (Elev == 2) then begin
            set_map_var(8, map_var(8) - 1);
         end
      end
      else
      if (cur_map_index == MAP_ARROYO_CROP_FIELDS) then begin
         if (Elev == 0) then begin
            set_map_var(2, map_var(2) - 1);
         end
         else
         if (Elev == 1) then begin
            set_map_var(3, map_var(3) - 1);
         end
         else
         if (Elev == 2) then begin
            set_map_var(4, map_var(4) - 1);
         end
      end
      else
      if (cur_map_index == MAP_KLAMATH_FORREST) then begin
         if (Elev == 0) then begin
            set_map_var(2, map_var(2) - 1);
         end
         else
         if (Elev == 1) then begin
            set_map_var(3, map_var(3) - 1);
         end
         else
         if (Elev == 2) then begin
            set_map_var(4, map_var(4) - 1);
         end
      end
      else
      if (cur_map_index == MAP_RUINED_CITY) then begin
         if (Elev == 0) then begin
            set_map_var(2, map_var(2) - 1);
         end
         else
         if (Elev == 1) then begin
            set_map_var(3, map_var(3) - 1);
         end
         else
         if (Elev == 2) then begin
            set_map_var(4, map_var(4) - 1);
         end
      end
      else
      if (cur_map_index == MAP_LARGE_CAVE) then begin
         if (Elev == 0) then begin
            set_map_var(0, map_var(0) - 1);
			//display_msg("Subtracted From Elv 0");
         end
         else
         if (Elev == 1) then begin
            set_map_var(1, map_var(1) - 1);
			//display_msg("Subtracted From Elv 1");
         end
         else
         if (Elev == 2) then begin
            set_map_var(2, map_var(2) - 1);
			//display_msg("Subtracted From Elv 2");
         end
      end
      else
	  if (Is_Random_Encounter_Map) then begin
         if (Elev == 1) then begin
            set_map_var(1, map_var(1) - 1);
		    //display_msg("Subtracted From Elv 1 " + map_var(1));
         end
         else
         if (Elev == 2) then begin
            set_map_var(2, map_var(2) - 1);
		    //display_msg("Subtracted From Elv 22 " + map_var(2));
         end
      end
      else
	  if (cur_map_index == MAP_ORCHARD) then begin
         if (Elev == 0) then begin
            set_map_var(2, map_var(2) - 1);
			//display_msg("Subtracted From Elv 0 " + map_var(2));
         end
         else
         if (Elev == 1) then begin
            set_map_var(3, map_var(3) - 1);
			//display_msg("Subtracted From Elv 1 " + map_var(3));
         end
         else
         if (Elev == 2) then begin
            set_map_var(4, map_var(4) - 1);
			//display_msg("Subtracted From Elv 2 " + map_var(4));
         end
      end
      else
      if (cur_map_index == MAP_VT23IN) then begin
         if (Elev == 0) then begin
            set_map_var(3, map_var(3) - 1);
			//display_msg("Subtracted From Elv 0 " + map_var(3));
         end
         else
         if (Elev == 1) then begin
            set_map_var(4, map_var(4) - 1);
			//display_msg("Subtracted From Elv 1 " + map_var(4));
         end
         else
         if (Elev == 2) then begin
            set_map_var(5, map_var(5) - 1);
			//display_msg("Subtracted From Elv 2 " + map_var(5));
         end
      end
      else
      if (cur_map_index == MAP_GRAVEYARD) then begin
         if (Elev == 0) then begin
            set_map_var(0, map_var(0) - 1);
			//display_msg("Subtracted From Elv 0 " + map_var(0));
         end
         else
         if (Elev == 1) then begin
            set_map_var(1, map_var(1) - 1);
			//display_msg("Subtracted From Elv 1 " + map_var(1));
         end
         else
         if (Elev == 2) then begin
            set_map_var(2, map_var(2) - 1);
			//display_msg("Subtracted From Elv 2 " + map_var(2));
		 end
      end
      else
      if (cur_map_index == MAP_V32) then begin
         if (Elev == 0) then begin
            set_map_var(1, map_var(1) - 1);
			//display_msg("Subtracted From Elv 0 " + map_var(1));
         end
         else
         if (Elev == 1) then begin
            set_map_var(2, map_var(2) - 1);
			//display_msg("Subtracted From Elv 1 " + map_var(2));
         end
         else
         if (Elev == 2) then begin
            set_map_var(3, map_var(3) - 1);
			//display_msg("Subtracted From Elv 2 " + map_var(3));
         end
      end
      else
      if (cur_map_index == MAP_V33) then begin
         if (Elev == 0) then begin
            set_map_var(1, map_var(1) - 1);
			//display_msg("Subtracted From Elv 0 " + map_var(1));
         end
         else
         if (Elev == 1) then begin
            set_map_var(2, map_var(2) - 1);
			//display_msg("Subtracted From Elv 1 " + map_var(2));
         end
         else
         if (Elev == 2) then begin
            set_map_var(3, map_var(3) - 1);
			//display_msg("Subtracted From Elv 2 " + map_var(3));
         end
      end
      else
      if (cur_map_index == MAP_V34) then begin
         if (Elev == 0) then begin
            set_map_var(1, map_var(1) - 1);
			//display_msg("Subtracted From Elv 0 " + map_var(1));
         end
         else
         if (Elev == 1) then begin
            set_map_var(2, map_var(2) - 1);
			//display_msg("Subtracted From Elv 1 " + map_var(2));
         end
         else
         if (Elev == 2) then begin
            set_map_var(3, map_var(3) - 1);
			//display_msg("Subtracted From Elv 2 " + map_var(3));
         end
	  end
   end
end

procedure Pick_Ant_PID
begin
   variable Critter_PID;
   variable Chance;
   Chance := random(1,3);
   if (chance == 1) then begin
      Critter_PID := Pick_Vanilla_Art_Ant_PID;
   end
   else
   if (chance == 2) then begin
      Critter_PID := Pick_Red_Ant_PID;
   end
   else
   if (chance == 3) then begin
      Critter_PID := Pick_Black_Ant_PID;
   end
   return Critter_PID;
end

procedure Pick_Deathclaw_PID begin
   variable Critter_PID;
   variable Chance;
   Chance := random(1,2);
   if (Chance == 1) then begin
      Critter_PID := Pick_Small_Deathclaw_PID;
   end else begin 
      Critter_PID := Pick_Large_Deathclaw_PID;
   end

   return Critter_PID;
end

procedure Pick_Radscorpion_PID begin
   variable Critter_PID;
   variable Chance;
   Chance := random(1,2);
   if (Chance == 1) then begin
      Critter_PID := Pick_Small_Radscorpion_PID;
   end else begin 
      Critter_PID := Pick_Large_Radscorpion_PID;
   end

   return Critter_PID;
end

procedure Pick_Small_Deathclaw_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_SMALL_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_SMALL_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_SMALL_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_SMALL_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_SMALL_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_SMALL_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_SMALL_DEATHCLAW;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_SMALL_DEATHCLAW;
   end 
   return Critter_PID;
end

procedure Pick_Large_Deathclaw_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_LARGE_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_LARGE_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_LARGE_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_LARGE_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_LARGE_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_LARGE_DEATHCLAW;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_LARGE_DEATHCLAW;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_LARGE_DEATHCLAW;
   end 
   return Critter_PID;
end

procedure Pick_Rat_PID begin
   variable Critter_PID;
   variable Chance;
   Chance := random(1,3);
   if (Chance == 1) then begin
      Critter_PID := Pick_Rats_PID;
   end else if (Chance == 2) then begin
      Critter_PID := Pick_Pig_Rat_PID;
   end else begin
      Critter_PID := Pick_Mole_Rat_PID;
   end
   return Critter_PID;
end

procedure Pick_Rats_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_RAT;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_RAT;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_RAT;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_RAT;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_RAT;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_RAT;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_RAT;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_RAT;
   end 
   return Critter_PID;
end

procedure Pick_Pig_Rat_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_PIG_RAT;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_PIG_RAT;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_PIG_RAT;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_PIG_RAT;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_PIG_RAT;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_PIG_RAT;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_PIG_RAT;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_PIG_RAT;
   end 
   return Critter_PID;
end

procedure Pick_Mole_Rat_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_MOLE_RAT;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_MOLE_RAT;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_MOLE_RAT;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_MOLE_RAT;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_MOLE_RAT;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_MOLE_RAT;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_MOLE_RAT;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_MOLE_RAT;
   end 
   return Critter_PID;
end

procedure Pick_Gecko_PID begin
   variable Critter_PID;
   variable Chance;
   Chance := random(1,3);
   if (Chance == 1) then begin
      Critter_PID := Pick_Silver_Gecko_PID;
   end else if (Chance == 2) then begin
      Critter_PID := Pick_Golden_Gecko_PID;
   end else begin
      Critter_PID := Pick_Fire_Gecko_PID;
   end
   return Critter_PID;
end

procedure Pick_Silver_Gecko_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_SILVER_GECKO;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_SILVER_GECKO;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_SILVER_GECKO;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_SILVER_GECKO;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_SILVER_GECKO;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_SILVER_GECKO;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_SILVER_GECKO;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_SILVER_GECKO;
   end 
   return Critter_PID;
end

procedure Pick_Golden_Gecko_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_GOLDEN_GECKO;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_GOLDEN_GECKO;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_GOLDEN_GECKO;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_GOLDEN_GECKO;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_GOLDEN_GECKO;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_GOLDEN_GECKO;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_GOLDEN_GECKO;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_GOLDEN_GECKO;
   end 
   return Critter_PID;
end

procedure Pick_Fire_Gecko_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_FIRE_GECKO;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_FIRE_GECKO;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_FIRE_GECKO;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_FIRE_GECKO;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_FIRE_GECKO;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_FIRE_GECKO;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_FIRE_GECKO;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_FIRE_GECKO;
   end 
   return Critter_PID;
end

procedure Pick_Alien_PID begin
   variable Critter_PID;
   variable Chance;
   Chance := random(1,3);
   if (Chance == 1) then begin
      Critter_PID := Pick_Aliens_PID;
   end else if (Chance == 2) then begin
      Critter_PID := Pick_Floater_PID;
   end else begin
      Critter_PID := Pick_Centaur_PID;
   end
   //return PID_TOUGH_ALIEN;
   return Critter_PID;
end

procedure Pick_Aliens_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_ALIEN;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_ALIEN;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_ALIEN;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_ALIEN;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_ALIEN;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_ALIEN;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_ALIEN;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_ALIEN;
   end 
   return Critter_PID;
end

procedure Pick_Floater_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_FLOATER;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_FLOATER;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_FLOATER;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_FLOATER;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_FLOATER;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_FLOATER;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_FLOATER;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_FLOATER;
   end 
   return Critter_PID;
end

procedure Pick_Centaur_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_CENTAUR;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_CENTAUR;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_CENTAUR;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_CENTAUR;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_CENTAUR;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_CENTAUR;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_CENTAUR;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_CENTAUR;
   end 
   return Critter_PID;
end

procedure Pick_Cockroach_PID begin
   variable Critter_PID;
   variable Chance;
   Chance := random(1,2);
   if (Chance == 1) then begin
      Critter_PID := Pick_Small_Cockroach_PID;
   end else begin 
      Critter_PID := Pick_Large_Cockroach_PID;
   end
   return Critter_PID;
end

procedure Pick_Small_Cockroach_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_SMALL_COCKROACH;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_SMALL_COCKROACH;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_SMALL_COCKROACH;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_SMALL_COCKROACH;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_SMALL_COCKROACH;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_SMALL_COCKROACH;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_SMALL_COCKROACH;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_SMALL_COCKROACH;
   end 
   return Critter_PID;
end

procedure Pick_Large_Cockroach_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_LARGE_COCKROACH;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_LARGE_COCKROACH;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_LARGE_COCKROACH;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_LARGE_COCKROACH;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_LARGE_COCKROACH;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_LARGE_COCKROACH;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_LARGE_COCKROACH;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_LARGE_COCKROACH;
   end 
   return Critter_PID;
end

procedure Pick_Fruit_Fly_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_FRUIT_FLY;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_FRUIT_FLY;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_FRUIT_FLY;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_FRUIT_FLY;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_FRUIT_FLY;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_FRUIT_FLY;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_FRUIT_FLY;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_FRUIT_FLY;
   end 
   return Critter_PID;
end

procedure Pick_Vanilla_Art_Ant_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_ANT;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_ANT;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_ANT;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_ANT;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_ANT;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_ANT;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_ANT;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_ANT;
   end 
   return Critter_PID;
end

procedure Pick_Red_Ant_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_RED_ANT;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_RED_ANT;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_RED_ANT;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_RED_ANT;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_RED_ANT;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_RED_ANT;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_RED_ANT;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_RED_ANT;
   end 
   return Critter_PID;
end

procedure Pick_Black_Ant_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_BLACK_ANT;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_BLACK_ANT;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_BLACK_ANT;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_BLACK_ANT;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_BLACK_ANT;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_BLACK_ANT;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_BLACK_ANT;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_BLACK_ANT;
   end 
   return Critter_PID;
end

procedure Pick_Mantis_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_MANTIS;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_MANTIS;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_MANTIS;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_MANTIS;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_MANTIS;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_MANTIS;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_MANTIS;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_MANTIS;
   end 
   return Critter_PID;
end

procedure Pick_Spore_Plant_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_SPORE_PLANT;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_SPORE_PLANT;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_SPORE_PLANT;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_SPORE_PLANT;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_SPORE_PLANT;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_SPORE_PLANT;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_SPORE_PLANT;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_SPORE_PLANT;
   end 
   return Critter_PID;
end

procedure Pick_Mutant_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_MUTANT;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_MUTANT;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_MUTANT;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_MUTANT;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_MUTANT;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_MUTANT;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_MUTANT;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_MUTANT;
   end 
   return Critter_PID;
end

procedure Pick_Ghoul_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_GLOWING_GHOUL;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_GLOWING_GHOUL;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_GLOWING_GHOUL;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_GLOWING_GHOUL;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_GLOWING_GHOUL;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_GLOWING_GHOUL;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_GLOWING_GHOUL;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_GLOWING_GHOUL;
   end 
   return Critter_PID;
end

procedure Pick_Sentry_Bot_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_SENTRY_BOT;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_SENTRY_BOT;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_SENTRY_BOT;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_SENTRY_BOT;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_SENTRY_BOT;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_SENTRY_BOT;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_SENTRY_BOT;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_SENTRY_BOT;
   end 
   return Critter_PID;
end

procedure Pick_Humans_PID begin
   variable Critter_PID;
   variable Chance;
   Chance := random(1,2);
   if (Chance == 1) then begin
      Critter_PID := Pick_Woman_PID;
   end else begin 
      Critter_PID := Pick_Man_PID;
   end
   return Critter_PID;
end

procedure Pick_Woman_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_WOMAN;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_WOMAN;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_WOMAN;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_WOMAN;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_WOMAN;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_WOMAN;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_WOMAN;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_WOMAN;
   end 
   return Critter_PID;
end

procedure Pick_Man_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_MAN;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_MAN;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_MAN;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_MAN;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_MAN;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_MAN;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_MAN;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_MAN;
   end 
   return Critter_PID;
end

procedure Pick_Dog_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_DOG;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_DOG;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_DOG;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_DOG;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_DOG;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_DOG;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_DOG;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_DOG;
   end 
   return Critter_PID;
end

procedure Pick_Brahmin_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_BRAHMIN;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_BRAHMIN;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_BRAHMIN;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_BRAHMIN;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_BRAHMIN;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_BRAHMIN;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_BRAHMIN;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_BRAHMIN;
   end 
   return Critter_PID;
end

procedure Pick_Small_Radscorpion_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_SMALL_RADSCORPION;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_SMALL_RADSCORPION;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_SMALL_RADSCORPION;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_SMALL_RADSCORPION;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_SMALL_RADSCORPION;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_SMALL_RADSCORPION;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_SMALL_RADSCORPION;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_SMALL_RADSCORPION;
   end 
   return Critter_PID;
end

procedure Pick_Large_Radscorpion_PID begin
   variable Critter_PID;
   if (dude_level <= 10) then begin
      Critter_PID := PID_FIXIT_IMMATURE_LARGE_RADSCORPION;
   end 
   else 
   if ((dude_level >= 11) and (dude_level <= 20)) then begin
      Critter_PID := PID_FIXIT_YOUNG_LARGE_RADSCORPION;
   end 
   else 
   if ((dude_level >= 21) and (dude_level <= 30)) then begin
      Critter_PID := PID_FIXIT_MINOR_LARGE_RADSCORPION;
   end 
   else 
   if ((dude_level >= 31) and (dude_level <= 40)) then begin
      Critter_PID := PID_FIXIT_LESSER_LARGE_RADSCORPION;
   end 
   else 
   if ((dude_level >= 41) and (dude_level <= 50)) then begin
      Critter_PID := PID_FIXIT_NORMAL_LARGE_RADSCORPION;
   end 
   else 
   if ((dude_level >= 51) and (dude_level <= 60)) then begin
      Critter_PID := PID_FIXIT_STRONG_LARGE_RADSCORPION;
   end 
   else 
   if ((dude_level >= 61) and (dude_level <=70)) then begin
      Critter_PID := PID_FIXIT_RESILIENT_LARGE_RADSCORPION;
   end 
   else 
   if (dude_level >= 71) then begin
      Critter_PID := PID_FIXIT_TOUGH_LARGE_RADSCORPION;
   end 
   return Critter_PID;
end

procedure Pick_Encounter_PID begin
   variable Critter_PID;
   variable Chance;
   Chance := random(1,17);
   if (Chance == 1) then begin
      Critter_PID := Pick_Cockroach_PID;  
   end 
   else 
   if (Chance == 2) then begin
      Critter_PID := Pick_Alien_PID; 
   end 
   else 
   if (Chance == 3) then begin
      Critter_PID := Pick_Gecko_PID;
   end 
   else 
   if (Chance == 4) then begin
      Critter_PID := Pick_Rat_PID;
   end 
   else 
   if (Chance == 5) then begin
      Critter_PID := Pick_Deathclaw_PID;
   end  
   else 
   if (Chance == 6) then begin
      Critter_PID := Pick_Fruit_Fly_PID; 
   end 
   else 
   if (Chance == 7) then begin
      Critter_PID := Pick_Ant_PID;
   end 
   else 
   if (Chance == 8) then begin
      Critter_PID := Pick_Mantis_PID;
   end 
   else 
   if (Chance == 9) then begin
      Critter_PID := Pick_Spore_Plant_PID;
   end 
   else 
   if (Chance == 10) then begin
      Critter_PID := Pick_Mutant_PID;  
   end 
   else 
   if (Chance == 11) then begin
      Critter_PID := Pick_Ghoul_PID; 
   end 
   else 
   if (Chance == 12) then begin
      Critter_PID := Pick_Sentry_Bot_PID;  
   end 
   else 
   if (Chance == 13) then begin
      Critter_PID := Pick_Man_PID; 
   end 
   else 
   if (Chance == 14) then begin
      Critter_PID := Pick_Large_Radscorpion_PID;  
   end 
   else 
   if (Chance == 15) then begin
      Critter_PID := Pick_Small_Radscorpion_PID; 
   end 
   else 
   if (Chance == 16) then begin
      Critter_PID := Pick_Brahmin_PID;  
   end 
   else 
   if (Chance == 17) then begin
      Critter_PID := Pick_Dog_PID; 
   end 
   return Critter_PID;
end

#endif // SPWN_ALN_H




