#ifndef SCALE_DIFF_H
#define SCALE_DIFF_H

variable range_perks;
variable math;
variable float_math := 0.0;    
                                                                                                                                                                                                                                                                                                                                                                                                            
#define Is_Party(critter)                               ((party_member_obj(obj_pid(critter)) != 0) or (critter == dude_obj))

#define Is_Not_Party(critter)                           ((party_member_obj(obj_pid(critter)) != 0) == 0) and (critter != dude_obj)

#define Is_Not_Party_Pid(critter)                       (obj_pid(critter) != PID_MYRON) and (obj_pid(critter) != PID_MARCUS) and (obj_pid(critter) != PID_JOHN_MACRAE) and (obj_pid(critter) != PID_SULIK)                \
                                                        and (obj_pid(critter) != PID_LENNY) and (obj_pid(critter) != PID_CYBERDOG) and (obj_pid(critter) != PID_GORIS) and (obj_pid(critter) != PID_ROBOBRAIN)            \
                                                        and (obj_pid(critter) != PID_VIC) and (obj_pid(critter) != PID_DAVIN) and (obj_pid(critter) != PID_MIRIA) and (obj_pid(critter) != PID_KLINT)                     \
                                                        and (obj_pid(critter) != PID_DOGMEAT) and (obj_pid(critter) != PID_K9) and (obj_pid(critter) != PID_DIAGO) and (obj_pid(critter) != PID_MERIS)                    \
                                                        and (obj_pid(critter) != PID_SKYNET) and (obj_pid(critter) != PID_CAT_JULES) and (obj_pid(critter) != PID_KITSUNE) and (obj_pid(critter) != PID_DEX)              \
                                                        
procedure modify_critter(variable critter);
procedure CalculateBonuses;
procedure HealCritter(variable critter);
procedure MapEnterHealCritter(variable critter);

procedure modify_critter(variable critter)
begin
   //call CalculateBonuses;
   if ((Is_Not_Party(critter) and Is_Not_Party_Pid(critter) and (gv(party_buffed_too) == 0)) or ((critter != dude_obj) and (gv(party_buffed_too) == 1))) then begin
      if (get_critter_base_stat(critter, STAT_dmg_resist_emp) < 10) then begin
         set_critter_base_stat(critter, STAT_dmg_resist_emp, 10);
         set_critter_extra_stat(critter, STAT_max_hit_points, gv(health_finnal) + get_critter_extra_stat(critter, STAT_max_hit_points));
         critter_heal(critter, 100000);
         set_critter_extra_stat(critter, STAT_max_move_points, get_critter_extra_stat(critter, STAT_max_move_points) + gv(action_points_finnal));
         set_critter_extra_stat(critter, STAT_ac, get_critter_extra_stat(critter, STAT_ac) + gv(armor_finnal));
		 //display_msg("Check");
      end
   end
end

procedure CalculateBonuses
begin
   math := 0;
   if (gv(action_points_player_level_divide) > 0) then begin
      math := dude_level / gv(action_points_player_level_divide);
   end
   if ((gv(action_points_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(action_points_muliplier);
   end
   math := math + gv(action_points_static);
   sv(action_points_finnal, math);
   math := 0;
   if (gv(to_hit_player_level_divide) > 0) then begin
      math := dude_level / gv(to_hit_player_level_divide);
   end
   if ((gv(to_hit_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(to_hit_muliplier);
   end
   math := math + gv(to_hit_static);
   sv(to_hit_finnal, math);
   math := 0;
   if (gv(damage_resist_player_level_divide) > 0) then begin
      math := dude_level / gv(damage_resist_player_level_divide);
   end
   if ((gv(damage_resist_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(damage_resist_muliplier);
   end
   math := math + gv(damage_resist_static);
   sv(damage_resist_finnal, math);
   math := 0;
   if (gv(damage_threshold_player_level_divide) > 0) then begin
      math := dude_level / gv(damage_threshold_player_level_divide);
   end
   if ((gv(damage_threshold_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(damage_threshold_muliplier);
   end
   math := math + gv(damage_threshold_static);
   sv(damage_threshold_finnal, math);
   math := 0;
   if (gv(maximum_damage_level_divide) > 0) then begin
      math := dude_level / gv(maximum_damage_level_divide);
   end
   if ((gv(maximum_damage_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(maximum_damage_muliplier);
   end
   math := math + gv(maximum_damage_static);
   sv(maximum_damage_finnal, math);
   math := 0;
   if (gv(minimum_damage_player_level_divide) > 0) then begin
      math := dude_level / gv(minimum_damage_player_level_divide);
   end
   if ((gv(minimum_damage_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(minimum_damage_muliplier);
   end
   math := math + gv(minimum_damage_static);
   sv(minimum_damage_finnal, math);
   math := 0;
   if (gv(armor_player_level_divide) > 0) then begin
      math := dude_level / gv(armor_player_level_divide);
   end
   if ((gv(armor_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(armor_muliplier);
   end
   math := math + gv(armor_static);
   sv(armor_finnal, math);
   math := 0;
   if (gv(health_player_level_divide) > 0) then begin
      math := dude_level / gv(health_player_level_divide);
   end
   if ((gv(health_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(health_muliplier);
   end
   math := math + gv(health_static);
   sv(health_finnal, math);
   math := 0;
   if (gv(critic_percent_chance_player_level_divide) > 0) then begin
      math := dude_level / gv(critic_percent_chance_player_level_divide);
   end
   if ((gv(critic_percent_chance_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(critic_percent_chance_muliplier);
   end
   math := math + gv(critic_percent_chance_static);
   sv(critic_percent_chance_finnal, math);
   math := 0;
   if (gv(knockdown_player_level_divide) > 0) then begin
      math := dude_level / gv(knockdown_player_level_divide);
   end
   if ((gv(knockdown_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(knockdown_muliplier);
   end
   math := math + gv(knockdown_static);
   sv(knockdown_finnal, math);
   math := 0;
   if (gv(bypass_armor_player_level_divide) > 0) then begin
      math := dude_level / gv(bypass_armor_player_level_divide);
   end
   if ((gv(bypass_armor_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(bypass_armor_muliplier);
   end
   math := math + gv(bypass_armor_static);
   sv(bypass_armor_finnal, math);
   math := 0;
   if (gv(multiply_critical_damage_bonus_player_level_divide) > 0) then begin
      math := dude_level / gv(multiply_critical_damage_bonus_player_level_divide);
   end
   if ((gv(multiply_critical_damage_bonus_muliplier) > 0) and (math > 0)) then begin
      math := math * gv(multiply_critical_damage_bonus_muliplier);
   end
   math := math + gv(multiply_critical_damage_bonus_static);
   sv(multiply_critical_damage_bonus_finnal, math);
end

procedure HealCritter(variable critter)
begin
   if((Is_Not_Party(critter)) or ((critter != dude_obj) and gv(party_buffed_too) == 1)) and (not(combat_is_initialized)) and (not(critter_state(critter) bwand 2)) then begin           \
      critter_heal(critter, 100000);                                                                                                                                                            \
      critter_injure(critter, DAM_CRIP_LEG_LEFT BWOR DAM_CRIP_LEG_RIGHT BWOR DAM_CRIP_ARM_LEFT BWOR DAM_CRIP_ARM_RIGHT BWOR DAM_BLIND BWOR DAM_PERFORM_REVERSE);                              \
   end  
end

procedure MapEnterHealCritter(variable critter)
begin
   if((Is_Not_Party(critter)) or ((critter != dude_obj) and gv(party_buffed_too) == 1)) and (not(critter_state(critter) bwand 2)) then begin                                   \
      critter_heal(critter, 100000);                                                                                                                                                   \
   end  
end
           
//procedure Set_Globals;		   
#endif // SCALE_DIFF_H






