/*
	Copyright 1998-2003 Interplay Entertainment Corp.  All rights reserved.
*/

#ifndef ARGARDEN_H
#define ARGARDEN_H

//#include "C:\Game Files\Fallout 2\HEADERS\HERBS_P.H"
#include "C:\Game Files\Fallout 2\HEADERS\herbs_n.h"

//level 3
#define MARK00                                  (20728)
#define MARK01                                  (23709)
#define MARK02                                  (18082)
#define MARK03                                  (20103)
#define MARK04                                  (17301)
#define MARK05                                  (14882)
#define MARK06                                  (12701)

#define HEX_DEAD_DOG                            (23491)
#define HEX_DEAD_COUSIN                         (23894)
#define HEX_DEAD_GECKO                          (23491)

#define dude_level                                                              (get_pc_stat(1))
/************************************************
    Map Vars for Arroyo Garden Map
************************************************/

#define MVAR_Respawn_Timer                      (0)
#define MVAR_Kill_Runaway                       (1)
#define MVAR_Dog_Already_Dead                   (2)
#define MVAR_Last_Spot                          (3)

/**************************************************
    Formula Macros
**************************************************/

procedure Make_Plants(variable Elev);
procedure Make_Gecko(variable Elev);
procedure Make;
procedure Pick_PID;
procedure Next_Hex;
procedure Next_Hex_Spot;

variable picked;

procedure Next_Hex begin
   call Next_Hex_Spot;
   while (map_var(MVAR_Last_Spot) == -1) do begin
      call Next_Hex_Spot;
   end
end

procedure Next_Hex_Spot begin
   if (map_var(MVAR_Last_Spot) == 0) then begin
      set_map_var(MVAR_Last_Spot,MARK00);
   end else if (map_var(MVAR_Last_Spot) == MARK00) then begin
      set_map_var(MVAR_Last_Spot,MARK01);
   end else if (map_var(MVAR_Last_Spot) == MARK01) then begin
      set_map_var(MVAR_Last_Spot,MARK02);
   end else if (map_var(MVAR_Last_Spot) == MARK02) then begin
      set_map_var(MVAR_Last_Spot,MARK03);
   end else if (map_var(MVAR_Last_Spot) == MARK03) then begin
      set_map_var(MVAR_Last_Spot,MARK04);
   end else if (map_var(MVAR_Last_Spot) == MARK04) then begin
      set_map_var(MVAR_Last_Spot,MARK05);
   end else if (map_var(MVAR_Last_Spot) == MARK05) then begin
      set_map_var(MVAR_Last_Spot,MARK06);
   end else if (map_var(MVAR_Last_Spot) == MARK06) then begin
      set_map_var(MVAR_Last_Spot,MARK00);
   end
end

procedure Pick_PID begin
   if((dude_level >= 1) and (dude_level <= 5)) then begin
       picked := PID_GECKO_SMALL;
   end else if((dude_level >= 6) and (dude_level <= 10)) then begin
       picked := PID_TOUGH_GECKO_SMALL;
   end else if((dude_level >= 11) and (dude_level <= 15)) then begin
      picked := PID_GOLDEN_GECKO;
   end else if((dude_level >= 16) and (dude_level <= 20)) then begin
      picked := PID_TOUGH_GOLDEN_GECKO;
   end else if((dude_level >= 21) and (dude_level <= 25))then begin
      picked := PID_FIRE_GECKO;
   end else if(dude_level >= 26)then begin
      picked := PID_TOUGH_FIRE_GECKO;
   end
   return picked;
end

procedure Make_Gecko(variable Elev) begin
   variable Gecko_Counter:=0;
   variable New_Gecko:=0;
   variable item;
   variable item_hex;

// Gecko
   New_Gecko:=random(MIN_GECKO,MAX_GECKO);
   while (Gecko_Counter < New_Gecko) do begin
      call Next_Hex;
      call Pick_PID;
      item:=create_object_sid(picked,0,0,SCRIPT_ACGECKO);
      item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
      while (tile_contains_pid_obj(item_hex, Elev, 33554499)) do begin
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
      end
      critter_attempt_placement(item,item_hex,Elev);
      if(not(tile_contains_pid_obj(item_hex, Elev, picked))) then begin
         destroy_object(item);
      end
      Gecko_Counter+=1;
   end
end

procedure Make_Plants(variable Elev) begin
   variable New_Xanders:=0;
   variable Xanders:=0;
   variable New_Broc:=0;
   variable Broc:=0;
   variable New_Suomi:=0;
   variable Suomi:=0;
   variable New_Devils_Weed:=0;
   variable Devils_Weed:=0;
   variable New_Peyote:=0;
   variable Peyote:=0;
   variable New_Sunder_Sage:=0;
   variable Sunder_Sage:=0;
   variable New_Sorrel:=0;
   variable Sorrel:=0;
   variable New_Lycanya_Flowers:=0;
   variable Lycanya_Flowers:=0;
   variable New_Bruho_Mushrooms:=0;
   variable Bruho_Mushrooms:=0;
   variable New_Marjoram:=0;
   variable Marjoram:=0;
   variable New_Scariosa:=0;
   variable Scariosa:=0;
   variable item;
   variable item_hex;

// Xander Root
   New_Xanders:=random(MIN_XANDER_ROOT,MAX_XANDER_ROOT);
   if (Xanders < New_Xanders) then begin
      while (Xanders < New_Xanders) do begin
         call Next_Hex;
         item:=create_object(PID_XANDER_ROOT,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Xanders := Xanders +1;
      end
   end
// Broc Flower
   New_Broc:=random(MIN_BROC_FLOWER,MAX_BROC_FLOWER);
   if (Broc < New_Broc) then begin
      while (Broc < New_Broc) do begin
         call Next_Hex;
         item:=create_object(PID_BROC_FLOWER,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Broc := Broc + 1;
      end
   end
// Suomi
   New_Suomi:=random(MIN_SUOMI,MAX_SUOMI);
   if (Suomi < New_Suomi) then begin
      while (Suomi < New_Suomi) do begin
         call Next_Hex;
         item:=create_object(PID_SOUMI_EARS,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Suomi := Suomi + 1;
      end
   end
// Devils_Weed
   New_Devils_Weed:=random(MIN_DEVILS_WEED,MAX_DEVILS_WEED);
   if (Devils_Weed < New_Devils_Weed) then begin
      while (Devils_Weed < New_Devils_Weed) do begin
         call Next_Hex;
         item:=create_object(PID_DEVILS_WEED,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Devils_Weed := Devils_Weed + 1;
      end
   end
// Peyote
   New_Peyote:=random(MIN_PEYOTE,MAX_PEYOTE);
   if (Peyote < New_Peyote) then begin
      while (Peyote < New_Peyote) do begin
         call Next_Hex;
         item:=create_object(PID_PEYOTE,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Peyote := Peyote + 1;
      end
   end
// Bruho Mushrooms
   New_Bruho_Mushrooms := random(MIN_BRUHO_MUSHROOMS,MAX_BRUHO_MUSHROOMS);
   if (Bruho_Mushrooms < New_Bruho_Mushrooms) then begin
      while (Bruho_Mushrooms < New_Bruho_Mushrooms) do begin
         call Next_Hex;
         item:=create_object(PID_BRUHO_MUSHROOMS,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Bruho_Mushrooms := Bruho_Mushrooms + 1;
      end
   end
// Lycanya Flowers
   New_Lycanya_Flowers := random(MIN_LYCANYA_FLOWERS,MAX_LYCANYA_FLOWERS);
   if (Lycanya_Flowers < New_Lycanya_Flowers) then begin
      while (Lycanya_Flowers < New_Lycanya_Flowers) do begin
         call Next_Hex;
         item:=create_object(PID_LYCANYA_FLOWER,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Lycanya_Flowers := Lycanya_Flowers + 1;
      end
   end
// Sorrel
   New_Sorrel := random(MIN_SORREL,MAX_SORREL);
   if (Sorrel < New_Sorrel) then begin
      while (Sorrel < New_Sorrel) do begin
         call Next_Hex;
         item:=create_object(PID_SORREL,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Sorrel := Sorrel + 1;
      end
   end
// Sunder Sage
   New_Sunder_Sage := random(MIN_SUNDER_SAGE,MAX_SUNDER_SAGE);
   if (Sunder_Sage < New_Sunder_Sage) then begin
      while (Sunder_Sage < New_Sunder_Sage) do begin
         call Next_Hex;
         item:=create_object(PID_SUNDER_SAGE,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Sunder_Sage := Sunder_Sage + 1;
      end
   end
// Marjoram
   New_Marjoram := random(MIN_MARJORAM,MAX_MARJORAM);
   if (Marjoram < New_Marjoram) then begin
      while (Marjoram < New_Marjoram) do begin
         call Next_Hex;
         item:=create_object(PID_MARJORAM,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Marjoram := Marjoram + 1;
      end
   end
// Scariosa
   New_Scariosa := random(MIN_SCARIOSA,MAX_SCARIOSA);
   if (Scariosa < New_Scariosa) then begin
      while (Scariosa < New_Scariosa) do begin
         call Next_Hex;
         item:=create_object(PID_SCARIOSA,0,0);
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
            item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,5));
         end
         move_to(item,item_hex,Elev);
         Scariosa := Scariosa + 1;
      end
   end
end

procedure Make begin
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Gecko(0);
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Gecko(1);
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Gecko(2);
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Plants(0);
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Plants(1);
   set_map_var(MVAR_Last_Spot, 0);
   call Make_Plants(2);
end

#endif // ARGARDEN_H