#ifndef KLAMCROP_H
#define KLAMCROP_H

#define MARK00                                  (22142)
#define MARK01                                  (23727)
#define MARK02                                  (25311)
#define MARK03                                  (23087)
#define MARK04                                  (21100)
#define MARK05                                  (20313)
#define MARK06                                  (18926)
#define MARK07                                  (15718)
#define MARK08                                  (12105)
#define MARK09                                  (16498)
#define MARK10                                  (12685)
#define MARK11                                  (17483)
#define MARK12                                  (18472)
#define MARK13                                  (14665)

#define MVAR_Respawn_Timer                      (0)
#define MVAR_Last_Spot                          (1)
#define MVAR_Elev_0_counter                     (2)
#define MVAR_Elev_1_counter                     (3)
#define MVAR_Elev_2_counter                     (4)

procedure Next_Hex;
procedure Next_Hex_Spot;
procedure Make_Critters(variable Elev);
procedure Make_Plants(variable Elev);
procedure Make;
procedure Spawn_Bone_Containers(variable Elev);
procedure MakeBones;

procedure MakeBones begin
   call Next_Hex;
   call Spawn_Bone_Containers(0);
   call Next_Hex;   
   call Spawn_Bone_Containers(1);
   call Next_Hex;
   call Spawn_Bone_Containers(2);
end

procedure Next_Hex begin
   call Next_Hex_Spot;
   while (map_var(MVAR_Last_Spot) == -1) do begin
      call Next_Hex_Spot;
   end
end

procedure Next_Hex_Spot begin
   if (map_var(MVAR_Last_Spot) == MARK00) or not(map_var(MVAR_Last_Spot))  then begin
      set_map_var(MVAR_Last_Spot,MARK01);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK01) then begin
      set_map_var(MVAR_Last_Spot,MARK02);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK02) then begin
      set_map_var(MVAR_Last_Spot,MARK03);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK03) then begin
      set_map_var(MVAR_Last_Spot,MARK04);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK04) then begin
      set_map_var(MVAR_Last_Spot,MARK05);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK05) then begin
      set_map_var(MVAR_Last_Spot,MARK06);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK06) then begin
      set_map_var(MVAR_Last_Spot,MARK07);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK07) then begin
      set_map_var(MVAR_Last_Spot,MARK08);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK08) then begin
      set_map_var(MVAR_Last_Spot,MARK09);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK09) then begin
      set_map_var(MVAR_Last_Spot,MARK10);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK10) then begin
      set_map_var(MVAR_Last_Spot,MARK11);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK11) then begin
      set_map_var(MVAR_Last_Spot,MARK12);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK12) then begin
      set_map_var(MVAR_Last_Spot,MARK13);
   end 
   else 
   if (map_var(MVAR_Last_Spot) == MARK13) then begin
      set_map_var(MVAR_Last_Spot,MARK00);
   end
end

procedure Make_Critters(variable Elev) begin
   variable Critter_Counter:=0;
   variable New_Critter:=0;
   variable Item;
   variable Item_Hex;
   variable Critter_PID;

// Critter
   New_Critter:=random(MIN_CRITTERS,MAX_CRITTERS);
   //New_Critter:=2;
   while (Critter_Counter < New_Critter) do begin
      call Next_Hex;
      Critter_PID := Pick_Rat_PID;
      //display_msg("PID : " + Pick_Cockroach_PID);
	  Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,8));
      call Spawn_Critter(Critter_PID,Item_Hex,SCRIPT_ECALIEN,Elev);	
      Critter_Counter+=1;
   end
end

procedure Spawn_Bone_Containers(variable Elev) begin
   variable num_of_bones := random(12,24);
   variable item_hex,bones;
   variable count;
   //call Next_Hex;
   while (count < num_of_bones) do begin
      call Next_Hex;
      item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
      while (tile_contains_pid_obj(item_hex, Elev, 33554499) != 0) do begin
         item_hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
      end
      bones := create_object_sid(PID_HUMAN_BONES,item_hex,Elev,-1);
	  if (tile_num(bones) != item_hex) then begin
	     destroy_object(bones);
	  end
	  count := count + 1;
   end
end

procedure Make_Plants(variable Elev) begin
   variable New_Xanders:=0;
   variable Xanders:=0;
   variable New_Broc:=0;
   variable Broc:=0;
   variable New_Suomi:=0;
   variable Suomi:=0;
   variable New_Devils_Weed:=0;
   variable Devils_Weed:=0;
   variable New_Peyote:=0;
   variable Peyote:=0;
   variable New_Sunder_Sage:=0;
   variable Sunder_Sage:=0;
   variable New_Sorrel:=0;
   variable Sorrel:=0;
   variable New_Lycanya_Flowers:=0;
   variable Lycanya_Flowers:=0;
   variable New_Bruho_Mushrooms:=0;
   variable Bruho_Mushrooms:=0;
   variable New_Marjoram:=0;
   variable Marjoram:=0;
   variable New_Scariosa:=0;
   variable Scariosa:=0;
   variable Item:=0;
   variable Item_Hex:=0;

// Xander Root
   New_Xanders:=random(MIN_XANDER_ROOT,MAX_XANDER_ROOT);
   if (Xanders < New_Xanders) then begin
      while (Xanders < New_Xanders) do begin
         call Next_Hex;
         Item:=create_object(PID_XANDER_ROOT,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Xanders := Xanders +1;
      end
   end
// Broc Flower
   New_Broc:=random(MIN_BROC_FLOWER,MAX_BROC_FLOWER);
   if (Broc < New_Broc) then begin
      while (Broc < New_Broc) do begin
         call Next_Hex;
         Item:=create_object(PID_BROC_FLOWER,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Broc := Broc + 1;
      end
   end
// Suomi
   New_Suomi:=random(MIN_SUOMI,MAX_SUOMI);
   if (Suomi < New_Suomi) then begin
      while (Suomi < New_Suomi) do begin
         call Next_Hex;
         Item:=create_object(PID_SOUMI_EARS,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Suomi := Suomi + 1;
      end
   end
// Devils_Weed
   New_Devils_Weed:=random(MIN_DEVILS_WEED,MAX_DEVILS_WEED);
   if (Devils_Weed < New_Devils_Weed) then begin
      while (Devils_Weed < New_Devils_Weed) do begin
         call Next_Hex;
         Item:=create_object(PID_DEVILS_WEED,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Devils_Weed := Devils_Weed + 1;
      end
   end
// Peyote
   New_Peyote:=random(MIN_PEYOTE,MAX_PEYOTE);
   if (Peyote < New_Peyote) then begin
      while (Peyote < New_Peyote) do begin
         call Next_Hex;
         Item:=create_object(PID_PEYOTE,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Peyote := Peyote + 1;
      end
   end
// Bruho Mushrooms
   New_Bruho_Mushrooms := random(MIN_BRUHO_MUSHROOMS,MAX_BRUHO_MUSHROOMS);
   if (Bruho_Mushrooms < New_Bruho_Mushrooms) then begin
      while (Bruho_Mushrooms < New_Bruho_Mushrooms) do begin
         call Next_Hex;
         Item:=create_object(PID_BRUHO_MUSHROOMS,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Bruho_Mushrooms := Bruho_Mushrooms + 1;
      end
   end
// Lycanya Flowers
   New_Lycanya_Flowers := random(MIN_LYCANYA_FLOWERS,MAX_LYCANYA_FLOWERS);
   if (Lycanya_Flowers < New_Lycanya_Flowers) then begin
      while (Lycanya_Flowers < New_Lycanya_Flowers) do begin
         call Next_Hex;
         Item:=create_object(PID_LYCANYA_FLOWER,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Lycanya_Flowers := Lycanya_Flowers + 1;
      end
   end
// Sorrel
   New_Sorrel := random(MIN_SORREL,MAX_SORREL);
   if (Sorrel < New_Sorrel) then begin
      while (Sorrel < New_Sorrel) do begin
         call Next_Hex;
         Item:=create_object(PID_SORREL,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Sorrel := Sorrel + 1;
      end
   end
// Sunder Sage
   New_Sunder_Sage := random(MIN_SUNDER_SAGE,MAX_SUNDER_SAGE);
   if (Sunder_Sage < New_Sunder_Sage) then begin
      while (Sunder_Sage < New_Sunder_Sage) do begin
         call Next_Hex;
         Item:=create_object(PID_SUNDER_SAGE,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Sunder_Sage := Sunder_Sage + 1;
      end
   end
// Marjoram
   New_Marjoram := random(MIN_MARJORAM,MAX_MARJORAM);
   if (Marjoram < New_Marjoram) then begin
      while (Marjoram < New_Marjoram) do begin
         call Next_Hex;
         Item:=create_object(PID_MARJORAM,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Marjoram := Marjoram + 1;
      end
   end
// Scariosa
   New_Scariosa := random(MIN_SCARIOSA,MAX_SCARIOSA);
   if (Scariosa < New_Scariosa) then begin
      while (Scariosa < New_Scariosa) do begin
         call Next_Hex;
         Item:=create_object(PID_SCARIOSA,0,0);
         Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         while (tile_contains_pid_obj(Item_Hex, Elev, 33554499) != 0) do begin
            Item_Hex:=tile_num_in_direction(map_var(MVAR_Last_Spot),random(0,5),random(0,9));
         end
         move_to(Item,Item_Hex,Elev);
	     if (tile_num(Item) != item_hex) then begin
	        destroy_object(Item);
	     end
         Scariosa := Scariosa + 1;
      end
   end
end

procedure Make begin
   set_map_var(MVAR_Elev_0_counter, 0);
   set_map_var(MVAR_Elev_1_counter, 0);
   set_map_var(MVAR_Elev_2_counter, 0);
   //display_msg("spawned");
   //set_map_var(MVAR_Last_Spot, 0);
   call Make_Critters(0);
   //display_msg("critter 0");
   //set_map_var(MVAR_Last_Spot, 0);
   call Make_Critters(1);
   //display_msg("critter 1");
   //set_map_var(MVAR_Last_Spot, 0);
   call Make_Critters(2);
   //display_msg("critter 2");
   //set_map_var(MVAR_Last_Spot, 0);
   call Make_Plants(0);
   //display_msg("herbs 0");
   //set_map_var(MVAR_Last_Spot, 0);
   call Make_Plants(1);
   //display_msg("herbs 1");
   //set_map_var(MVAR_Last_Spot, 0);
   call Make_Plants(2);
   //display_msg("herbs 2");
end


#endif // KLAMCROP_H