/*
	Copyright 1998-2003 Interplay Entertainment Corp.  All rights reserved.
*/

#ifndef _ITEMPID_H_DEFINED
#define _ITEMPID_H_DEFINED

/******************************************************************
   File Name: ItemPid.H

   Note: This file is arranged differently than all the other
         header files. Rather than having all of the items in the
         order in which they appear in the item list, they will
         be sorted, but the Pid number defines will remain as they
         are in the item list. Please do not alter numbers, unless
         it is to fix errors found through mapper.

         SKIPPING PIDs 60-70   BECAUSE THEY ARE DESKS AND BOOKCASES
         SKIPPING PIDs 145-158 BECAUSE THEY ARE DESKS AND BOOKCASES
         SKIPPING PIDs 164-179 BECAUSE THEY ARE FALLOUT 1 SPECIFIC
         SKIPPING PIDs 181-204 BECAUSE THEY ARE FALLOUT 1 SPECIFIC
         SKIPPING PIDs 213-217 BECAUSE THEY ARE FALLOUT 1 SPECIFIC
         SKIPPING PIDs 230-231 BECAUSE THEY ARE FALLOUT 1 SPECIFIC
         SKIPPING PID  238     BECAUSE THEY ARE FALLOUT 1 SPECIFIC

   Purpose: This file will contain defines for all the item
            prototypes for the game. These prototypes can be
            found in mapper using <F1> or selecting items. All
            defines in here will need to be prepended with PID_
            for the ease of everyone. Additionally, Please do not
            make duplicate names for the same item. Most should
            have the correct name.

   Structure: The following is the structure of this file.
                I.    Armor
                II.   Weapons
                III.  Ammo
                IV.   Medical
                V.    Containers
                VI.   Books
                VII.  Tools
                VIII. Misc.
                IX.   Active_Items
                X.    Flying Weapons

   Created: October 02, 1997
******************************************************************/


/******************************************************************
***************       Armor                         ***************
******************************************************************/

#define PID_LEATHER_ARMOR                   (1)
#define PID_METAL_ARMOR                     (2)
#define PID_POWERED_ARMOR                   (3)
#define PID_COMBAT_ARMOR                    (17)
#define PID_LEATHER_JACKET                  (74)
#define PID_PURPLE_ROBE                     (113)
#define PID_HARDENED_POWER_ARMOR            (232)
#define PID_BROTHERHOOD_COMBAT_ARMOR        (239)
#define PID_TESLA_ARMOR                     (240)
#define PID_CURED_LEATHER_ARMOR             (265)
#define PID_ADVANCED_POWER_ARMOR            (348)
#define PID_ADVANCED_POWER_ARMOR_MK2        (349)
#define PID_LEATHER_ARMOR_MK_II             (379)
#define PID_METAL_ARMOR_MK_II               (380)
#define PID_COMBAT_ARMOR_MK_II              (381)

/******************************************************************
***************       Weapons                       ***************
******************************************************************/

#define PID_KNIFE                           (4)
#define PID_CLUB                            (5)
#define PID_SLEDGEHAMMER                    (6)
#define PID_SPEAR                           (7)
#define PID_10MM_PISTOL                     (8)
#define PID_10MM_SMG                        (9)
#define PID_HUNTING_RIFLE                   (10)
#define PID_FLAMER                          (11)
#define PID_MINIGUN                         (12)
#define PID_ROCKET_LAUNCHER                 (13)
#define PID_PLASMA_RIFLE                    (15)
#define PID_LASER_PISTOL                    (16)
#define PID_DESERT_EAGLE                    (18)
#define PID_ROCK                            (19)
#define PID_CROWBAR                         (20)
#define PID_BRASS_KNUCKLES                  (21)
#define PID_14MM_PISTOL                     (22)
#define PID_ASSAULT_RIFLE                   (23)
#define PID_PLASMA_PISTOL                   (24)
#define PID_FRAG_GRENADE                    (25)
#define PID_PLASMA_GRENADE                  (26)
#define PID_PULSE_GRENADE                   (27)
#define PID_GATLING_LASER                   (28)
#define PID_THROWING_KNIFE                  (45)
#define PID_SHOTGUN                         (94)
#define PID_SUPER_SLEDGE                    (115)
#define PID_RIPPER                          (116)
#define PID_LASER_RIFLE                     (118)
#define PID_ALIEN_LASER_PISTOL              (120)
#define PID_9MM_MAUSER                      (122)
#define PID_SNIPER_RIFLE                    (143)
#define PID_MOLOTOV_COCKTAIL                (159)
#define PID_CATTLE_PROD                     (160)
#define PID_RED_RYDER_BB_GUN                (161)
#define PID_RED_RYDER_LE_BB_GUN             (162)
#define PID_TURBO_PLASMA_RIFLE              (233)
#define PID_SPIKED_KNUCKLES                 (234)
#define PID_POWER_FIST                      (235)
#define PID_COMBAT_KNIFE                    (236)
#define PID_223_PISTOL                      (241)
#define PID_COMBAT_SHOTGUN                  (242)
#define PID_JONNY_BB_GUN                    (261)
#define PID_HK_CAWS                         (268)
#define PID_ROBO_ROCKET_LAUNCHER            (270)
#define PID_SHARP_SPEAR                     (280)
#define PID_SCOPED_HUNTING_RIFLE            (287)
#define PID_EYEBALL_FIST_1                  (290)
#define PID_EYEBALL_FIST_2                  (291)
#define PID_BOXING_GLOVES                   (292)
#define PID_PLATED_BOXING_GLOVES            (293)
#define PID_HK_P90C                         (296)
#define PID_SPRINGER_RIFLE                  (299)
#define PID_ZIP_GUN                         (300)
#define PID_44_MAGNUM_REVOLVER              (313)
#define PID_SWITCHBLADE                     (319)
#define PID_SHARPENED_POLE                  (320)
#define PID_PLANT_SPIKE                     (365)
#define PID_DEATHCLAW_CLAW_1                (371)
#define PID_DEATHCLAW_CLAW_2                (372)
#define PID_TOMMY_GUN                       (283)
#define PID_GREASE_GUN                      (332)
#define PID_BOZAR                           (350)
#define PID_LIGHT_SUPPORT_WEAPON            (355)
#define PID_FN_FAL                          (351)
#define PID_HK_G11                          (352)
#define PID_PIPE_RIFLE                      (353)
#define PID_PANCOR_JACKHAMMER               (354)
#define PID_SHIV                            (383)
#define PID_WRENCH                          (384)
#define PID_LOUISVILLE_SLUGGER              (386)
#define PID_SOLAR_SCORCHER                  (390)  // No ammo
#define PID_SAWED_OFF_SHOTGUN               (385)  // 12 ga.
#define PID_M60                             (387)  // 7.62
#define PID_NEEDLER_PISTOL                  (388)  // HN Needler
#define PID_AVENGER_MINIGUN                 (389)  // 5mm JHP
#define PID_HK_G11E                         (391)  // 4.7mm Caseless
#define PID_M72_GAUSS_RIFLE                 (392)  // 2mm EC
#define PID_PHAZER                          (393)  // Small Energy
#define PID_PK12_GAUSS_PISTOL               (394)  // 2mm EC
#define PID_VINDICATOR_MINIGUN              (395)  // 4.7mm Caseless
#define PID_YK32_PULSE_PISTOL               (396)  // Small Energy
#define PID_YK42B_PULSE_RIFLE               (397)  // Micro Fusion
#define PID_44_MAGNUM_SPEEDLOADER           (398)
#define PID_SUPER_CATTLE_PROD               (399)
#define PID_IMPROVED_FLAMETHROWER           (400)
#define PID_LASER_RIFLE_EXT_CAP             (401)
#define PID_MAGNETO_LASER_PISTOL            (402)
#define PID_FN_FAL_NIGHT_SCOPE              (403)
#define PID_DESERT_EAGLE_EXT_MAG            (404)
#define PID_ASSAULT_RIFLE_EXT_MAG           (405)
#define PID_PLASMA_PISTOL_EXT_CART          (406)
#define PID_MEGA_POWER_FIST                 (407)
#define PID_HOLY_HAND_GRENADE               (421) //Special don't use this
#define PID_FLAME_BREATH                    (427)
#define PID_RING_BOXING_GLOVES              (496)
#define PID_RING_PLATED_BOXING_GLOVES       (497)
#define PID_FN_FAL_HPFA                     (500)
//#define PID_BLOW_UP_DOLL                    (508)
//#define PID_POPPED_BLOW_UP_DOLL             (509)
#define PID_TYPHON_TREASURE                 (519)


//vanilla not defined,these invalid items used im my auto lot mod

#define PID_END_BOSS_KNIFE                  (530)
#define PID_END_BOSS_PLASMA_WEAP            (531)





// NOTE: any new weapons that need ammo of any sort need to be placed in the arm_obj macro in COMMANDS.H
//       if you're not gonna do it, please put the pid definition after the comments so that we know to add it
//       thank you for your support

//Below not YET added to arm_obj macro

/******************************************************************
***************       Ammo                          ***************
******************************************************************/

#define PID_EXPLOSIVE_ROCKET                (14)
#define PID_10MM_JHP                        (29)
#define PID_10MM_AP                         (30)
#define PID_44_MAGNUM_JHP                   (31)
#define PID_FLAMETHROWER_FUEL               (32)
#define PID_14MM_AP                         (33)
#define PID_223_FMJ                         (34)
#define PID_5MM_JHP                         (35)
#define PID_5MM_AP                          (36)
#define PID_ROCKET_AP                       (37)
#define PID_SMALL_ENERGY_CELL               (38)
#define PID_MICRO_FUSION_CELL               (39)
#define PID_SHOTGUN_SHELLS                  (95)
#define PID_44_FMJ_MAGNUM                   (111)
#define PID_9MM_BALL                        (121)
#define PID_BBS                             (163)
#define PID_ROBO_ROCKET_AMMO                (274)
#define PID_45_CALIBER_AMMO                 (357)
#define PID_2MM_EC_AMMO                     (358)
#define PID_4_7MM_CASELESS                  (359)
#define PID_9MM_AMMO                        (360)
#define PID_HN_NEEDLER_CARTRIDGE            (361)
#define PID_HN_AP_NEEDLER_CARTRIDGE         (362)
#define PID_7_62MM_AMMO                     (363)
#define PID_FLAMETHROWER_FUEL_MK_II         (382)


/******************************************************************
***************       Medical                       ***************
******************************************************************/

#define PID_STIMPAK                         (40)
#define PID_FIRST_AID_KIT                   (47)
#define PID_RADAWAY                         (48)
#define PID_ANTIDOTE                        (49)
#define PID_MENTATS                         (53)
#define PID_MUTATED_FRUIT                   (71)
#define PID_BUFFOUT                         (87)
#define PID_DOCTORS_BAG                     (91)
#define PID_RAD_X                           (109)
#define PID_PSYCHO                          (110)
#define PID_SUPER_STIMPAK                   (144)

#define PID_JET                             (259)
#define PID_JET_ANTIDOTE                    (260)
#define PID_BROC_FLOWER                     (271)
#define PID_XANDER_ROOT                     (272)
#define PID_HEALING_POWDER                  (273)
#define PID_MEAT_JERKY                      (284)
#define PID_HYPODERMIC_NEEDLE               (318)
#define PID_MUTAGENIC_SYRUM                 (329)
#define PID_HEART_PILLS                     (333)
#define PID_HYPO_POISON                     (334)
#define PID_FIELD_MEDIC_KIT                 (408)
#define PID_PARAMEDICS_BAG                  (409)
#define PID_MONUMENT_CHUNCK                 (424)
#define PID_MEDICAL_SUPPLIES                (428)


/******************************************************************
***************       Container                     ***************
******************************************************************/

#define PID_FRIDGE                          (42)
#define PID_ICE_CHEST_LEFT                  (43)
#define PID_ICE_CHEST_RIGHT                 (44)
#define PID_BAG                             (46)
#define PID_BACKPACK                        (90)
#define PID_BROWN_BAG                       (93)
#define PID_FOOTLOCKER_CLEAN_LEFT           (128)
#define PID_FOOTLOCKER_RUSTY_LEFT           (129)
#define PID_FOOTLOCKER_CLEAN_RIGHT          (130)
#define PID_FOOTLOCKER_RUSTY_RIGHT          (131)
#define PID_LOCKER_CLEAN_LEFT               (132)
#define PID_LOCKER_RUSTY_LEFT               (133)
#define PID_LOCKER_CLEAN_RIGHT              (134)
#define PID_LOCKER_RUSTY_RIGHT              (135)
#define PID_WALL_LOCKER_CLEAN_LEFT          (136)
#define PID_WALL_LOCKER_CLEAN_RIGHT         (137)
#define PID_WALL_LOCKER_RUSTY_LEFT          (138)
#define PID_WALL_LOCKER_RUSTY_RIGHT         (139)
#define PID_CONTAINER_WOOD_CRATE            (180)
#define PID_VAULT_DWELLER_BONES             (211)
#define PID_SMALL_POT                       (243)
#define PID_TALL_POT                        (244)
#define PID_CHEST                           (245)
#define PID_LEFT_ARROYO_BOOKCASE            (246)
#define PID_RIGHT_ARROYO_BOOKCASE           (247)
#define PID_OLIVE_POT                       (248)
#define PID_FLOWER_POT                      (249)
#define PID_HUMAN_BONES                     (250)
#define PID_ANNA_BONES                      (251)
#define PID_CRASHED_VERTI_BIRD              (330)
#define PID_GRAVESITE_1                     (344)
#define PID_GRAVESITE_2                     (345)
#define PID_GRAVESITE_3                     (346)
#define PID_GRAVESITE_4                     (347)
#define PID_LG_LT_AMMO_CRATE                (367)
#define PID_SM_LT_AMMO_CRATE                (368)
#define PID_LG_RT_AMMO_CRATE                (369)
#define PID_SM_RT_AMMO_CRATE                (370)
#define PID_LF_GRAVESITE_1                  (374)
#define PID_LF_GRAVESITE_2                  (375)
#define PID_LF_GRAVESITE_3                  (376)

#define PID_HIDDEN_CONTAINER                (467)  // Code item  JLR


//not included in vanilla,these are art ends for some shelves,thye arent containers but with being able to pick up 1k+ wieghted items,must be defined
#define PID_BOOKSHELF_1                     (148)
#define PID_BOOKSHELF_2                     (150)
#define PID_SHELVES_1                       (154)
#define PID_SHELVES_2                       (156)

/******************************************************************
***************       Books                         ***************
******************************************************************/

#define PID_BIG_BOOK_OF_SCIENCE             (73)
#define PID_DEANS_ELECTRONICS               (76)
#define PID_FIRST_AID_BOOK                  (80)
#define PID_SCOUT_HANDBOOK                  (86)
#define PID_GUNS_AND_BULLETS                (102)
#define PID_CATS_PAW                        (225)
#define PID_TECHNICAL_MANUAL                (228)
#define PID_CHEMISTRY_MANUAL                (237)

#define PID_SLAG_MESSAGE                    (263)
#define PID_CATS_PAW_ISSUE_5                (331)


/******************************************************************
***************       Tools                         ***************
******************************************************************/

#define PID_DYNAMITE                        (51)
#define PID_GEIGER_COUNTER                  (52)
///#define PID_STEALTH_BOY                     (54)  // Disabled FO2 7/22/98 JLR
#define PID_MOTION_SENSOR                   (59)
#define PID_MULTI_TOOL                      (75)
#define PID_ELECTRONIC_LOCKPICKS            (77)
#define PID_LOCKPICKS                       (84)
#define PID_PLASTIC_EXPLOSIVES              (85)
#define PID_ROPE                            (127)

#define PID_EXP_LOCKPICK_SET                (410)
#define PID_ELEC_LOCKPICK_MKII              (411)


/******************************************************************
***************       Misc.                         ***************
******************************************************************/

#define PID_BOTTLE_CAPS                     (41)
#define RESERVED_ITEM_00                     (50) // Reserved item! Don't use! Broken!
#define PID_WATER_CHIP                      (55)
#define PID_DOG_TAGS                        (56)
#define PID_ELECTRONIC_BUG                  (57)
#define PID_HOLODISK                        (58)
#define PID_BRIEFCASE                       (72)
#define PID_FUZZY_PAINTING                  (78)
#define PID_FLARE                           (79)
#define PID_IGUANA_ON_A_STICK               (81)
#define PID_KEY                             (82)
#define PID_KEYS                            (83)
#define PID_WATCH                           (88)
#define PID_MOTOR                           (89)
#define PID_SCORPION_TAIL                   (92)
#define PID_RED_PASS_KEY                    (96)
#define PID_BLUE_PASS_KEY                   (97)
#define PID_PUMP_PARTS                      (98)
#define PID_GOLD_LOCKET                     (99)
#define PID_RADIO                           (100)
#define PID_LIGHTER                         (101)
#define PID_MEAT_ON_A_STICK                 (103)
#define PID_TAPE_RECORDER                   (104)
#define PID_NUKE_KEY                        (105)
#define PID_NUKA_COLA                       (106)
#define PID_ALIEN_SIDE                      (107)
#define PID_ALIEN_FORWARD                   (108)
#define PID_URN                             (112)
#define PID_TANGLERS_HAND                   (114)
#define PID_FLOWER                          (117)
#define PID_NECKLACE                        (119)
#define PID_PSYCHIC_NULLIFIER               (123)
#define PID_BEER                            (124)
#define PID_BOOZE                           (125)
#define PID_WATER_FLASK                     (126)
#define PID_ACCESS_CARD                     (140)
#define PID_BLACK_COC_BADGE                 (141)
#define PID_RED_COC_BADGE                   (142)
#define PID_BARTER_TANDI                    (212)
#define PID_BARTER_LIGHT_HEALING            (218)
#define PID_BARTER_MEDIUM_HEALING           (219)
#define PID_BARTER_HEAVY_HEALING            (220)
#define PID_SECURITY_CARD                   (221)
#define PID_TOGGLE_SWITCH                   (222)
#define PID_YELLOW_PASS_KEY                 (223)
#define PID_SMALL_STATUETTE                 (224)
#define PID_BOX_OF_NOODLES                  (226)
#define PID_FROZEN_DINNER                   (227)
#define PID_MOTIVATOR                       (229)
#define PID_JAIL_KEY                        (456)

#define PID_ANNA_GOLD_LOCKET                (252)
#define PID_CAR_FUEL_CELL_CONTROLLER        (253)
#define PID_CAR_FUEL_INJECTION              (254)
#define PID_DAY_PASS                        (255)
#define PID_FAKE_CITIZENSHIP                (256)
#define PID_CORNELIUS_GOLD_WATCH            (257)
#define PID_HY_MAG_PART                     (258)
#define PID_RUBBER_BOOTS                    (262)
#define PID_SMITH_COOL_ITEM                 (264)
#define PID_VIC_RADIO                       (266)
#define PID_VIC_WATER_FLASK                 (267)
#define PID_ROBOT_PARTS                     (269)
#define PID_TROPHY_OF_RECOGNITION           (275)
#define PID_GECKO_PELT                      (276)
#define PID_GOLDEN_GECKO_PELT               (277)
#define PID_FLINT                           (278)
#define PID_NEURAL_INTERFACE                (279)
#define PID_DIXON_EYE                       (281)
#define PID_CLIFTON_EYE                     (282)
#define PID_RADSCORPION_PARTS               (285)
#define PID_FIREWOOD                        (286)
#define PID_CAR_FUEL_CELL                   (288)
#define PID_SHOVEL                          (289)
#define PID_HOLODISK_FAKE_V13               (294)
#define PID_CHEEZY_POOFS                    (295)
#define PID_PLANK                           (297)
#define PID_TRAPPER_TOWN_KEY                (298)
#define PID_CLIPBOARD                       (301)
#define PID_GECKO_DATA_DISK                 (302)
#define PID_REACTOR_DATA_DISK               (303)
#define PID_DECK_OF_TRAGIC_CARDS            (304)
#define PID_YELLOW_REACTOR_KEYCARD          (305)
#define PID_RED_REACTOR_KEYCARD             (306)
#define PID_PLASMA_TRANSFORMER              (307)
#define PID_SUPER_TOOL_KIT                  (308)
#define PID_TALISMAN                        (309)
#define PID_GAMMA_GULP_BEER                 (310)
#define PID_ROENTGEN_RUM                    (311)
#define PID_PART_REQUISITION_FORM           (312)
#define PID_BLUE_CONDOM                     (314)
#define PID_GREEN_CONDOM                    (315)
#define PID_RED_CONDOM                      (316)
#define PID_COSMETIC_CASE                   (317)
#define PID_CYBERNETIC_BRAIN                (321)
#define PID_HUMAN_BRAIN                     (322)
#define PID_CHIMP_BRAIN                     (323)
#define PID_ABNORMAL_BRAIN                  (324)
#define PID_DICE                            (325)
#define PID_LOADED_DICE                     (326)
#define PID_EASTER_EGG                      (327)
#define PID_MAGIC_8_BALL                    (328)
#define PID_MOORE_BAD_BRIEFCASE             (335)
#define PID_MOORE_GOOD_BRIEFCASE            (336)
#define PID_LYNETTE_HOLO                    (337)
#define PID_WESTIN_HOLO                     (338)
#define PID_SPY_HOLO                        (339)
#define PID_DR_HENRY_PAPERS                 (340)
#define PID_PRESIDENTIAL_PASS               (341)
#define PID_RANGER_PIN                      (342)
#define PID_RANGER_MAP                      (343)
#define PID_COMPUTER_VOICE_MODULE           (356)
#define PID_GECK                            (366)
#define PID_V15_KEYCARD                     (373)
#define PID_V15_COMPUTER_PART               (377)
#define PID_COOKIE                          (378)
#define PID_OIL_CAN                         (412)
#define PID_STABLES_ID_BADGE                (413)
#define PID_VAULT_13_SHACK_KEY              (414)
#define PID_SPECTACLES                      (415)     // DO NOT USE THIS IN YOUR SCRIPTS, THIS IS SPECIAL CASE
#define PID_EMPTY_JET                       (416)     // DO NOT USE THIS IN YOUR SCRIPTS, THIS IS SPECIAL CASE
#define PID_OXYGEN_TANK                     (417)     // DO NOT USE THIS IN YOUR SCRIPTS, THIS IS SPECIAL CASE
#define PID_POISON_TANK                     (418)     // DO NOT USE THIS IN YOUR SCRIPTS, THIS IS SPECIAL CASE
#define PID_MINE_PART                       (419)     // DO NOT USE THIS IN YOUR SCRIPTS, THIS IS SPECIAL CASE
#define PID_MORNING_STAR_MINE               (420)
#define PID_HOLY_HAND_GRENADE               (421)
#define PID_EXCAVATOR_CHIP                  (422)
#define PID_GOLD_NUGGET                     (423)
#define PID_STONE_HEAD                      (425)
#define PID_URANIUM_ORE                     (426)
#define PID_FIRE_GECKO_FLAME_WEAPON         (427)
#define PID_GOLD_TOOTH                      (429)
#define PID_HOWITZER_SHELL                  (430)
#define PID_RAMIREZ_BOX_CLOSED              (431)
#define PID_RAMIREZ_BOX_OPEN                (432)
#define PID_MIRROR_SHADES                   (433)
#define PID_WAGON_RED                       (434)
#define PID_WAGON_GREY                      (435)
#define PID_DECK_OF_CARDS                   (436)
#define PID_MARKED_DECK_OF_CARDS            (437)
#define PID_TEMPLE_KEY                      (438)
#define PID_POCKET_LINT                     (439)
#define PID_BIO_GEL                         (440)
#define PID_BLONDIE_DOG_TAG                 (441)
#define PID_ANGEL_EYES_DOG_TAG              (442)
#define PID_TUCO_DOG_TAG                    (443)
#define PID_RAIDERS_MAP                     (444)
#define PID_SHERIFF_BADGE                   (445)
#define PID_VERTIBIRD_PLANS                 (446)
#define PID_BISHOPS_HOLODISK                (447)
#define PID_ACCOUNT_BOOK                    (448)
#define PID_ECON_HOLODISK                   (449)
#define PID_TORN_PAPER_1                    (450)
#define PID_TORN_PAPER_2                    (451)
#define PID_TORN_PAPER_3                    (452)
#define PID_PASSWORD_PAPER                  (453)
#define PID_EXPLOSIVE_SWITCH                (454)
#define PID_CAR_TRUNK                       (455)
#define PID_CELL_DOOR_KEY                   (456)
#define PID_ELRON_FIELD_REP                 (457)
#define PID_ENCLAVE_HOLODISK_5              (458)
#define PID_ENCLAVE_HOLODISK_1              (459)
#define PID_ENCLAVE_HOLODISK_2              (460)
#define PID_ENCLAVE_HOLODISK_3              (461)
#define PID_ENCLAVE_HOLODISK_4              (462)
#define PID_EVACUATION_HOLODISK             (463)
#define PID_EXPERIMENT_HOLODISK             (464)
#define PID_MEDICAL_HOLODISK                (465)
#define PID_PASSWORD_HOLODISK               (466)
#define PID_JESSE_CONTAINER                 (467)   // RESERVED
#define PID_SMITTY_MEAL                     (468)
#define PID_ROT_GUT                         (469)
#define PID_BALL_GAG                        (470)
#define PID_BECKY_BOOK                      (471)
#define PID_NAV_COMPUTER_PARTS              (479)
#define PID_ELRON_MEMBER_HOLO               (472)
#define PID_MUTATED_TOE                     (473)
#define PID_DAISIES                         (474)
#define PID_ENLIGHTENED_ONE_LETTER          (476)
#define PID_BROADCAST_HOLODISK              (477)
#define PID_SIERRA_MISSION_HOLODISK         (478)
#define PID_NAVCOM_PARTS                    (479)
#define PID_KITTY_SEX_DRUG_AGILITY          (480)  // + 1 agility for 1 hr
#define PID_KITTY_SEX_DRUG_INTELLIGENCE     (481)  // + 1 iq for 1 hr
#define PID_KITTY_SEX_DRUG_STRENGTH         (482)  // + 1 strength for 1 hr
#define PID_FALLOUT_2_HINTBOOK              (483)  // no touchy
#define PID_PLAYERS_EAR                     (484)
#define PID_MASTICATORS_EAR                 (485)
#define PID_REFINED_ORE                     (486)
#define PID_MEMO_FROM_FRANCIS               (487)
#define PID_K9_MOTIVATOR                    (488)
#define PID_SPECIAL_BOXER_WEAPON            (489)
#define PID_NCR_HISTORY_HOLODISK            (490)
#define PID_MR_NIXON_DOLL                   (491)
#define PID_TANKER_FOB                      (492)
#define PID_ELRON_TEACH_HOLO                (493)
#define PID_KOKOWEEF_MINE_SCRIP             (494)
#define PID_PRES_ACCESS_KEY                 (495)
#define PID_SPECIAL_BOXING_GLOVES           (496) // DO NOT USE, SPECIAL, VERY VERY SPECIAL, GOT IT?
#define PID_SPECIAL_PLATED_BOXING_GLOVES    (497) // NO YOU CANNOT USE THIS, NO I SAID
#define PID_GUN_TURRET_WEAPON               (498)
#define PID_DERMAL_PIP_BOY_DISK             (499) // AGAIN, VERY SPECIAL, NOT FOR YOU
#define PID_MEM_CHIP_BLUE                   (503)
#define PID_MEM_CHIP_GREEN                  (504)
#define PID_MEM_CHIP_RED                    (505)
#define PID_MEM_CHIP_YELLOW                 (506)
//#define PID_FN_FAL_HPFA                     (507)
#define PID_WALL_SAFE                       (501)
#define PID_FLOOR_SAFE                      (502)
#define PID_BLUE_MEMORY_MODULE              (503)
#define PID_GREEN_MEMORY_MODULE             (504)
#define PID_RED_MEMORY_MODULE               (505)
#define PID_YELLOW_MEMORY_MODULE            (506)
#define PID_DECOMPOSING_BODY                (507)
#define PID_BLOW_UP_DOLL                    (508)//(515)
#define PID_POPPED_BLOW_UP_DOLL             (509)//(516)
#define PID_POOL_TABLE_1                    (510)
#define PID_POOL_TABLE_2                    (511)
#define PID_POOL_TABLE_3                    (512)
#define PID_POOL_TABLE_4                    (513)
#define PID_POOL_TABLE_5                    (514)
#define PID_POOL_TABLE_6                    (515)
#define PID_PIP_BOY_MEDICAL_ENHANCER        (516) ///(523)
#define PID_LIL_JESUS_WEAPON                (517)
#define PID_DUAL_MINIGUN                    (518)
#define PID_REAL_BOTTLE_CAPS                (519)
#define PID_HEAVY_DUAL_MINIGUN              (520)
#define PID_POOR_BOX                        (521)
#define PID_WAKIZASHI_BLADE                 (522)
#define PID_SURVEY_MAP                      (523)
#define PID_BRIDGEKEEPERS_ROBE              (524)

/******************************************************************
***************       Active Items                  ***************
******************************************************************/

#define PID_ACTIVE_FLARE                    (205)
#define PID_ACTIVE_DYNAMITE                 (206)
#define PID_ACTIVE_GEIGER_COUNTER           (207)
#define PID_ACTIVE_MOTION_SENSOR            (208)
#define PID_ACTIVE_PLASTIC_EXPLOSIVE        (209)
#define PID_ACTIVE_STEALTH_BOY              (210)


/******************************************************************
***************       Flying Weapons                ***************
******************************************************************/

#define PID_FLYING_ROCKET                   (83886081)
#define PID_FLYING_PLASMA_BALL              (83886082)
#define PID_FLYING_KNIFE                    (83886086)
#define PID_FLYING_SPEAR                    (83886087)
#define PID_FLYING_LASER_BLAST              (83886089)
#define PID_FLYING_PLASMA_BLAST             (83886090)
#define PID_FLYING_ELECTRICITY_BOLT         (83886091)


/******************************************************************
***************       Megamod Added                 ***************
******************************************************************/

#define PID_MM_KEY                          (532)
#define PID_MORTAR                          (533)
#define PID_POWDER                          (534)
#define PID_WASTELAND_WANDERER_RIFLE        (535)
#define PID_PISTOL                          (536)
#define PID_REVOLVER                        (537)
#define PID_GAS_MASK                        (538)
#define PID_COIL                            (539)
#define PID_EMPTY_BOTTLE                    (540)
#define PID_THIEVES_STONE                   (541)
#define PID_POISON                          (542)
#define PID_TORN_PAPER_BAG                  (543)
#define PID_SOUMI_EARS                      (544)
#define PID_POISONOUS_SUBSTANCE             (545)
#define PID_PIG_RAT_SKIN                    (546)
#define PID_VALVES                          (547)
#define PID_DEVILS_WEED                     (548)
#define PID_VERTIBIRD_CARGO_HOLD            (549)
#define PID_BLANK_ORDER_FORM                (550)  //chemical requisition
#define PID_POSTMANS_HAT                    (551)
#define PID_FIRE_GECKO_PELT                 (552)
#define PID_SAM_PRITCHARDS_MAP              (553)
#define PID_FRANK_HORRIGANS_ARMOR           (554)
#define PID_BUCKET                          (555)
#define PID_FEMALE_SLAVE                    (556)
#define PID_MALE_SLAVE                      (557)
#define PID_BULL_BRAHMIN                    (558)
#define PID_CANNED_MEAT                     (559)
#define PID_JOZYS_BOOK                      (560)
#define PID_LAIGHING_GAS                    (561)
#define PID_DIARY_I                         (562)
#define PID_STORAGE_CONTAINER               (563)
#define PID_DRILL_I                         (564)
#define PID_HAMMER                          (565)
#define PID_IRON_ORE                        (566)
#define PID_SWEETS                          (567)
#define PID_SKULL                           (568)
#define PID_REPORT                          (569)
#define PID_SPECIAL_DRUGS                   (570)
#define PID_UNCONSCIOUS_TARWIN              (571)
#define PID_TRIBUTE_MONEY                   (572)
#define PID_SAFE                            (573)
#define PID_BODY                            (574)
#define PID_SHACKLES                        (575)
#define PID_MUTANT_SLAVE                    (576)
#define PID_STEYR_IWS_2000                  (577)
#define PID_152_AMMO                        (578)
#define PID_THE_MAINIAC_KRUGERS_TOOTH       (579)
#define PID_PROFESSIONAL_POWER_ARMOR        (580)
#define PID_MECH_WARRIOR_I                  (581)
#define PID_MECH_WARRIOR_II                 (582)
#define PID_ENCLAVE_REPORT                  (583)
#define PID_ABBEY_HOLODISK_I                (584)
#define PID_PASS_KEY                        (585)
#define PID_MAP_OF_TOXIC_CAVES              (586)
#define PID_ABBEY_HOLODISK_II               (587)
#define PID_FORGED_VIRTIBIRD_PLANS          (588)
#define PID_GERMAN_CIGARETTES               (589)
#define PID_HANDCUFFS                       (590)
#define PID_RUBBER_GLOVES                   (591)
#define PID_RESERVED_ITEM_01                (592)
#define PID_RESERVED_ITEM_02                (593)
#define PID_RESERVED_ITEM_03                (594)
#define PID_RESERVED_ITEM_04                (595)
#define PID_RESERVED_ITEM_05                (596)
#define PID_RESERVED_ITEM_06                (597)
#define PID_RESERVED_ITEM_07                (598)
#define PID_RESERVED_ITEM_08                (599)
#define PID_RESERVED_ITEM_09                (600)
#define PID_RESERVED_ITEM_10                (601)
#define PID_RESERVED_ITEM_11                (602)
#define PID_RESERVED_ITEM_12                (603)
#define PID_RESERVED_ITEM_13                (604)
#define PID_RESERVED_ITEM_14                (605)
#define PID_SMOKING_PIPE                    (606)
#define PID_RESERVED_ITEM_15                (607)
#define PID_RESERVED_ITEM_16                (608)
#define PID_RESERVED_ITEM_17                (609)
#define PID_RESERVED_ITEM_18                (610)
#define PID_FORK                            (611)
#define PID_POT                             (612)
#define PID_RESERVED_ITEM_19                (613)
#define PID_RESERVED_ITEM_20                (614)
#define PID_TOASTER                         (615)
#define PID_SYRINGE                         (616)
#define PID_DOG_FOOD                        (617)
#define PID_BUG_SPRAY                       (618)
#define PID_MM_TESLA_ARMOR                  (619)
#define PID_BROTHERHOOD_POWER_ARMOR         (620)
#define PID_REAVER_ARMOR                    (621)
#define PID_ENVIRONMENTAL_ARMOR             (622)
#define PID_GHOUL_ARMOR                     (623)
#define PID_EPA_PAMPHLET                    (624)
#define PID_DRUGS                           (625)
#define PID_GGG                             (626)
#define PID_SECURITY_ROOMS_KEYCARD          (627)
#define PID_TEST_TUBE_RACK                  (628)
#define PID_MEGAMOD_KEYS                    (629)
#define PID_RANDOM_CHEMICALS                (630)
#define PID_SEEDS_I                         (631)
#define PID_PLANT_SPRAY                     (632)
#define PID_TRIGGER_ACTIVATED_DYNAMITE_I    (633)
#define PID_TRIGGER_SWITCH                  (634)
#define PID_PAPER                           (635)
#define PID_BOLT                            (636)
#define PID_BARRETT_M82                     (637)
#define PID_STONE_BLOCK                     (638)
#define PID_SAJAGS_NOTE                     (639)
#define PID_TEETH                           (640)
#define PID_SICKLE                          (641)
#define PID_SPOON                           (642)
#define PID_POWER_REGULATION_CHIP           (643)
#define PID_SPIT_I                          (644)
#define PID_SPIT_II                         (645)
#define PID_CRASHED_VERTIBIRD               (646)
#define PID_COMBAT_JACKET                   (647)
#define PID_SPH_4_HELICOPTER_HELMET         (648)
#define PID_ANIMAL_BONE_DICE                (649)
#define PID_RV_RESEARCH_BOOK                (650)
#define PID_PILE_OF_LETTERS                 (651)
#define PID_SINGLE_LETTER                   (652)
#define PID_MASTERS_KEY                     (653)
#define PID_COCKROACH_SPIT_WEAPON           (654)
#define PID_FISH_I                          (655)
#define PID_FISH_II                         (656)
#define PID_ODE_TO_THE_FLAME_DELUGE         (657)
#define PID_TEXT_BOOK                       (658)
#define PID_ARMY_TECHNICAL_MANUAL           (659)
#define PID_OPERATIONS_MANUAL               (660)
#define PID_ARMY_SURVIVAL_MANUAL            (661)
#define PID_BOTTLE_OF_WINE                  (662)
#define PID_DIARY_II                        (663)
#define PID_BOTANY_HOLODISK                 (664)
#define PID_EXPIRED_GECK                    (665)
#define PID_OLD_COIN                        (666)
#define PID_A_WATCH                         (667)
#define PID_SEEDS_II                        (668)
#define PID_TRIGGET_ACTIVATED_DYNAMITE_II   (669)
#define PID_POPROCKS                        (670)
#define PID_BOTTLE_OF_SHAMPOO               (671)
#define PID_DRILL_II                        (672)
#define PID_MM_HOLODISK                     (673)
#define PID_KEYCARD                         (674)
#define PID_SHARP_CLAWS                     (675)
#define PID_K9_KEVLAR                       (676)
#define PID_RESERVED_ITEM_21                (677)
#define PID_RESERVED_ITEM_22                (678)
#define PID_RESERVED_ITEM_23                (679)
#define PID_RESERVED_ITEM_24                (680)
#define PID_RESERVED_ITEM_25                (681)
#define PID_RESERVED_ITEM_26                (682)
#define PID_RESERVED_ITEM_27                (683)
#define PID_RESERVED_ITEM_28                (684)
#define PID_RESERVED_ITEM_29                (685)
#define PID_RESERVED_ITEM_30                (686)
#define PID_RESERVED_ITEM_31                (687)
#define PID_RESERVED_ITEM_32                (688)
#define PID_RESERVED_ITEM_33                (689)
#define PID_RESERVED_ITEM_34                (690)
#define PID_RESERVED_ITEM_35                (691)
#define PID_RESERVED_ITEM_36                (692)
#define PID_RESERVED_ITEM_37                (693)
#define PID_RESERVED_ITEM_38                (694)
#define PID_RESERVED_ITEM_39                (695)
#define PID_RESERVED_ITEM_40                (696)
#define PID_RESERVED_ITEM_41                (697)
#define PID_RESERVED_ITEM_42                (698)
#define PID_RESERVED_ITEM_43                (699)
#define PID_ENVENOMED_KNIFE                 (700)
#define PID_ENVENOMED_SPEAR                 (701)
#define PID_RESERVED_ITEM_44                (702)
#define PID_ENVENOMED_THROWING_KNIFE        (703)
#define PID_CANNED_FOOD                     (704)
#define PID_RESERVED_ITEM_45                (705)
#define PID_RESERVED_ITEM_46                (706)
#define PID_RESERVED_ITEM_47                (707)
#define PID_RESERVED_ITEM_48                (708)
#define PID_RESERVED_ITEM_49                (709)
#define PID_RESERVED_ITEM_50                (710)
#define PID_RESERVED_ITEM_51                (711)
#define PID_RESERVED_ITEM_52                (712)
#define PID_RESERVED_ITEM_53                (713)
#define PID_RESERVED_ITEM_54                (714)
#define PID_RESERVED_ITEM_55                (715)
#define PID_RESERVED_ITEM_56                (716)
#define PID_RESERVED_ITEM_57                (717)
#define PID_RESERVED_ITEM_58                (718)
#define PID_RESERVED_ITEM_59                (719)
#define PID_RESERVED_ITEM_60                (720)
#define PID_RESERVED_ITEM_61                (721)
#define PID_RESERVED_ITEM_62                (722)
#define PID_RESERVED_ITEM_63                (723)
#define PID_RESERVED_ITEM_64                (724)
#define PID_RESERVED_ITEM_65                (725)
#define PID_RESERVED_ITEM_66                (726)
#define PID_RESERVED_ITEM_67                (727)
#define PID_RESERVED_ITEM_68                (728)
#define PID_RESERVED_ITEM_69                (729)
#define PID_RESERVED_ITEM_70                (730)
#define PID_RESERVED_ITEM_71                (731)
#define PID_RESERVED_ITEM_72                (732)
#define PID_RESERVED_ITEM_73                (733)
#define PID_RESERVED_ITEM_74                (734)
#define PID_RESERVED_ITEM_75                (735)
#define PID_RESERVED_ITEM_76                (736)
#define PID_RESERVED_ITEM_77                (737)
#define PID_RESERVED_ITEM_78                (738)
#define PID_RESERVED_ITEM_79                (739)
#define PID_RESERVED_ITEM_80                (740)
#define PID_RESERVED_ITEM_81                (741)
#define PID_RESERVED_ITEM_82                (742)
#define PID_RESERVED_ITEM_83                (743)
#define PID_RESERVED_ITEM_84                (744)
#define PID_RESERVED_ITEM_85                (745)
#define PID_RESERVED_ITEM_86                (746)
#define PID_RESERVED_ITEM_87                (747)
#define PID_RESERVED_ITEM_88                (748)
#define PID_RESERVED_ITEM_89                (749)
#define PID_SUOMI                           (750)
#define PID_RESERVED_ITEM_90                (751)
#define PID_RESERVED_ITEM_91                (752)
#define PID_SHAMANS_POTION                  (753)
#define PID_SMOKING_WEED                    (754)
#define PID_BRUHO_MUSHROOMS                 (755)
#define PID_RESERVED_ITEM_92                (756)
#define PID_PACK_OF_CIGARETTES              (757)
#define PID_BLACK_BOX                       (758)
#define PID_PEYOTE                          (759)
#define PID_SPECIAL_DECK_OF_TRAGIC_CARDS    (760)
#define PID_DYNAMITE_STICK                  (761)
#define PID_MM_PLASTIC_EXPLOSIVES           (762)
#define PID_PARTS_OF_A_DETONATOR            (763)
#define PID_SEWING_KIT                      (764)
#define PID_RESEARCH_DATA                   (765)
#define PID_MODIFIED_SCHEMATICS             (766)
#define PID_SCOPE                           (767)
#define PID_LASER_POINTER                   (768)
#define PID_LARGER_MAGAZINE                 (769)
#define PID_SPEED_LOADER                    (770)
#define PID_UPGRADED_POWER_SERVOS           (771)
#define PID_IMPROVED_CAPACITOR_BATTERY      (772)
#define PID_LARGER_CAPACITOR_BATTERY        (773)
#define PID_MAGNETIC_FIELD_TARGETING_SYSTEM (774)
#define PID_HOT_WIRED_PLASMA_BOLT_CHAMBER   (775)
#define PID_IMPROVED_HEATER                 (776)
#define PID_ADVANCED_SUPER_BURN_MIX         (777)

/******************************************************************
***************       Nirran Added                  ***************
******************************************************************/

#define PID_CHEAT_BOY                       (57) //moved

#define PID_VANILLA_FIRE_GECKO_WEAPON       (PID_FLAME_BREATH)

#define PID_IMMATURE_FIRE_GECKO_WEAPON      (970)
#define PID_YOUNG_FIRE_GECKO_WEAPON         (971)
#define PID_MINOR_FIRE_GECKO_WEAPON         (972)
#define PID_LESSER_FIRE_GECKO_WEAPON        (973)
#define PID_NORMAL_FIRE_GECKO_WEAPON        (974)
#define PID_STRONG_FIRE_GECKO_WEAPON        (975)
#define PID_RESILIENT_FIRE_GECKO_WEAPON     (976)
#define PID_TOUGH_FIRE_GECKO_WEAPON         (977)

#define PID_VANILLA_DEATHCLAW_WEAPON_1      (PID_DEATHCLAW_CLAW_1)
#define PID_VANILLA_DEATHCLAW_WEAPON_2      (PID_DEATHCLAW_CLAW_2)

#define PID_IMMATURE_MELEE_WEAPON           (980)
#define PID_YOUNG_MELEE_WEAPON              (981)
#define PID_MINOR_MELEE_WEAPON              (982)
#define PID_LESSER_MELEE_WEAPON             (983)
#define PID_NORMAL_MELEE_WEAPON             (984)
#define PID_STRONG_MELEE_WEAPON             (985)
#define PID_RESILIENT_MELEE_WEAPON          (986)
#define PID_TOUGH_MELEE_WEAPON              (987)

#define PID_ORIGINAL_SPIT_WEAPON_AMMO       (644)
#define PID_ORIGINAL_COCKROACH_WEAPON_1     (645)
#define PID_ORIGINAL_COCKROACH_WEAPON_2     (654)

#define PID_IMMATURE_COCKROACH_WEAPON       (988)
#define PID_YOUNG_COCKROACH_WEAPON          (989)
#define PID_MINOR_COCKROACH_WEAPON          (990)
#define PID_LESSER_COCKROACH_WEAPON         (991)
#define PID_NORMAL_COCKROACH_WEAPON         (992)
#define PID_STRONG_COCKROACH_WEAPON         (993)
#define PID_RESILIENT_COCKROACH_WEAPON      (994)
#define PID_TOUGH_COCKROACH_WEAPON          (995)

#define PID_IMMATURE_PLANT_SPIKE            (1006)
#define PID_YOUNG_PLANT_SPIKE               (1007)
#define PID_MINOR_PLANT_SPIKE               (1008)
#define PID_LESSER_PLANT_SPIKE              (1009)
#define PID_NORMAL_PLANT_SPIKE              (1010)
#define PID_STRONG_PLANT_SPIKE              (1011)
#define PID_RESILIENT_PLANT_SPIKE           (1012)
#define PID_TOUGH_PLANT_SPIKE               (1013)

#define PID_RAT_SKIN                        (978)
#define PID_MOLE_RAT_SKIN                   (979)
#define PID_PIG_RAT_SKIN                    (546)

#define PID_JD_MINOR_STIMPACK               (801)
#define PID_JD_LESSER_STIMPACK              (802)
#define PID_JD_AVERAGE_STIMPACK             (996)
#define PID_JD_MEDIUM_STIMPACK              (997)
#define PID_JD_GREATER_STIMPACK             (808)
#define PID_JD_MAJOR_STIMPACK               (998)
#define PID_JD_MEGA_STIMPACK                (999)
#define PID_JD_ULTIMATE_STIMPACK            (1000)
#define PID_HYPO                            (525)

#define PID_JD_SMALL_GUNS                   (778)
#define PID_JD_BIG_GUNS                     (779)
#define PID_JD_ENERGY_WEAPONS               (780)
#define PID_JD_UNARMED                      (781)
#define PID_JD_MELEE                        (782)
#define PID_JD_THROWN                       (783)
#define PID_JD_FIRST_AID                    (784)
#define PID_JD_DOCTOR                       (785)
#define PID_JD_SNEAK                        (786)
#define PID_JD_LOCKPICK                     (787)
#define PID_JD_STEAL                        (788)
#define PID_JD_TRAPS                        (789)
#define PID_JD_SCIENCE                      (790)
#define PID_JD_REPAIR                       (791)
#define PID_JD_SPEACH                       (792)
#define PID_JD_BARTER                       (793)
#define PID_JD_GAMBLING                     (794)
#define PID_JD_OUTDOORS                     (795)

#define PID_STRINGY_GECKO_MEAT              (800)
#define PID_JD_GECKO_MEAT                   (803)
#define PID_JD_GECKO_MEAT_SCRAPS            (804)
#define PID_COOKED_STEW_MEAT                (805)
#define PID_CAMPFIRE_HOTPLATE               (806)

#define PID_LYCANYA_FLOWER                  (796)
#define PID_MARJORAM                        (797)
#define PID_SUNDER_SAGE                     (798)
#define PID_SORREL                          (799)
#define PID_SCARIOSA                        (807)
#define PID_ALIEN_BLOOD                     (1001)
#define PID_FLOATER_BLOOD                   (1002)
#define PID_CENTAUR_BLOOD                   (1003)
#define PID_RUINED_MUTATED_FRUIT            (1005)
#define PID_CENTAUR_BLOOD                   (1003)
#define PID_JD_COOKIE                       (1015)
#define PID_JD_CHOCOLATE_COOKIE             (1016)

#define PID_BOZAR                           (350)
#define PID_JD_BOZAR_UPGRADED_ONCE          (813)
#define PID_JD_BOZAR_UPGRADED_TWICE         (814)
#define PID_JD_BOZAR_UPGRADED_THRICE        (815)

#define PID_ASSAULT_RIFLE                   (23)
#define PID_ASSAULT_RIFLE_EXT_MAG           (405)
#define PID_JD_ASSAULT_RIFLE_UPGRADED_ONCE  (816)
#define PID_JD_ASSAULT_RIFLE_UPGRADED_TWICE (817)

#define PID_HK_P90C                         (296)
#define PID_JD_HK_P90C_UPGRADED_ONCE        (818)
#define PID_JD_HK_P90C_UPGRADED_TWICE       (819)
#define PID_JD_HK_P90C_UPGRADED_THRICE      (820)

#define PID_PANCOR_JACKHAMMER               (354)
#define PID_JD_PANCOR_UPGRADED_ONCE         (821)
#define PID_JD_PANCOR_UPGRADED_TWICE        (822)
#define PID_JD_PANCOR_UPGRADED_THRICE       (823)

#define PID_MEGA_POWER_FIST                 (407)
#define PID_JD_MEGA_FIST_UPGRADED_ONCE      (824)
#define PID_JD_MEGA_FIST_UPGRADED_TWICE     (825)

#define PID_RIPPER                          (116)
#define PID_JD_RIPPER_UPGRADED_ONCE         (826)
#define PID_JD_RIPPER_UPGRADED_TWICE        (827)
#define PID_JD_RIPPER_UPGRADED_THRICE       (828)

#define PID_JD_MOD_OPTIONS                  (57)

#define PID_JD_GREY_PRIMER_CAR_PAINT        (837)
#define PID_JD_BLACK_CAR_PAINT              (838)
#define PID_FLASHLIGHT                      (810)

#define PID_ROBE_SCRAP                      (811)
#define PID_ROBE_SKIRT_SCRAP                (809)
#define PID_ROBE_HOOD_SCRAP                 (839)

#define PID_LEATHER_ARMOR_SCRAP             (812)
#define PID_LEATHER_ARMOR_LEG_SCRAP         (850)
#define PID_LEATHER_ARMOR_HELM_SCRAP        (849)

#define PID_METAL_ARMOR_SCRAP               (842)
#define PID_METAL_ARMOR_LEG_SCRAP           (840)
#define PID_METAL_ARMOR_HELM_SCRAP          (841)

#define PID_COMBAT_ARMOR_SCRAP              (843)
#define PID_COMBAT_ARMOR_LEG_SCRAP          (845)
#define PID_COMBAT_ARMOR_HELM_SCRAP         (844)

#define PID_POWER_ARMOR_SCRAP               (848)
#define PID_POWER_ARMOR_LEG_SCRAP           (847)
#define PID_POWER_ARMOR_HELM_SCRAP          (846)

#define PID_BROKEN_ALTINATOR                (851)
#define PID_DAMAGED_FUEL_CELL_CONTROLER     (852)
#define PID_FLAT_TIRE                       (853)
#define PID_DAMAGED_REGULATOR               (854)
#define PID_DAMAGED_STARTER                 (855)
#define PID_CAR_TIRE                        (856)
#define PID_ALTINATOR                       (857)
#define PID_FUEL_CELL_CONTROLER             (858)
#define PID_REGULATOR                       (859)
#define PID_STARTER                         (860)

#define PID_DISGUISE_BAG                    (861)
#define PID_DRESS                           (862)
#define PID_PERFUME                         (863)
#define PID_CANTEEN                         (864)
#define PID_TENT                            (865)
#define PID_WIG                             (866)
//MEGAMOD 2.44 ADDED
#define PID_GRANTS_ARMOR                    (870)
#define PID_ARMORED_PERSONAL_CARRIER        (871)
#define PID_MM_DICE                         (872)
#define PID_GRANTS_PISTOLE                  (876)
#define PID_BROKEN_BOTTLE                   (877)
#define PID_DART                            (886)
#define PID_DARTBOARD                       (887)
#define PID_VAULT_5_KEY                     (901)
#define PID_VAULT_DWELER_SUIT               (903)
#define PID_SURVIVAL_FOOD_TABLETS           (905)
#define PID_GLADIATOR_ARMOR                 (906)
#define PID_RUSTY_CHAIN                     (907)
#define PID_WRIST_COMPASS                   (908)
#define PID_OLD_LETTER                      (909)
#define PID_BIG_ROCK                        (910)
#define PID_SMALL_ROCKS                     (911)
#define PID_OPAL_ROCKS                      (912)
#define PID_SPECIAL_EDITION_CATS_PAW        (913)
#define PID_MM_EMPTY_BOTTLE                 (914)
#define PID_OLD_COIN_915                    (915)
#define PID_OLD_COIN_916                    (916)
#define PID_VAULT_5_POSTER                  (917)
#define PID_OLD_PORTRAIT_918                (918)
#define PID_MM_GOLD_NUGGET                  (919)
#define PID_GAMEBOY                         (920)
#define PID_GAMER_ZONE_MAGAZINE             (921)
#define PID_ELECTRONIC_DEVICE               (922)
#define PID_DYNAMO_FLASHLIGHT               (923)
#define PID_IDENTIFICATION_CARD_924         (924)
#define PID_IDENTIFICATION_CARD_925         (925)
#define PID_IDENTIFICATION_CARD_926         (926)
#define PID_ELECTRONIC_PART_927             (927)
#define PID_ELECTRONIC_PART_928             (928)
#define PID_ELECTRONIC_PART_929             (929)
#define PID_BROKEN_ID_CARD_READER           (930)
#define PID_BOOK                            (931)
#define PID_VAULT_13_SUIT                   (932)
#define PID_BROKEN_GASS_MASK                (933)
#define PID_SPEAR_MODIFICATION_TOOLS        (934)
#define PID_MANUAL                          (935)
#define PID_OLD_PORTRAIT_936                (936)
#define PID_OLD_PORTRAIT_937                (937)
#define PID_OLD_PORTRAIT_938                (938)
#define PID_NOTE                            (939)
#define PID_AUDIO_TAPE_940                  (940)
#define PID_CASSETTE_PLAYER_NO_POWER        (941)
#define PID_AUDIO_TAPE_942                  (942)
#define PID_AUDIO_TAPE_943                  (943)
#define PID_AUDIO_TAPE_944                  (944)
#define PID_EMPTY_AUDIO_TAPE                (945)
#define PID_RUSTED_CAR                      (946)
#define PID_WARRIOR_NECKLESS                (947)
#define PID_CASSETTE_PLAYER_HAS_POWER       (948)
#define PID_MAILBOX                         (949)
#define PID_BROKEN_POWER_ARMOR              (950)

//art list reference
#define PID_RUSTED_TRUNK                    (269)
#define PID_PRIMER_TRUNK                    (170)
#define PID_BLACK_TRUNK                     (270)
#define PID_DESOTO_TRUNK                    (271)
#define PID_TRUCK_TRUNK                     (272)
#define PID_COP_CAR_TRUNK                   (273)
#define PID_FERRARI_TRUNK                   (274)

//boxes not included in vanilla
#define PID_THREE_BROWN_STACKED_BOXES       (197)
#define PID_TWO_BROWN_STACKED_BOXES         (198)
#define PID_ONE_BROWN_BOX_FACING_WEST       (199)
#define PID_ONE_BROWN_BOX_FACING_SOUTH      (200)
#define PID_THREE_BLUE_STACKED_BOXES        (201)
#define PID_TWO_BLUE_STACKED_BOXES          (202)
#define PID_ONE_BLUE_BOX_FACING_WEST        (203)
#define PID_ONE_BLUE_BOX_FACING_SOUTH       (204)

#endif
