#ifndef REPLACE_H
#define REPLACE_H

#include "D:\Game Files\Fallout 2\HEADERS\RANDOMMAP.H"

procedure start;
procedure Map_Enter_Replace;
procedure Random_mr_Fixit_Stimpacks;

procedure Critter_Stimpacks(variable item);                                       
procedure Container_Stimpacks(variable item);
procedure Critter_Weapons(variable item);                                       
procedure Container_Weapons(variable item);
procedure Critter_Ammo(variable item);                                   
procedure Container_Ammo(variable item);
procedure Critter_Books(variable item);
procedure Container_Books(variable item);                                                          
procedure Swap_Inventory_Item(variable item, variable remove_item, variable replace_item);
procedure Swap_Ground_Item(variable item, variable remove_item, variable replace_item);
procedure Item_Is_Not_Trunk_Item(variable item);

variable fixit_installed,random_loot_installed;

procedure Swap_Ground_Item(variable item, variable remove_item, variable replace_item) begin 
   variable tile, elev, delete_item;
   if(obj_pid(item) == remove_item) then 
      begin
         tile := tile_num(item);
         elev := elevation(item);                                                                                                              
         delete_item := tile_contains_pid_obj(tile_num(item), elevation(item), remove_item);                                      
         destroy_object(delete_item); 
         create_object_sid(replace_item, tile, elev, -1);                                                                                                                                                                                                                                                                                                                                                    
      end                                                                                                              
end
                                                           
procedure Swap_Inventory_Item(variable item, variable remove_item, variable replace_item) begin
   variable delete_item, number_items_remove;
   if(obj_is_carrying_obj_pid(item, remove_item) > 0) then begin                                                    
      while(obj_is_carrying_obj_pid(item, remove_item) > 0) do begin                                                 
         delete_item := obj_carrying_pid_obj(item, remove_item);                                                     
         rm_obj_from_inven(item, delete_item);                                                                       
         if(tile_contains_obj_pid(1, 0, remove_item)) then begin                                                     
            delete_item := tile_contains_pid_obj(1, 0, remove_item);                                                 
            destroy_object(delete_item);                                                                             
         end                                                                                                         
         number_items_remove := number_items_remove + 1;                                                             
      end                                                                                                            
      add_mult_objs_to_inven(item, create_object_sid(replace_item, 0, 0, -1), number_items_remove);                  
      number_items_remove := 0;                                                                                      
   end                                                                                                               
end

procedure Container_Books(variable item) begin
   call Swap_Ground_Item(item, PID_GUNS_AND_BULLETS, PID_JD_SMALL_GUNS);                                                                    
   call Swap_Ground_Item(item, PID_FIRST_AID_BOOK, PID_JD_FIRST_AID);                                                                       
   call Swap_Ground_Item(item, PID_BIG_BOOK_OF_SCIENCE, PID_JD_SCIENCE);                                                                    
   call Swap_Ground_Item(item, PID_DEANS_ELECTRONICS, PID_JD_REPAIR);                                                                       
   call Swap_Ground_Item(item, PID_SCOUT_HANDBOOK, PID_JD_OUTDOORS);                                                                        
   call Swap_Inventory_Item(item, PID_GUNS_AND_BULLETS, PID_JD_SMALL_GUNS);                                                                    
   call Swap_Inventory_Item(item, PID_FIRST_AID_BOOK, PID_JD_FIRST_AID);                                                                       
   call Swap_Inventory_Item(item, PID_BIG_BOOK_OF_SCIENCE, PID_JD_SCIENCE);                                                                    
   call Swap_Inventory_Item(item, PID_DEANS_ELECTRONICS, PID_JD_REPAIR);                                                                       
   call Swap_Inventory_Item(item, PID_SCOUT_HANDBOOK, PID_JD_OUTDOORS);                                                                        
end

procedure Critter_Books(variable item) begin            
   call Swap_Inventory_Item(item, PID_GUNS_AND_BULLETS, PID_JD_SMALL_GUNS);                                                                    
   call Swap_Inventory_Item(item, PID_FIRST_AID_BOOK, PID_JD_FIRST_AID);                                                                       
   call Swap_Inventory_Item(item, PID_BIG_BOOK_OF_SCIENCE, PID_JD_SCIENCE);                                                                    
   call Swap_Inventory_Item(item, PID_DEANS_ELECTRONICS, PID_JD_REPAIR);                                                                       
   call Swap_Inventory_Item(item, PID_SCOUT_HANDBOOK, PID_JD_OUTDOORS);                                                                     
end
                              
procedure Container_Ammo(variable item) begin
   call Swap_Inventory_Item(item, PID_10MM_JHP, PID_10MM_JHP);                                                                                 
   call Swap_Inventory_Item(item, PID_10MM_AP, PID_10MM_AP);                                                                                   
   call Swap_Inventory_Item(item, PID_EXPLOSIVE_ROCKET, PID_EXPLOSIVE_ROCKET);                                                                 
   call Swap_Inventory_Item(item, PID_44_MAGNUM_JHP, PID_44_MAGNUM_JHP);                                                                       
   call Swap_Inventory_Item(item, PID_FLAMETHROWER_FUEL, PID_FLAMETHROWER_FUEL);                                                               
   call Swap_Inventory_Item(item, PID_14MM_AP, PID_14MM_AP);                                                                                   
   call Swap_Inventory_Item(item, PID_223_FMJ, PID_223_FMJ);                                                                                   
   call Swap_Inventory_Item(item, PID_5MM_JHP, PID_5MM_JHP);                                                                                   
   call Swap_Inventory_Item(item, PID_ROCKET_AP, PID_ROCKET_AP);                                                                               
   call Swap_Inventory_Item(item, PID_SMALL_ENERGY_CELL, PID_SMALL_ENERGY_CELL);                                                               
   call Swap_Inventory_Item(item, PID_MICRO_FUSION_CELL, PID_MICRO_FUSION_CELL);                                                               
   call Swap_Inventory_Item(item, PID_SHOTGUN_SHELLS, PID_SHOTGUN_SHELLS);                                                                     
   call Swap_Inventory_Item(item, PID_44_FMJ_MAGNUM, PID_44_FMJ_MAGNUM);                                                                       
   call Swap_Inventory_Item(item, PID_9MM_BALL, PID_9MM_BALL);                                                                                 
   call Swap_Inventory_Item(item, PID_BBS, PID_BBS);                                                                                           
   call Swap_Inventory_Item(item, PID_ROBO_ROCKET_AMMO, PID_ROBO_ROCKET_AMMO);                                                                 
   call Swap_Inventory_Item(item, PID_45_CALIBER_AMMO, PID_45_CALIBER_AMMO);                                                                   
   call Swap_Inventory_Item(item, PID_2MM_EC_AMMO, PID_2MM_EC_AMMO);                                                                           
   call Swap_Inventory_Item(item, PID_4_7MM_CASELESS, PID_4_7MM_CASELESS);                                                                     
   call Swap_Inventory_Item(item, PID_9MM_AMMO, PID_9MM_AMMO);                                                                                 
   call Swap_Inventory_Item(item, PID_HN_NEEDLER_CARTRIDGE, PID_HN_NEEDLER_CARTRIDGE);                                                         
   call Swap_Inventory_Item(item, PID_HN_AP_NEEDLER_CARTRIDGE, PID_HN_AP_NEEDLER_CARTRIDGE);                                                   
   call Swap_Inventory_Item(item, PID_7_62MM_AMMO, PID_7_62MM_AMMO);                                                                           
   call Swap_Inventory_Item(item, PID_FLAMETHROWER_FUEL_MK_II, PID_FLAMETHROWER_FUEL_MK_II);                                                   
   call Swap_Inventory_Item(item, PID_152_AMMO, PID_152_AMMO);                                                                                 
   call Swap_Ground_Item(item, PID_10MM_JHP, PID_10MM_JHP);                                                                                 
   call Swap_Ground_Item(item, PID_10MM_AP, PID_10MM_AP);                                                                                   
   call Swap_Ground_Item(item, PID_EXPLOSIVE_ROCKET, PID_EXPLOSIVE_ROCKET);                                                                 
   call Swap_Ground_Item(item, PID_44_MAGNUM_JHP, PID_44_MAGNUM_JHP);                                                                       
   call Swap_Ground_Item(item, PID_FLAMETHROWER_FUEL, PID_FLAMETHROWER_FUEL);                                                               
   call Swap_Ground_Item(item, PID_14MM_AP, PID_14MM_AP);                                                                                   
   call Swap_Ground_Item(item, PID_223_FMJ, PID_223_FMJ);                                                                                   
   call Swap_Ground_Item(item, PID_5MM_JHP, PID_5MM_JHP);                                                                                   
   call Swap_Ground_Item(item, PID_ROCKET_AP, PID_ROCKET_AP);                                                                               
   call Swap_Ground_Item(item, PID_SMALL_ENERGY_CELL, PID_SMALL_ENERGY_CELL);                                                               
   call Swap_Ground_Item(item, PID_MICRO_FUSION_CELL, PID_MICRO_FUSION_CELL);                                                               
   call Swap_Ground_Item(item, PID_SHOTGUN_SHELLS, PID_SHOTGUN_SHELLS);                                                                     
   call Swap_Ground_Item(item, PID_44_FMJ_MAGNUM, PID_44_FMJ_MAGNUM);                                                                       
   call Swap_Ground_Item(item, PID_9MM_BALL, PID_9MM_BALL);                                                                                 
   call Swap_Ground_Item(item, PID_BBS, PID_BBS);                                                                                           
   call Swap_Ground_Item(item, PID_ROBO_ROCKET_AMMO, PID_ROBO_ROCKET_AMMO);                                                                 
   call Swap_Ground_Item(item, PID_45_CALIBER_AMMO, PID_45_CALIBER_AMMO);                                                                   
   call Swap_Ground_Item(item, PID_2MM_EC_AMMO, PID_2MM_EC_AMMO);                                                                           
   call Swap_Ground_Item(item, PID_4_7MM_CASELESS, PID_4_7MM_CASELESS);                                                                     
   call Swap_Ground_Item(item, PID_9MM_AMMO, PID_9MM_AMMO);                                                                                 
   call Swap_Ground_Item(item, PID_HN_NEEDLER_CARTRIDGE, PID_HN_NEEDLER_CARTRIDGE);                                                         
   call Swap_Ground_Item(item, PID_HN_AP_NEEDLER_CARTRIDGE, PID_HN_AP_NEEDLER_CARTRIDGE);                                                   
   call Swap_Ground_Item(item, PID_7_62MM_AMMO, PID_7_62MM_AMMO);                                                                           
   call Swap_Ground_Item(item, PID_FLAMETHROWER_FUEL_MK_II, PID_FLAMETHROWER_FUEL_MK_II);                                                   
   call Swap_Ground_Item(item, PID_152_AMMO, PID_152_AMMO);                                                                                 
   call Swap_Inventory_Item(item, PID_SCOPE, PID_SCOPE);                                                                                       
   call Swap_Inventory_Item(item, PID_LASER_POINTER, PID_LASER_POINTER);                                                                       
   call Swap_Inventory_Item(item, PID_LARGER_MAGAZINE, PID_LARGER_MAGAZINE);                                                               
   call Swap_Inventory_Item(item, PID_SPEED_LOADER, PID_SPEED_LOADER);
   call Swap_Inventory_Item(item, PID_UPGRADED_POWER_SERVOS, PID_UPGRADED_POWER_SERVOS);
   call Swap_Inventory_Item(item, PID_IMPROVED_CAPACITOR_BATTERY, PID_IMPROVED_CAPACITOR_BATTERY);
   call Swap_Inventory_Item(item, PID_LARGER_CAPACITOR_BATTERY, PID_LARGER_CAPACITOR_BATTERY);
   call Swap_Inventory_Item(item, PID_MAGNETIC_FIELD_TARGETING_SYSTEM, PID_MAGNETIC_FIELD_TARGETING_SYSTEM);
   call Swap_Inventory_Item(item, PID_HOT_WIRED_PLASMA_BOLT_CHAMBER, PID_HOT_WIRED_PLASMA_BOLT_CHAMBER);
   call Swap_Inventory_Item(item, PID_IMPROVED_HEATER, PID_IMPROVED_HEATER);
   call Swap_Inventory_Item(item, PID_ADVANCED_SUPER_BURN_MIX, PID_ADVANCED_SUPER_BURN_MIX);
   call Swap_Ground_Item(item, PID_SCOPE, PID_SCOPE);                                                                                       
   call Swap_Ground_Item(item, PID_LASER_POINTER, PID_LASER_POINTER);                                                                       
   call Swap_Ground_Item(item, PID_LARGER_MAGAZINE, PID_LARGER_MAGAZINE);                                                               
   call Swap_Ground_Item(item, PID_SPEED_LOADER, PID_SPEED_LOADER);
   call Swap_Ground_Item(item, PID_UPGRADED_POWER_SERVOS, PID_UPGRADED_POWER_SERVOS);
   call Swap_Ground_Item(item, PID_IMPROVED_CAPACITOR_BATTERY, PID_IMPROVED_CAPACITOR_BATTERY);
   call Swap_Ground_Item(item, PID_LARGER_CAPACITOR_BATTERY, PID_LARGER_CAPACITOR_BATTERY);
   call Swap_Ground_Item(item, PID_MAGNETIC_FIELD_TARGETING_SYSTEM, PID_MAGNETIC_FIELD_TARGETING_SYSTEM);
   call Swap_Ground_Item(item, PID_HOT_WIRED_PLASMA_BOLT_CHAMBER, PID_HOT_WIRED_PLASMA_BOLT_CHAMBER);
   call Swap_Ground_Item(item, PID_IMPROVED_HEATER, PID_IMPROVED_HEATER);
   call Swap_Ground_Item(item, PID_ADVANCED_SUPER_BURN_MIX, PID_ADVANCED_SUPER_BURN_MIX);
end                                                                        

procedure Critter_Ammo(variable item) begin             
   call Swap_Inventory_Item(item, PID_10MM_JHP, PID_10MM_JHP);
   call Swap_Inventory_Item(item, PID_10MM_AP, PID_10MM_AP);
   call Swap_Inventory_Item(item, PID_EXPLOSIVE_ROCKET, PID_EXPLOSIVE_ROCKET);
   call Swap_Inventory_Item(item, PID_44_MAGNUM_JHP, PID_44_MAGNUM_JHP);
   call Swap_Inventory_Item(item, PID_FLAMETHROWER_FUEL, PID_FLAMETHROWER_FUEL);
   call Swap_Inventory_Item(item, PID_14MM_AP, PID_14MM_AP);
   call Swap_Inventory_Item(item, PID_223_FMJ, PID_223_FMJ);
   call Swap_Inventory_Item(item, PID_5MM_JHP, PID_5MM_JHP);
   call Swap_Inventory_Item(item, PID_ROCKET_AP, PID_ROCKET_AP);
   call Swap_Inventory_Item(item, PID_SMALL_ENERGY_CELL, PID_SMALL_ENERGY_CELL);
   call Swap_Inventory_Item(item, PID_MICRO_FUSION_CELL, PID_MICRO_FUSION_CELL);
   call Swap_Inventory_Item(item, PID_SHOTGUN_SHELLS, PID_SHOTGUN_SHELLS);
   call Swap_Inventory_Item(item, PID_44_FMJ_MAGNUM, PID_44_FMJ_MAGNUM);
   call Swap_Inventory_Item(item, PID_9MM_BALL, PID_9MM_BALL);
   call Swap_Inventory_Item(item, PID_BBS, PID_BBS);
   call Swap_Inventory_Item(item, PID_ROBO_ROCKET_AMMO, PID_ROBO_ROCKET_AMMO);
   call Swap_Inventory_Item(item, PID_45_CALIBER_AMMO, PID_45_CALIBER_AMMO);
   call Swap_Inventory_Item(item, PID_2MM_EC_AMMO, PID_2MM_EC_AMMO);
   call Swap_Inventory_Item(item, PID_4_7MM_CASELESS, PID_4_7MM_CASELESS);
   call Swap_Inventory_Item(item, PID_9MM_AMMO, PID_9MM_AMMO);
   call Swap_Inventory_Item(item, PID_HN_NEEDLER_CARTRIDGE, PID_HN_NEEDLER_CARTRIDGE);
   call Swap_Inventory_Item(item, PID_HN_AP_NEEDLER_CARTRIDGE, PID_HN_AP_NEEDLER_CARTRIDGE);
   call Swap_Inventory_Item(item, PID_7_62MM_AMMO, PID_7_62MM_AMMO);
   call Swap_Inventory_Item(item, PID_FLAMETHROWER_FUEL_MK_II, PID_FLAMETHROWER_FUEL_MK_II);
   call Swap_Inventory_Item(item, PID_152_AMMO, PID_152_AMMO);
   call Swap_Inventory_Item(item, PID_SCOPE, PID_SCOPE);                                                                                       
   call Swap_Inventory_Item(item, PID_LASER_POINTER, PID_LASER_POINTER);                                                                       
   call Swap_Inventory_Item(item, PID_LARGER_MAGAZINE, PID_LARGER_MAGAZINE);                                                               
   call Swap_Inventory_Item(item, PID_SPEED_LOADER, PID_SPEED_LOADER);
   call Swap_Inventory_Item(item, PID_UPGRADED_POWER_SERVOS, PID_UPGRADED_POWER_SERVOS);
   call Swap_Inventory_Item(item, PID_IMPROVED_CAPACITOR_BATTERY, PID_IMPROVED_CAPACITOR_BATTERY);
   call Swap_Inventory_Item(item, PID_LARGER_CAPACITOR_BATTERY, PID_LARGER_CAPACITOR_BATTERY);
   call Swap_Inventory_Item(item, PID_MAGNETIC_FIELD_TARGETING_SYSTEM, PID_MAGNETIC_FIELD_TARGETING_SYSTEM);
   call Swap_Inventory_Item(item, PID_HOT_WIRED_PLASMA_BOLT_CHAMBER, PID_HOT_WIRED_PLASMA_BOLT_CHAMBER);
   call Swap_Inventory_Item(item, PID_IMPROVED_HEATER, PID_IMPROVED_HEATER);
   call Swap_Inventory_Item(item, PID_ADVANCED_SUPER_BURN_MIX, PID_ADVANCED_SUPER_BURN_MIX);
end
                                                                             
procedure Container_Weapons(variable item) begin 
   call Swap_Inventory_Item(item, PID_10MM_PISTOL, PID_10MM_PISTOL);
   call Swap_Inventory_Item(item, PID_10MM_SMG, PID_10MM_SMG);
   call Swap_Inventory_Item(item, PID_HUNTING_RIFLE, PID_HUNTING_RIFLE);
   call Swap_Inventory_Item(item, PID_FLAMER, PID_FLAMER);
   call Swap_Inventory_Item(item, PID_MINIGUN, PID_MINIGUN);
   call Swap_Inventory_Item(item, PID_ROCKET_LAUNCHER, PID_ROCKET_LAUNCHER);
   call Swap_Inventory_Item(item, PID_PLASMA_RIFLE, PID_PLASMA_RIFLE);
   call Swap_Inventory_Item(item, PID_LASER_PISTOL, PID_LASER_PISTOL);
   call Swap_Inventory_Item(item, PID_DESERT_EAGLE, PID_DESERT_EAGLE);
   call Swap_Inventory_Item(item, PID_14MM_PISTOL, PID_14MM_PISTOL);
   call Swap_Inventory_Item(item, PID_ASSAULT_RIFLE, PID_ASSAULT_RIFLE);
   call Swap_Inventory_Item(item, PID_PLASMA_PISTOL, PID_PLASMA_PISTOL);
   call Swap_Inventory_Item(item, PID_GATLING_LASER, PID_GATLING_LASER);
   call Swap_Inventory_Item(item, PID_SHOTGUN, PID_SHOTGUN);
   call Swap_Inventory_Item(item, PID_RIPPER, PID_RIPPER);
   call Swap_Inventory_Item(item, PID_LASER_RIFLE, PID_LASER_RIFLE);
   call Swap_Inventory_Item(item, PID_ALIEN_LASER_PISTOL, PID_ALIEN_LASER_PISTOL);
   call Swap_Inventory_Item(item, PID_9MM_MAUSER, PID_9MM_MAUSER);
   call Swap_Inventory_Item(item, PID_SNIPER_RIFLE, PID_SNIPER_RIFLE);
   call Swap_Inventory_Item(item, PID_CATTLE_PROD, PID_CATTLE_PROD);
   call Swap_Inventory_Item(item, PID_RED_RYDER_BB_GUN, PID_RED_RYDER_BB_GUN);
   call Swap_Inventory_Item(item, PID_RED_RYDER_LE_BB_GUN, PID_RED_RYDER_LE_BB_GUN);
   call Swap_Inventory_Item(item, PID_TURBO_PLASMA_RIFLE, PID_TURBO_PLASMA_RIFLE);
   call Swap_Inventory_Item(item, PID_POWER_FIST, PID_POWER_FIST);
   call Swap_Inventory_Item(item, PID_COMBAT_SHOTGUN, PID_COMBAT_SHOTGUN);
   call Swap_Inventory_Item(item, PID_JONNY_BB_GUN, PID_JONNY_BB_GUN);
   call Swap_Inventory_Item(item, PID_HK_CAWS, PID_HK_CAWS);
   call Swap_Inventory_Item(item, PID_ROBO_ROCKET_LAUNCHER, PID_ROBO_ROCKET_LAUNCHER);
   call Swap_Inventory_Item(item, PID_SCOPED_HUNTING_RIFLE, PID_SCOPED_HUNTING_RIFLE);
   call Swap_Inventory_Item(item, PID_HK_P90C, PID_HK_P90C);
   call Swap_Inventory_Item(item, PID_SPRINGER_RIFLE, PID_SPRINGER_RIFLE);
   call Swap_Inventory_Item(item, PID_ZIP_GUN, PID_ZIP_GUN);
   call Swap_Inventory_Item(item, PID_44_MAGNUM_REVOLVER, PID_44_MAGNUM_REVOLVER);
   call Swap_Inventory_Item(item, PID_TOMMY_GUN, PID_TOMMY_GUN);
   call Swap_Inventory_Item(item, PID_GREASE_GUN, PID_GREASE_GUN);
   call Swap_Inventory_Item(item, PID_BOZAR, PID_BOZAR);
   call Swap_Inventory_Item(item, PID_LIGHT_SUPPORT_WEAPON, PID_LIGHT_SUPPORT_WEAPON);
   call Swap_Inventory_Item(item, PID_FN_FAL, PID_FN_FAL);
   call Swap_Inventory_Item(item, PID_HK_G11, PID_HK_G11);
   call Swap_Inventory_Item(item, PID_PIPE_RIFLE, PID_PIPE_RIFLE);
   call Swap_Inventory_Item(item, PID_PANCOR_JACKHAMMER, PID_PANCOR_JACKHAMMER);
   call Swap_Inventory_Item(item, PID_SOLAR_SCORCHER, PID_SOLAR_SCORCHER);
   call Swap_Inventory_Item(item, PID_SAWED_OFF_SHOTGUN, PID_SAWED_OFF_SHOTGUN);
   call Swap_Inventory_Item(item, PID_M60, PID_M60);
   call Swap_Inventory_Item(item, PID_NEEDLER_PISTOL, PID_NEEDLER_PISTOL);
   call Swap_Inventory_Item(item, PID_AVENGER_MINIGUN, PID_AVENGER_MINIGUN);
   call Swap_Inventory_Item(item, PID_HK_G11E, PID_HK_G11E);
   call Swap_Inventory_Item(item, PID_M72_GAUSS_RIFLE, PID_M72_GAUSS_RIFLE);
   call Swap_Inventory_Item(item, PID_PHAZER, PID_PHAZER);
   call Swap_Inventory_Item(item, PID_PK12_GAUSS_PISTOL, PID_PK12_GAUSS_PISTOL);
   call Swap_Inventory_Item(item, PID_VINDICATOR_MINIGUN, PID_VINDICATOR_MINIGUN);
   call Swap_Inventory_Item(item, PID_YK32_PULSE_PISTOL, PID_YK32_PULSE_PISTOL);
   call Swap_Inventory_Item(item, PID_YK42B_PULSE_RIFLE, PID_YK42B_PULSE_RIFLE);
   call Swap_Inventory_Item(item, PID_44_MAGNUM_SPEEDLOADER, PID_44_MAGNUM_SPEEDLOADER);
   call Swap_Inventory_Item(item, PID_SUPER_CATTLE_PROD, PID_SUPER_CATTLE_PROD);
   call Swap_Inventory_Item(item, PID_IMPROVED_FLAMETHROWER, PID_IMPROVED_FLAMETHROWER);
   call Swap_Inventory_Item(item, PID_LASER_RIFLE_EXT_CAP, PID_LASER_RIFLE_EXT_CAP);
   call Swap_Inventory_Item(item, PID_MAGNETO_LASER_PISTOL, PID_MAGNETO_LASER_PISTOL);
   call Swap_Inventory_Item(item, PID_FN_FAL_NIGHT_SCOPE, PID_FN_FAL_NIGHT_SCOPE);
   call Swap_Inventory_Item(item, PID_DESERT_EAGLE_EXT_MAG, PID_DESERT_EAGLE_EXT_MAG);
   call Swap_Inventory_Item(item, PID_ASSAULT_RIFLE_EXT_MAG, PID_ASSAULT_RIFLE_EXT_MAG);
   call Swap_Inventory_Item(item, PID_PLASMA_PISTOL_EXT_CART, PID_PLASMA_PISTOL_EXT_CART);
   call Swap_Inventory_Item(item, PID_MEGA_POWER_FIST, PID_MEGA_POWER_FIST);
   call Swap_Inventory_Item(item, PID_FN_FAL_HPFA, PID_FN_FAL_HPFA);
   call Swap_Inventory_Item(item, PID_WASTELAND_WANDERER_RIFLE, PID_WASTELAND_WANDERER_RIFLE);
   call Swap_Inventory_Item(item, PID_PISTOL, PID_PISTOL);
   call Swap_Inventory_Item(item, PID_REVOLVER, PID_REVOLVER);
   call Swap_Inventory_Item(item, PID_STEYR_IWS_2000, PID_STEYR_IWS_2000);
   call Swap_Inventory_Item(item, PID_GGG, PID_GGG);
   call Swap_Ground_Item(item, PID_10MM_PISTOL, PID_10MM_PISTOL);
   call Swap_Ground_Item(item, PID_10MM_SMG, PID_10MM_SMG);
   call Swap_Ground_Item(item, PID_HUNTING_RIFLE, PID_HUNTING_RIFLE);
   call Swap_Ground_Item(item, PID_FLAMER, PID_FLAMER);
   call Swap_Ground_Item(item, PID_MINIGUN, PID_MINIGUN);
   call Swap_Ground_Item(item, PID_ROCKET_LAUNCHER, PID_ROCKET_LAUNCHER);
   call Swap_Ground_Item(item, PID_PLASMA_RIFLE, PID_PLASMA_RIFLE);
   call Swap_Ground_Item(item, PID_LASER_PISTOL, PID_LASER_PISTOL);
   call Swap_Ground_Item(item, PID_DESERT_EAGLE, PID_DESERT_EAGLE);
   call Swap_Ground_Item(item, PID_14MM_PISTOL, PID_14MM_PISTOL);
   call Swap_Ground_Item(item, PID_ASSAULT_RIFLE, PID_ASSAULT_RIFLE);
   call Swap_Ground_Item(item, PID_PLASMA_PISTOL, PID_PLASMA_PISTOL);
   call Swap_Ground_Item(item, PID_GATLING_LASER, PID_GATLING_LASER);
   call Swap_Ground_Item(item, PID_SHOTGUN, PID_SHOTGUN);
   call Swap_Ground_Item(item, PID_RIPPER, PID_RIPPER);
   call Swap_Ground_Item(item, PID_LASER_RIFLE, PID_LASER_RIFLE);
   call Swap_Ground_Item(item, PID_ALIEN_LASER_PISTOL, PID_ALIEN_LASER_PISTOL);
   call Swap_Ground_Item(item, PID_9MM_MAUSER, PID_9MM_MAUSER);
   call Swap_Ground_Item(item, PID_SNIPER_RIFLE, PID_SNIPER_RIFLE);
   call Swap_Ground_Item(item, PID_CATTLE_PROD, PID_CATTLE_PROD);
   call Swap_Ground_Item(item, PID_RED_RYDER_BB_GUN, PID_RED_RYDER_BB_GUN);
   call Swap_Ground_Item(item, PID_RED_RYDER_LE_BB_GUN, PID_RED_RYDER_LE_BB_GUN);
   call Swap_Ground_Item(item, PID_TURBO_PLASMA_RIFLE, PID_TURBO_PLASMA_RIFLE);
   call Swap_Ground_Item(item, PID_POWER_FIST, PID_POWER_FIST);
   call Swap_Ground_Item(item, PID_COMBAT_SHOTGUN, PID_COMBAT_SHOTGUN);
   call Swap_Ground_Item(item, PID_JONNY_BB_GUN, PID_JONNY_BB_GUN);
   call Swap_Ground_Item(item, PID_HK_CAWS, PID_HK_CAWS);
   call Swap_Ground_Item(item, PID_ROBO_ROCKET_LAUNCHER, PID_ROBO_ROCKET_LAUNCHER);
   call Swap_Ground_Item(item, PID_SCOPED_HUNTING_RIFLE, PID_SCOPED_HUNTING_RIFLE);
   call Swap_Ground_Item(item, PID_HK_P90C, PID_HK_P90C);
   call Swap_Ground_Item(item, PID_SPRINGER_RIFLE, PID_SPRINGER_RIFLE);
   call Swap_Ground_Item(item, PID_ZIP_GUN, PID_ZIP_GUN);
   call Swap_Ground_Item(item, PID_44_MAGNUM_REVOLVER, PID_44_MAGNUM_REVOLVER);
   call Swap_Ground_Item(item, PID_TOMMY_GUN, PID_TOMMY_GUN);
   call Swap_Ground_Item(item, PID_GREASE_GUN, PID_GREASE_GUN);
   call Swap_Ground_Item(item, PID_BOZAR, PID_BOZAR);
   call Swap_Ground_Item(item, PID_LIGHT_SUPPORT_WEAPON, PID_LIGHT_SUPPORT_WEAPON);
   call Swap_Ground_Item(item, PID_FN_FAL, PID_FN_FAL);
   call Swap_Ground_Item(item, PID_HK_G11, PID_HK_G11);
   call Swap_Ground_Item(item, PID_PIPE_RIFLE, PID_PIPE_RIFLE);
   call Swap_Ground_Item(item, PID_PANCOR_JACKHAMMER, PID_PANCOR_JACKHAMMER);
   call Swap_Ground_Item(item, PID_SOLAR_SCORCHER, PID_SOLAR_SCORCHER);
   call Swap_Ground_Item(item, PID_SAWED_OFF_SHOTGUN, PID_SAWED_OFF_SHOTGUN);
   call Swap_Ground_Item(item, PID_M60, PID_M60);
   call Swap_Ground_Item(item, PID_NEEDLER_PISTOL, PID_NEEDLER_PISTOL);
   call Swap_Ground_Item(item, PID_AVENGER_MINIGUN, PID_AVENGER_MINIGUN);
   call Swap_Ground_Item(item, PID_HK_G11E, PID_HK_G11E);
   call Swap_Ground_Item(item, PID_M72_GAUSS_RIFLE, PID_M72_GAUSS_RIFLE);
   call Swap_Ground_Item(item, PID_PHAZER, PID_PHAZER);
   call Swap_Ground_Item(item, PID_PK12_GAUSS_PISTOL, PID_PK12_GAUSS_PISTOL);
   call Swap_Ground_Item(item, PID_VINDICATOR_MINIGUN, PID_VINDICATOR_MINIGUN);
   call Swap_Ground_Item(item, PID_YK32_PULSE_PISTOL, PID_YK32_PULSE_PISTOL);
   call Swap_Ground_Item(item, PID_YK42B_PULSE_RIFLE, PID_YK42B_PULSE_RIFLE);
   call Swap_Ground_Item(item, PID_44_MAGNUM_SPEEDLOADER, PID_44_MAGNUM_SPEEDLOADER);
   call Swap_Ground_Item(item, PID_SUPER_CATTLE_PROD, PID_SUPER_CATTLE_PROD);
   call Swap_Ground_Item(item, PID_IMPROVED_FLAMETHROWER, PID_IMPROVED_FLAMETHROWER);
   call Swap_Ground_Item(item, PID_LASER_RIFLE_EXT_CAP, PID_LASER_RIFLE_EXT_CAP);
   call Swap_Ground_Item(item, PID_MAGNETO_LASER_PISTOL, PID_MAGNETO_LASER_PISTOL);
   call Swap_Ground_Item(item, PID_FN_FAL_NIGHT_SCOPE, PID_FN_FAL_NIGHT_SCOPE);
   call Swap_Ground_Item(item, PID_DESERT_EAGLE_EXT_MAG, PID_DESERT_EAGLE_EXT_MAG);
   call Swap_Ground_Item(item, PID_ASSAULT_RIFLE_EXT_MAG, PID_ASSAULT_RIFLE_EXT_MAG);
   call Swap_Ground_Item(item, PID_PLASMA_PISTOL_EXT_CART, PID_PLASMA_PISTOL_EXT_CART);
   call Swap_Ground_Item(item, PID_MEGA_POWER_FIST, PID_MEGA_POWER_FIST);
   call Swap_Ground_Item(item, PID_FN_FAL_HPFA, PID_FN_FAL_HPFA);
   call Swap_Ground_Item(item, PID_WASTELAND_WANDERER_RIFLE, PID_WASTELAND_WANDERER_RIFLE);
   call Swap_Ground_Item(item, PID_PISTOL, PID_PISTOL);
   call Swap_Ground_Item(item, PID_REVOLVER, PID_REVOLVER);
   call Swap_Ground_Item(item, PID_STEYR_IWS_2000, PID_STEYR_IWS_2000);
   call Swap_Ground_Item(item, PID_GGG, PID_GGG);
end

procedure Critter_Weapons(variable item) begin
   call Swap_Inventory_Item(item, PID_10MM_PISTOL, PID_10MM_PISTOL);
   call Swap_Inventory_Item(item, PID_10MM_SMG, PID_10MM_SMG);
   call Swap_Inventory_Item(item, PID_HUNTING_RIFLE, PID_HUNTING_RIFLE);
   call Swap_Inventory_Item(item, PID_FLAMER, PID_FLAMER);
   call Swap_Inventory_Item(item, PID_MINIGUN, PID_MINIGUN);
   call Swap_Inventory_Item(item, PID_ROCKET_LAUNCHER, PID_ROCKET_LAUNCHER);
   call Swap_Inventory_Item(item, PID_PLASMA_RIFLE, PID_PLASMA_RIFLE);
   call Swap_Inventory_Item(item, PID_LASER_PISTOL, PID_LASER_PISTOL);
   call Swap_Inventory_Item(item, PID_DESERT_EAGLE, PID_DESERT_EAGLE);
   call Swap_Inventory_Item(item, PID_14MM_PISTOL, PID_14MM_PISTOL);
   call Swap_Inventory_Item(item, PID_ASSAULT_RIFLE, PID_ASSAULT_RIFLE);
   call Swap_Inventory_Item(item, PID_PLASMA_PISTOL, PID_PLASMA_PISTOL);
   call Swap_Inventory_Item(item, PID_GATLING_LASER, PID_GATLING_LASER);
   call Swap_Inventory_Item(item, PID_SHOTGUN, PID_SHOTGUN);
   call Swap_Inventory_Item(item, PID_RIPPER, PID_RIPPER);
   call Swap_Inventory_Item(item, PID_LASER_RIFLE, PID_LASER_RIFLE);
   call Swap_Inventory_Item(item, PID_ALIEN_LASER_PISTOL, PID_ALIEN_LASER_PISTOL);
   call Swap_Inventory_Item(item, PID_9MM_MAUSER, PID_9MM_MAUSER);
   call Swap_Inventory_Item(item, PID_SNIPER_RIFLE, PID_SNIPER_RIFLE);
   call Swap_Inventory_Item(item, PID_CATTLE_PROD, PID_CATTLE_PROD);
   call Swap_Inventory_Item(item, PID_RED_RYDER_BB_GUN, PID_RED_RYDER_BB_GUN);
   call Swap_Inventory_Item(item, PID_RED_RYDER_LE_BB_GUN, PID_RED_RYDER_LE_BB_GUN);
   call Swap_Inventory_Item(item, PID_TURBO_PLASMA_RIFLE, PID_TURBO_PLASMA_RIFLE);
   call Swap_Inventory_Item(item, PID_POWER_FIST, PID_POWER_FIST);
   call Swap_Inventory_Item(item, PID_COMBAT_SHOTGUN, PID_COMBAT_SHOTGUN);
   call Swap_Inventory_Item(item, PID_JONNY_BB_GUN, PID_JONNY_BB_GUN);
   call Swap_Inventory_Item(item, PID_HK_CAWS, PID_HK_CAWS);
   call Swap_Inventory_Item(item, PID_ROBO_ROCKET_LAUNCHER, PID_ROBO_ROCKET_LAUNCHER);
   call Swap_Inventory_Item(item, PID_SCOPED_HUNTING_RIFLE, PID_SCOPED_HUNTING_RIFLE);
   call Swap_Inventory_Item(item, PID_HK_P90C, PID_HK_P90C);
   call Swap_Inventory_Item(item, PID_SPRINGER_RIFLE, PID_SPRINGER_RIFLE);
   call Swap_Inventory_Item(item, PID_ZIP_GUN, PID_ZIP_GUN);
   call Swap_Inventory_Item(item, PID_44_MAGNUM_REVOLVER, PID_44_MAGNUM_REVOLVER);
   call Swap_Inventory_Item(item, PID_TOMMY_GUN, PID_TOMMY_GUN);
   call Swap_Inventory_Item(item, PID_GREASE_GUN, PID_GREASE_GUN);
   call Swap_Inventory_Item(item, PID_BOZAR, PID_BOZAR);
   call Swap_Inventory_Item(item, PID_LIGHT_SUPPORT_WEAPON, PID_LIGHT_SUPPORT_WEAPON);
   call Swap_Inventory_Item(item, PID_FN_FAL, PID_FN_FAL);
   call Swap_Inventory_Item(item, PID_HK_G11, PID_HK_G11);
   call Swap_Inventory_Item(item, PID_PIPE_RIFLE, PID_PIPE_RIFLE);
   call Swap_Inventory_Item(item, PID_PANCOR_JACKHAMMER, PID_PANCOR_JACKHAMMER);
   call Swap_Inventory_Item(item, PID_SOLAR_SCORCHER, PID_SOLAR_SCORCHER);
   call Swap_Inventory_Item(item, PID_SAWED_OFF_SHOTGUN, PID_SAWED_OFF_SHOTGUN);
   call Swap_Inventory_Item(item, PID_M60, PID_M60);
   call Swap_Inventory_Item(item, PID_NEEDLER_PISTOL, PID_NEEDLER_PISTOL);
   call Swap_Inventory_Item(item, PID_AVENGER_MINIGUN, PID_AVENGER_MINIGUN);
   call Swap_Inventory_Item(item, PID_HK_G11E, PID_HK_G11E);
   call Swap_Inventory_Item(item, PID_M72_GAUSS_RIFLE, PID_M72_GAUSS_RIFLE);
   call Swap_Inventory_Item(item, PID_PHAZER, PID_PHAZER);
   call Swap_Inventory_Item(item, PID_PK12_GAUSS_PISTOL, PID_PK12_GAUSS_PISTOL);
   call Swap_Inventory_Item(item, PID_VINDICATOR_MINIGUN, PID_VINDICATOR_MINIGUN);
   call Swap_Inventory_Item(item, PID_YK32_PULSE_PISTOL, PID_YK32_PULSE_PISTOL);
   call Swap_Inventory_Item(item, PID_YK42B_PULSE_RIFLE, PID_YK42B_PULSE_RIFLE);
   call Swap_Inventory_Item(item, PID_44_MAGNUM_SPEEDLOADER, PID_44_MAGNUM_SPEEDLOADER);
   call Swap_Inventory_Item(item, PID_SUPER_CATTLE_PROD, PID_SUPER_CATTLE_PROD);
   call Swap_Inventory_Item(item, PID_IMPROVED_FLAMETHROWER, PID_IMPROVED_FLAMETHROWER);
   call Swap_Inventory_Item(item, PID_LASER_RIFLE_EXT_CAP, PID_LASER_RIFLE_EXT_CAP);
   call Swap_Inventory_Item(item, PID_MAGNETO_LASER_PISTOL, PID_MAGNETO_LASER_PISTOL);
   call Swap_Inventory_Item(item, PID_FN_FAL_NIGHT_SCOPE, PID_FN_FAL_NIGHT_SCOPE);
   call Swap_Inventory_Item(item, PID_DESERT_EAGLE_EXT_MAG, PID_DESERT_EAGLE_EXT_MAG);
   call Swap_Inventory_Item(item, PID_ASSAULT_RIFLE_EXT_MAG, PID_ASSAULT_RIFLE_EXT_MAG);
   call Swap_Inventory_Item(item, PID_PLASMA_PISTOL_EXT_CART, PID_PLASMA_PISTOL_EXT_CART);
   call Swap_Inventory_Item(item, PID_MEGA_POWER_FIST, PID_MEGA_POWER_FIST);
   call Swap_Inventory_Item(item, PID_FN_FAL_HPFA, PID_FN_FAL_HPFA);
   call Swap_Inventory_Item(item, PID_WASTELAND_WANDERER_RIFLE, PID_WASTELAND_WANDERER_RIFLE);
   call Swap_Inventory_Item(item, PID_PISTOL, PID_PISTOL);
   call Swap_Inventory_Item(item, PID_REVOLVER, PID_REVOLVER);
   call Swap_Inventory_Item(item, PID_STEYR_IWS_2000, PID_STEYR_IWS_2000);
   call Swap_Inventory_Item(item, PID_GGG, PID_GGG);
end

procedure Map_Enter_Replace begin
   variable item_list, item, critter_list, critter;
   if (gv(cur_map_index + replace_additive) == 0) or (Is_Random_Encounter_Map) then begin
      sv(cur_map_index + replace_additive, 1);
      item_list:=list_begin(LIST_GROUNDITEMS);
      while(item_list != 0) do begin
         item:=list_next(item_list);
         if (item) then begin
            if (Item_Is_Not_Trunk_Item(item)) then begin
               call Container_Ammo(item);
			   call Container_Books(item);
			   call Container_Weapons(item);
			   if (fixit_installed == 1) then begin
                  call Container_Stimpacks(item);
			   end
			   if (random_loot_installed == 1) then begin
			      call Swap_Ground_Item(item, PID_COOKIE, PID_JD_COOKIE);
				  call Swap_Ground_Item(item, 1004, PID_JD_CHOCOLATE_COOKIE);
			   end
            end
         end
         else begin
            list_end(item_list);
            item_list:=0;
         end
      end
      critter_list:=list_begin(LIST_CRITTERS);
      while(critter_list != 0) do begin
         critter:=list_next(critter_list);
         if (critter) then begin
            if ((party_member_obj(obj_pid(critter)) != 0) == 0) and (critter != dude_obj) then begin
               call Critter_Ammo(critter);
			   call Critter_Books(critter);
			   call Critter_Weapons(critter);
			   if (fixit_installed == 1) then begin
                  call Critter_Stimpacks(critter);
			   end
			   if (random_loot_installed == 1) then begin
				  call Swap_Inventory_Item(critter, PID_COOKIE, PID_JD_COOKIE);
				  call Swap_Inventory_Item(critter, 1004, PID_JD_CHOCOLATE_COOKIE);
			   end
            end
         end
         else begin
            list_end(critter_list);
            critter_list:=0;
         end
      end
   end
end

procedure Item_Is_Not_Trunk_Item(variable item) begin
   if (obj_pid(item) != PID_CAR_TRUNK) and (obj_pid(item) != PID_VERTIBIRD_CARGO_HOLD) then begin
      return 1;
   end
   return 0;
end

procedure Container_Stimpacks(variable item) begin
   call Swap_Inventory_Item(item, PID_SUPER_STIMPAK, Random_mr_Fixit_Stimpacks);                                                                    
   call Swap_Inventory_Item(item, PID_STIMPAK, Random_mr_Fixit_Stimpacks);
   call Swap_Ground_Item(item, PID_SUPER_STIMPAK , Random_mr_Fixit_Stimpacks);                                                                    
   call Swap_Ground_Item(item, PID_STIMPAK, Random_mr_Fixit_Stimpacks);    
end

procedure Critter_Stimpacks(variable item) begin
   call Swap_Inventory_Item(item, PID_SUPER_STIMPAK, Random_mr_Fixit_Stimpacks);                                                                    
   call Swap_Inventory_Item(item, PID_STIMPAK, Random_mr_Fixit_Stimpacks);
   call Swap_Ground_Item(item, PID_SUPER_STIMPAK , Random_mr_Fixit_Stimpacks);                                                                    
   call Swap_Ground_Item(item, PID_STIMPAK, Random_mr_Fixit_Stimpacks);                                                                                                                                              
end

procedure Random_mr_Fixit_Stimpacks begin
   variable random_roll,item_pid;
   random_roll := random(1,8); 
   switch(random_roll) begin
      case 1:
         item_pid := PID_JD_MINOR_STIMPACK;
      case 2:
         item_pid := PID_JD_LESSER_STIMPACK;
      case 3:
         item_pid := PID_JD_AVERAGE_STIMPACK;
      case 4:
         item_pid := PID_JD_MEDIUM_STIMPACK;
      case 5:
         item_pid := PID_JD_GREATER_STIMPACK;
      case 6:
         item_pid := PID_JD_MAJOR_STIMPACK;
      case 7:
         item_pid := PID_JD_MEGA_STIMPACK;
      case 8:
         item_pid := PID_JD_ULTIMATE_STIMPACK;
      end
   //display_msg("swapped");
   return item_pid;
end


#endif // REPLACE_H









