/*
	Copyright 1998-2003 Interplay Entertainment Corp.  All rights reserved.
*/

#ifndef CRITRPID_H
#define CRITRPID_H

/******************************************************************
   File Name: CritrPid.H


   Purpose: This file will contain defines for all the critter
            prototypes for the game. These prototypes can be
            found in mapper using <F2> or selecting critters. All
            defines in here will need to be prepended with PID_
            for the ease of everyone. Additionally, Please do not
            make duplicate names for the same item. Most should
            have the correct name.


   Created: January 16, 1998
******************************************************************/


#define PID_HERO_PRIMITIVE_MALE         (16777217)
#define PID_HERO_PRIMITIVE_FEMALE       (16777218)
#define PID_PRIMITIVE_VILLAGER_MALE     (16777219)
#define PID_PRIMITIVE_VILLAGER_FEMALE   (16777220)
#define PID_SMALL_RADSCORPION           (16777221)
#define PID_LARGE_RADSCORPION           (16777222)
#define PID_SMALL_DEATHCLAW             (16777223)
#define PID_LARGE_DEATHCLAW             (16777224)
#define PID_DOG                         (16777225)
#define PID_BRAHMIN                     (16777226)
#define PID_RAT                         (16777227)
#define PID_MANTIS                      (16777228)
#define PID_ARROYO_ELDER                (16777229)
#define PID_HAKUNIN                     (16777230)
#define PID_MYNOC                       (16777231)
#define PID_SPORE_PLANT                 (16777232)
#define PID_CUTE_SLAVE_FEMALE           (16777233)
#define PID_HANDSOME_SLAVE_MALE         (16777234)
#define PID_HEALTHY_SLAVE_FEMALE        (16777235)
#define PID_HEALTHY_SLAVE_MALE          (16777236)
#define PID_STRONG_SLAVE_FEMALE         (16777237)
#define PID_STRONG_SLAVE_MALE           (16777238)
#define PID_COMBAT_SLAVE_FEMALE         (16777239)
#define PID_COMBAT_SLAVE_MALE           (16777240)
#define PID_CLEVER_SLAVE_FEMALE         (16777241)
#define PID_CLEVER_SLAVE_MALE           (16777242)
#define PID_GENERIC_SLAVE_FEMALE        (16777243)
#define PID_GENERIC_SLAVE_MALE          (16777244)
#define PID_ANNA                        (16777245)
#define PID_TOUGH_THUG_MALE             (16777246)
#define PID_TOUGH_THUG_FEMALE           (16777247)
#define PID_MELEE_THUG_MALE             (16777248)
#define PID_MELEE_THUG_FEMALE           (16777249)
#define PID_AGILE_THUG_MALE             (16777250)
#define PID_AGILE_THUG_FEMALE           (16777251)
#define PID_GUN_THUG_MALE               (16777252)
#define PID_GUN_THUG_FEMALE             (16777253)
#define PID_BIG_GUN_THUG_MALE           (16777254)
#define PID_BIG_GUN_THUG_FEMALE         (16777255)
#define PID_TOUGH_GUARD_MALE            (16777256)
#define PID_TOUGH_GUARD_FEMALE          (16777257)
#define PID_MELEE_GUARD_MALE            (16777258)
#define PID_MELEE_GUARD_FEMALE          (16777259)
#define PID_AGILE_GUARD_MALE            (16777260)
#define PID_AGILE_GUARD_FEMALE          (16777261)
#define PID_GUN_GUARD_MALE              (16777262)
#define PID_GUN_GUARD_FEMALE            (16777263)
#define PID_BIG_GUN_GUARD_MALE          (16777264)
#define PID_BIG_GUN_GUARD_FEMALE        (16777265)
#define PID_ORPHAN_MALE                 (16777266)
#define PID_ORPHAN_FEMALE               (16777267)
#define PID_CHILD_MALE                  (16777268)
#define PID_CHILD_FEMALE                (16777269)
#define PID_LOSER_MALE                  (16777270)
#define PID_LOSER_FEMALE                (16777271)
#define PID_BAD_MERCHANT_MALE           (16777272)
#define PID_BAD_MERCHANT_FEMALE         (16777273)
#define PID_AVERAGE_MERCHANT_MALE       (16777274)
#define PID_AVERAGE_MERCHANT_FEMALE     (16777275)
#define PID_MASTER_TRADER_MALE          (16777276)
#define PID_MASTER_TRADER_FEMALE        (16777277)
#define PID_VIC                         (16777278)
#define PID_WEAK_PEASANT_MALE           (16777279)
#define PID_WEAK_PEASANT_FEMALE         (16777280)
#define PID_AVERAGE_PEASANT_MALE        (16777281)
#define PID_AVERAGE_PEASANT_FEMALE      (16777282)
#define PID_STRONG_PEASANT_MALE         (16777283)
#define PID_STRONG_PEASANT_FEMALE       (16777284)
#define PID_WEAK_MELEE_GUARD_MALE       (16777285)
#define PID_WEAK_MELEE_GUARD_FEMALE     (16777286)
#define PID_WEAK_GUN_GUARD_MALE         (16777287)
#define PID_WEAK_GUN_GUARD_FEMALE       (16777288)
#define PID_REPAIR_BOT_1                (16777289)
#define PID_REPAIR_BOT_2                (16777290)
#define PID_ROBOBRAIN                   (16777291)
#define PID_EYEBALL                     (16777292)
#define PID_MISSILE_BOT                 (16777293)
#define PID_TOUGH_MISSILE_BOT           (16777294)
#define PID_BRAINBOT                    (16777295)
#define PID_GECKO_SMALL                 (16777296)
#define PID_TOUGH_GECKO_SMALL           (16777297)
#define PID_WILD_DOG                    (16777298)
#define PID_GOLDEN_GECKO                (16777299)
#define PID_VAULT_DEATHCLAW             (16777300)
#define PID_VAULT_DEATHCLAW_SPAWN       (16777301)
#define PID_TOUGH_GOLDEN_GECKO          (16777302)
#define PID_LYNETTE                     (16777303)
#define PID_DR_TROY                     (16777304)
#define PID_JOHN_MACRAE                 (16777305)
#define PID_GREGORY                     (16777306)
#define PID_FEMALE_VAULT_CITIZEN        (16777307)
#define PID_MALE_VAULT_CITIZEN          (16777308)
#define PID_UP_CLASS_FEMALE_CITIZEN     (16777309)
#define PID_UP_CLASS_MALE_CITIZEN       (16777310)
#define PID_MALE_TRAPPER                (16777311)
#define PID_FEMALE_TRAPPER              (16777312)
#define PID_SULIK                       (16777313)
#define PID_MAIDA_BUCKNER               (16777314)
#define PID_TORR                        (16777315)
#define PID_LUMPY                       (16777316)
#define PID_REACTOR_GLOWING_ONE         (16777317)
#define PID_REACTOR_GHOUL               (16777318)
#define PID_REACTOR_GUARD               (16777319)
#define PID_ZOMAK                       (16777320)
#define PID_SKEETER                     (16777321)
#define PID_THE_BRAIN                   (16777322)
#define PID_LENNY                       (16777323)
#define PID_WOOZ                        (16777324)
#define PID_HAROLD                      (16777325)
#define PID_MOLE_RAT                    (16777326)
#define PID_GREATER_MOLE_RAT            (16777327)
#define PID_PIG_RAT                     (16777328)
#define PID_TOUGH_PIG_RAT               (16777329)
#define PID_WEAK_BRAHMIN                (16777330)
#define PID_MALE_POWER_ARMOR_MK2        (16777331)
#define PID_MUTATED_RAT                 (16777332)
#define PID_MUTATED_MOLE_RAT            (16777333)
#define PID_MUTATED_PIG_RAT             (16777334)
#define PID_SUPER_MUTANT                (16777335)
#define PID_POWERFUL_MUTANT             (16777336)
#define PID_MELCHOIR                    (16777337)
#define PID_HERO_POWER_ARMOR            (16777338)
#define PID_HERO_ROBE                   (16777339)
#define PID_HERO_VAULT_MALE             (16777340)
#define PID_HERO_VAULT_FEMALE           (16777341)
#define PID_HERO_LEATHER_MALE           (16777342)
#define PID_HERO_LEATHER_FEMALE         (16777343)
#define PID_HERO_METAL_MALE             (16777344)
#define PID_HERO_METAL_FEMALE           (16777345)
#define PID_HERO_LEATHER_JACKET_MALE    (16777346)
#define PID_HERO_LEATHER_JACKET_FEMALE  (16777347)
#define PID_COMBAT_MALE                 (16777348)
#define PID_COMBAT_FEMALE               (16777349)
#define PID_VAULT_CITY_GUARD_MALE       (16777350)
#define PID_VAULT_CITY_GUARD_FEMALE     (16777351)
#define PID_CYBERDOG                    (16777352)
#define PID_NCR_GUARD_MALE              (16777353)
#define PID_NCR_GUARD_FEMALE            (16777354)
#define PID_NCR_MELEE_GUARD             (16777355)
#define PID_SLAVER_GUARD                (16777356)
#define PID_SLAVER_OVERSEER             (16777357)
#define PID_GRAND_MASTER_TRADER_MALE    (16777358)
#define PID_GRAND_MASTER_TRADER_FEMALE  (16777359)
#define PID_TANDI                       (16777360)
#define PID_MERC                        (16777361)
#define PID_RATCH                       (16777362)
#define PID_NCR_SKEETER                 (16777363)
#define PID_MIKEY                       (16777364)
#define PID_NCR_BARTENDER               (16777365)
#define PID_SHOP_OWNER                  (16777366)
#define PID_GRUNTHAR                    (16777367)
#define PID_GORIS                       (16777368)
#define PID_FIGHTING_MOLERAT_1          (16777369)
#define PID_FIGHTING_MOLERAT_2          (16777370)
#define PID_FIGHTING_MOLERAT_3          (16777371)
#define PID_FIGHTING_MOLERAT_4          (16777372)
#define PID_FIGHTING_MOLERAT_5          (16777373)
#define PID_FIGHTING_MOLERAT_6          (16777374)
#define PID_GENA_GHOUL                  (16777375)
#define PID_MYRON                       (16777376)
#define PID_MARCUS                      (16777377)
#define PID_DOC                         (16777378)
#define PID_DAVIN                       (16777379)
#define PID_MIRIA                       (16777380)
#define PID_LADDIE                      (16777381)
#define PID_RONDO                       (16777382)
#define PID_RANCH_HAND_MALE             (16777383)
#define PID_RANCH_HAND_FEMALE           (16777384)
#define PID_RANCH_HAND_BLACK            (16777385)
#define PID_BOUNCER                     (16777386)
#define PID_BRUISER                     (16777387)
#define PID_WEAK_MR_HANDY               (16777388)
#define PID_GENERIC_GLOWING_ONE         (16777389)
#define PID_DAR                         (16777390)
#define PID_DALIA                       (16777391)
#define PID_GORDON                      (16777392)
#define PID_TEST                        (16777393)
//#define PID_REACTOR_GHOUL               (16777394)
#define PID_GENERIC_GHOUL               (16777395)
#define PID_MATT                        (16777396)
#define PID_BOUNTY_LEADER_1_6           (16777397)
#define PID_BOUNT_MALE_1_6              (16777398)
#define PID_BOUNTY_LEADER_7_12          (16777399)
#define PID_BOUNTY_MALE_7_12            (16777400)
#define PID_BOUNTY_FEMALE_7_12          (16777401)
#define PID_BOUNTY_LEADER_13_18         (16777402)
#define PID_BOUNTY_MALE_13_18           (16777403)
#define PID_BOUNTY_FEMALE_13_18         (16777404)
#define PID_BOUNTY_LEADER_19            (16777405)
#define PID_BOUNTY_19                   (16777406)
#define PID_BESS                        (16777407)
#define PID_BALTHAS                     (16777408)
#define PID_GRISHAM                     (16777409)
#define PID_PHIL                        (16777410)
#define PID_CHICKEN                     (16777411)
#define PID_KARL                        (16777412)
#define PID_JONNY                       (16777413)
#define PID_JO                          (16777414)
#define PID_ZEKE                        (16777415)
#define PID_BUTCHER                     (16777416)
#define PID_PETEY                       (16777417)
#define PID_MALE_PRIMITIVE_HUNTER       (16777418)
#define PID_FEMALE_PRIMITIVE_HUNTER     (16777419)
#define PID_MALE_CANNIBAL               (16777420)
#define PID_FEMALE_CANNIBAL             (16777421)
#define PID_HOLY_MAN                    (16777422)
#define PID_HOLY_WOMAN                  (16777423)
#define PID_MALE_NOMAD_LOW              (16777424)
#define PID_MALE_NOMAD_MED              (16777425)
#define PID_FEMALE_NOMAD_LOW            (16777426)
#define PID_FEMALE_NOMAD_MED            (16777427)
#define PID_MALE_BANDIT                 (16777428)
#define PID_FEMALE_BANDIT               (16777429)
#define PID_MALE_FARMER                 (16777430)
#define PID_FEMALE_FARMER               (16777431)
#define PID_MED_MANTIS                  (16777432)
#define PID_MALE_SLAVER                 (16777433)
#define PID_FEMALE_SLAVER               (16777434)
#define PID_WILD_BRAHMIN                (16777435)
#define PID_MALE_HOMESTEADER            (16777436)
#define PID_FEMALE_HOMESTEADER          (16777437)
#define PID_VC_PATROL_MALE              (16777438)
#define PID_VC_PATROL_FEMALE            (16777439)
#define PID_STRONG_SLAVER_MALE          (16777440)
#define PID_STRONG_SLAVER_FEMALE        (16777441)
#define PID_CRAZIES                     (16777442)
#define PID_SCAVENGERS                  (16777443)
#define PID_GLOW_CRAZIES                (16777444)
#define PID_GLOW_SCAVENGERS             (16777445)
#define PID_FIGHERMAN                   (16777446)
#define PID_FISHERWOMAN                 (16777447)
#define PID_WILDER_MALE                 (16777448)
#define PID_WILDER_FEMALE               (16777449)
#define PID_BOOTLEGGER_MALE             (16777450)
#define PID_BOOTLEGGER_FEMALE           (16777451)
#define PID_PROSPECTOR_MALE             (16777452)
#define PID_PROSPECTOR_FEMALE           (16777453)
#define PID_RAIDER_MALE                 (16777454)
#define PID_RAIDER_FEMALE               (16777455)
#define PID_FIRE_GECKO                  (16777456)
#define PID_TOUGH_FIRE_GECKO            (16777457)
#define PID_ALIEN                       (16777458)
#define PID_TOUGH_ALIEN                 (16777459)
#define PID_SM_TOUGH_DEATHCLAW          (16777460)
#define PID_TOUGH_DEATHCLAW             (16777461)
#define PID_FLOATER                     (16777462)
#define PID_NASTY_FLOATER               (16777463)
#define PID_CENTAUR                     (16777464)
#define PID_MEAN_CENTAUR                (16777465)
#define PID_MALE_ENCALVE_PATROL         (16777466)
#define PID_FEMALE_ENCLAVE_PATROL       (16777467)
#define PID_MALE_PRESS_GANG             (16777468)
#define PID_FEMALE_PRESS_GANG           (16777469)
#define PID_MALE_MERCENARY              (16777470)
#define PID_FEMALE_MERCENARY            (16777471)
#define PID_NIGHTKIN                    (16777472)
#define PID_TOUGH_NIGHTKIN              (16777473)
#define PID_TOUGH_GHOUL                 (16777474)
#define PID_MOBSTER                     (16777475)
#define PID_YAKUZA                      (16777476)
#define PID_MALE_NCR_RANGER             (16777477)
#define PID_FEMALE_NCR_RANGER           (16777478)
#define PID_MALE_MAURADER               (16777479)
#define PID_FEMALE_MAURADER             (16777480)
#define PID_LLOYD                       (16777481)
#define PID_VORPAL_RAT                  (16777482)
#define PID_VAULT_13_MALE               (16777483)
#define PID_VAULT_13_FEMALE             (16777484)
#define PID_BRIDGE_GUARDIAN             (16777485)
#define PID_MYSTERIOUS_STRANGER_MALE    (16777486)
#define PID_MYSTERIOUS_STRANGER_FEMALE  (16777487)
#define PID_HAKESWILL                   (16777488)
#define PID_BIG_JESUS_MORDINO           (16777489)
#define PID_DUMAR                       (16777490)
#define PID_MOTHER_DEATHCLAW            (16777491)
#define PID_THE_DRAGON                  (16777492)
#define PID_LOPAN                       (16777493)
#define PID_ELRONOLOGIST_MALE           (16777494)
#define PID_ELRONOLOGIST_FEMALE         (16777495)
#define PID_MYST_STRANGER_MALE_5_10     (16777496)
#define PID_MYST_STRANGER_FEMALE_5_10   (16777497)
#define PID_MYST_STRANGER_MALE_11_15    (16777498)
#define PID_MYST_STRANGER_FEMALE_11_15  (16777499)
#define PID_MYST_STRANGER_MALE_16_20    (16777500)
#define PID_MYST_STRANGER_FEMALE_16_20  (16777501)
#define PID_MYST_STRANGER_MALE_21       (16777502)
#define PID_MYST_STRANGER_FEMALE_21     (16777503)
#define PID_END_BOSS                    (16777504)
#define PID_DEATHCLAW_EGG               (16777505)
#define PID_METZGER                     (16777506)
#define PID_ENCLAVE_GUARD_MALE          (16777507)
#define PID_ENCLAVE_GUARD_FEMALE        (16777508)
#define PID_PRESIDENT                   (16777509)
#define PID_VICE_PRESIDENT              (16777510)
#define PID_TECHNICIAN                  (16777511)
#define PID_BADGER                      (16777512)
#define PID_DR_FUNG                     (16777513)
#define PID_CHINA_BOY                   (16777514)
#define PID_CHINA_GIRL                  (16777515)
#define PID_GUN_MERCHANT                (16777516)
#define PID_SHI_LAB_TECH                (16777517)
#define PID_SHI_GUARD                   (16777518)
#define PID_SHI_MALE_PEASANT            (16777519)
#define PID_SHI_FEMALE_PEASANT          (16777520)
#define PID_LOPAN_MALE_PEASANT          (16777521)
#define PID_LOPAN_FEMALE_PEASANT        (16777522)
#define PID_DOCK_WORKER                 (16777523)
#define PID_SHI_MERCHANT                (16777524)
#define PID_KEENG_RAT                   (16777525)
#define PID_SULIK_STAGE1                (16777526)
#define PID_SULIK_STAGE2                (16777527)
#define PID_SULIK_STAGE3                (16777528)
#define PID_SULIK_STAGE4                (16777529)
#define PID_SULIK_STAGE5                (16777530)
#define PID_SULIK_STAGE6                (16777531)
#define PID_LENNY_STAGE1                (16777532)
#define PID_LENNY_STAGE2                (16777533)
#define PID_LENNY_STAGE3                (16777534)
#define PID_GORIS_STAGE1                (16777535)
#define PID_GORIS_STAGE2                (16777536)
#define PID_GORIS_STAGE3                (16777537)
#define PID_GORIS_STAGE4                (16777538)
#define PID_GORIS_STAGE5                (16777539)
#define PID_GORIS_STAGE6                (16777540)
#define PID_MYRON_STAGE1                (16777541)
#define PID_MYRON_STAGE2                (16777542)
#define PID_MYRON_STAGE3                (16777543)
#define PID_MYRON_STAGE4                (16777544)
#define PID_MARCUS_STAGE1               (16777545)
#define PID_MARCUS_STAGE2               (16777546)
#define PID_MARCUS_STAGE3               (16777547)
#define PID_MARCUS_STAGE4               (16777548)
#define PID_MARCUS_STAGE5               (16777549)
#define PID_CYBERDOG_STAGE1             (16777550)
#define PID_CYBERDOG_STAGE2             (16777551)
#define PID_CYBERDOG_STAGE3             (16777552)
#define PID_CYBERDOG_STAGE4             (16777553)
#define PID_CASSIDY_STAGE1              (16777554)
#define PID_CASSIDY_STAGE2              (16777555)
#define PID_CASSIDY_STAGE3              (16777556)
#define PID_CASSIDY_STAGE4              (16777557)
#define PID_DOGMEAT                     (16777558)
#define PID_DOGMEAT_STAGE1              (16777559)
#define PID_DOGMEAT_STAGE2              (16777560)
#define PID_DOGMEAT_STAGE3              (16777561)
#define PID_DOGMEAT_STAGE4              (16777562)
#define PID_DOGMEAT_STAGE5              (16777563)
#define PID_DOGMEAT_STAGE6              (16777564)
#define PID_ROBOBRAIN_STAGE1            (16777565)
#define PID_ROBOBRAIN_STAGE2            (16777566)
#define PID_ROBOBRAIN_STAGE3            (16777567)
#define PID_ROBOBRAIN_STAGE4            (16777568)
#define PID_ROBOBRAIN_STAGE5            (16777569)
#define PID_QUEEN_ALIEN                 (16777570)
#define PID_BLACK_SCORPION              (16777571)
#define PID_LARGE_BLACK_SCORPION        (16777572)
#define PID_SPUD                        (16777573)
#define PID_MERCENARY_CAPTAIN           (16777574)
#define PID_MERCENARY_LEATHER_HERO      (16777575)
#define PID_MERCENARY_LEATHER           (16777576)
#define PID_SHADOW_WHO_WALKS            (16777577)
#define PID_FEMALE_PUNK                 (16777578)
#define PID_MALE_PUNK                   (16777579)
#define PID_MARC                        (16777580)
#define PID_DAVE_H                      (16777581)
#define PID_CAPTAIN_MEYERS              (16777582)
#define PID_CHIP                        (16777583)
#define PID_OZ9                         (16777584)
#define PID_ELRONOLOGIST_GUARD_MALE     (16777585)
#define PID_ELRONOLOGIST_GUARD_FEMALE   (16777586)
#define PID_JAUN                        (16777587)
#define PID_VIKKI                       (16777588)
#define PID_VIC_STAGE1                  (16777589)
#define PID_VIC_STAGE2                  (16777590)
#define PID_VIC_STAGE3                  (16777591)
#define PID_VIC_STAGE4                  (16777592)
#define PID_VIC_STAGE5                  (16777593)
#define PID_VIC_STAGE6                  (16777594)
#define PID_ROBOBRAIN_CHIMP             (16777595)
#define PID_ROBOBRAIN_ABNORMAL          (16777596)
#define PID_ROBOBRAIN_HUMAN             (16777597)
#define PID_GIANT_ANT                   (16777598)
#define PID_TOUGH_GIANT_ANT             (16777599) // 382
#define PID_PARIAH_DOG                  (16777600)
#define PID_ZURAK                       (16777601)
#define PID_IMBOT                       (16777602)
#define PID_JIMMY                       (16777603)
#define PID_WEJUNGH                     (16777604)
#define PID_HERB                        (16777605)
#define PID_LOOPAL                      (16777606)
#define PID_JOBE                        (16777607)
#define PID_SMITTY                      (16777608)
#define PID_RUBE                        (16777609)
#define PID_MASTER_KRALL                (16777610)
#define PID_ZIGGY                       (16777611)
#define PID_MASTER_KHUNG                (16777612)
#define PID_JOHN_BISHOP                 (16777613)
#define PID_ANGELA_BISHOP               (16777614)
#define PID_LESLIE_ANN_BISHOP           (16777615)
#define PID_BISHOP_GUARD_1              (16777616)
#define PID_BISHOP_GUARD_2              (16777617)
#define PID_BISHOP_THUG_1               (16777618)
#define PID_BISHOP_THUG_2               (16777619)
#define PID_ANGRY_BRAHMIN               (16777620)
#define PID_LIL_JESUS                   (16777621)
#define PID_BIG_JESUS                   (16777622)
#define PID_MORDINO_MEN_1               (16777623)
#define PID_MORDINO_MEN_2               (16777624)
#define PID_MORDINO_MEN_3               (16777625)
#define PID_MYRON_GUARD_1               (16777626)
#define PID_MYRON_GUARD_2               (16777627)
#define PID_MR_WRIGHT                   (16777628)
#define PID_MRS_WRIGHT                  (16777629)
#define PID_CHRIS_WRIGHT                (16777630)
#define PID_KEITH_WRIGHT                (16777631)
#define PID_WRIGHT_SON_1                (16777632)
#define PID_WRIGHT_SON_2                (16777633)
#define PID_WRIGHT_DAUGHTER_1           (16777634)
#define PID_WRIGHT_DAUGHTER_2           (16777635)
#define PID_MR_SALVATORE                (16777636)
#define PID_MASON                       (16777637)
#define PID_SALVATORE_THUG_1            (16777638)
#define PID_SALVATORE_THUG_2            (16777639)
#define PID_BARTENDER_1                 (16777640)
#define PID_BARTENDER_2                 (16777641)
#define PID_BARTENDER_3                 (16777642)
#define PID_BOXER_1                     (16777643)
#define PID_BOXER_2                     (16777644)
#define PID_BOXER_3                     (16777645)
#define PID_BOXER_4                     (16777646)
#define PID_MASTICATOR                  (16777647)
#define PID_HOLYFELD                    (16777648)
#define PID_MCKNEELY                    (16777649)
#define PID_STUART_LITTLE               (16777650)
#define PID_CORSICAN_BROTHER            (16777651)
#define PID_CORSICAN_BITCHES            (16777652)
#define PID_FATHER_TULLY                (16777653)
#define PID_CASINO_BOUNCER_1            (16777654)
#define PID_CASINO_BOUNCER_2            (16777655)
#define PID_CASINO_GIRL                 (16777656)
#define PID_DRUG_DEALER_PIMP_1          (16777657)
#define PID_DRUG_DEALER_PIMP_2          (16777658)
#define PID_DRUG_DEALER_PIMP_3          (16777659)
#define PID_DRUG_DEALER_PIMP_4          (16777660)
#define PID_MCGEE                       (16777661)
#define PID_MISS_KITTY                  (16777662)
#define PID_SLUT_1                      (16777663)
#define PID_SLUT_2                      (16777664)
#define PID_JAGGED_JIMMY_J              (16777665)
#define PID_RENESCO                     (16777666)
#define PID_SCIENTIST                   (16777667)
#define PID_ELDRIDGE                    (16777668)
#define PID_ALGERNON                    (16777669)
#define PID_JULES                       (16777670)
#define PID_BUREAUCRAT_1                (16777671)
#define PID_BUREAUCRAT_2                (16777672)
#define PID_TRADER_1                    (16777673)
#define PID_TRADER_2                    (16777674)
#define PID_GUARD_1                     (16777675)
#define PID_GUARD_2                     (16777676)
#define PID_GUARD_3                     (16777677)
#define PID_GUARD_4                     (16777678)
#define PID_SOLDIER_1                   (16777679)
#define PID_SOLDIER_2                   (16777680)
#define PID_SOLDIER_3                   (16777681)
#define PID_SOLDIER_4                   (16777682)
#define PID_SGT_STARK                   (16777683)
#define PID_DOC_ANDREW                  (16777684)
#define PID_BARTENDER                   (16777685)
#define PID_AUTO_GAT_GUN                (16777686)
#define PID_K9                          (16777687)
#define PID_SEYMORE                     (16777697)
#define PID_GRIM_REAPER                 (16777698)

//MegaMod
#define PID_SKYNET                      (16777785)
#define PID_KLINT                       (16777859)
#define PID_DIAGO                       (16777766)
#define PID_MERIS                       (16777762)
#define PID_DOBBS                       (16777872)

#define PID_GIANT_RED_ANT               (16777841)
#define PID_GIANT_BLACK_ANT             (16777842)

#define PID_TOUGH_GIANT_ANT             (16777599)
#define PID_TOUGH_RED_ANT               (16777864)
#define PID_TOUGH_BLACK_ANT             (16777865)
#define PID_HUNTER_RAT                  (16777816)
#define PID_VAULT_23_BOSS               (16777814) //598
//Fallout Restoration Project
#define PID_KITSUNE                     (16777718) 
#define PID_DEX                         (16777719) 
#define PID_CAT_JULES                   (16777720)
#define PID_T_800						(16777765)

//Nirran Added
#define PID_WANAMIGO_EGG                (16777693)
#define PID_CASSIDY                     (PID_JOHN_MACRAE)

//Small Deathclaw
#define PID_FIXIT_IMMATURE_SMALL_DEATHCLAW    (16777908)
#define PID_FIXIT_YOUNG_SMALL_DEATHCLAW       (16777909)
#define PID_FIXIT_MINOR_SMALL_DEATHCLAW       (16777910)
#define PID_FIXIT_LESSER_SMALL_DEATHCLAW      (16777911)
#define PID_FIXIT_NORMAL_SMALL_DEATHCLAW      (16777912)
#define PID_FIXIT_STRONG_SMALL_DEATHCLAW      (16777913)
#define PID_FIXIT_RESILIENT_SMALL_DEATHCLAW   (16777914)
#define PID_FIXIT_TOUGH_SMALL_DEATHCLAW       (16777915)
//Large Deathclaw
#define PID_FIXIT_IMMATURE_LARGE_DEATHCLAW    (16777916)
#define PID_FIXIT_YOUNG_LARGE_DEATHCLAW       (16777917)
#define PID_FIXIT_MINOR_LARGE_DEATHCLAW       (16777918)
#define PID_FIXIT_LESSER_LARGE_DEATHCLAW      (16777919)
#define PID_FIXIT_NORMAL_LARGE_DEATHCLAW      (16777920)
#define PID_FIXIT_STRONG_LARGE_DEATHCLAW      (16777921)
#define PID_FIXIT_RESILIENT_LARGE_DEATHCLAW   (16777922)
#define PID_FIXIT_TOUGH_LARGE_DEATHCLAW       (16777923)
//Rat
#define PID_FIXIT_IMMATURE_RAT                (16777924)
#define PID_FIXIT_YOUNG_RAT                   (16777925)
#define PID_FIXIT_MINOR_RAT                   (16777926)
#define PID_FIXIT_LESSER_RAT                  (16777927)
#define PID_FIXIT_NORMAL_RAT                  (16777928)
#define PID_FIXIT_STRONG_RAT                  (16777929)
#define PID_FIXIT_RESILIENT_RAT               (16777930)
#define PID_FIXIT_TOUGH_RAT                   (16777931)
//Pig Rat
#define PID_FIXIT_IMMATURE_PIG_RAT            (16777932)
#define PID_FIXIT_YOUNG_PIG_RAT               (16777933)
#define PID_FIXIT_MINOR_PIG_RAT               (16777934)
#define PID_FIXIT_LESSER_PIG_RAT              (16777935)
#define PID_FIXIT_NORMAL_PIG_RAT              (16777936)
#define PID_FIXIT_STRONG_PIG_RAT              (16777937)
#define PID_FIXIT_RESILIENT_PIG_RAT           (16777938)
#define PID_FIXIT_TOUGH_PIG_RAT               (16777939)
//Mole Rat
#define PID_FIXIT_IMMATURE_MOLE_RAT           (16777940)
#define PID_FIXIT_YOUNG_MOLE_RAT              (16777941)
#define PID_FIXIT_MINOR_MOLE_RAT              (16777942)
#define PID_FIXIT_LESSER_MOLE_RAT             (16777943)
#define PID_FIXIT_NORMAL_MOLE_RAT             (16777944)
#define PID_FIXIT_STRONG_MOLE_RAT             (16777945)
#define PID_FIXIT_RESILIENT_MOLE_RAT          (16777946)
#define PID_FIXIT_TOUGH_MOLE_RAT              (16777947)
//Silver Gecko
#define PID_FIXIT_IMMATURE_SILVER_GECKO       (16777948)
#define PID_FIXIT_YOUNG_SILVER_GECKO          (16777949)
#define PID_FIXIT_MINOR_SILVER_GECKO          (16777950)
#define PID_FIXIT_LESSER_SILVER_GECKO         (16777951)
#define PID_FIXIT_NORMAL_SILVER_GECKO         (16777952)
#define PID_FIXIT_STRONG_SILVER_GECKO         (16777953)
#define PID_FIXIT_RESILIENT_SILVER_GECKO      (16777954)
#define PID_FIXIT_TOUGH_SILVER_GECKO          (16777955)
//Golden Gecko
#define PID_FIXIT_IMMATURE_GOLDEN_GECKO       (16777956)
#define PID_FIXIT_YOUNG_GOLDEN_GECKO          (16777957)
#define PID_FIXIT_MINOR_GOLDEN_GECKO          (16777958)
#define PID_FIXIT_LESSER_GOLDEN_GECKO         (16777959)
#define PID_FIXIT_NORMAL_GOLDEN_GECKO         (16777960)
#define PID_FIXIT_STRONG_GOLDEN_GECKO         (16777961)
#define PID_FIXIT_RESILIENT_GOLDEN_GECKO      (16777962)
#define PID_FIXIT_TOUGH_GOLDEN_GECKO          (16777963)
//Fire Gecko
#define PID_FIXIT_IMMATURE_FIRE_GECKO         (16777964)
#define PID_FIXIT_YOUNG_FIRE_GECKO            (16777965)
#define PID_FIXIT_MINOR_FIRE_GECKO            (16777966)
#define PID_FIXIT_LESSER_FIRE_GECKO           (16777967)
#define PID_FIXIT_NORMAL_FIRE_GECKO           (16777968)
#define PID_FIXIT_STRONG_FIRE_GECKO           (16777969)
#define PID_FIXIT_RESILIENT_FIRE_GECKO        (16777970)
#define PID_FIXIT_TOUGH_FIRE_GECKO            (16777971)
//Alien
#define PID_FIXIT_IMMATURE_ALIEN              (16777972)
#define PID_FIXIT_YOUNG_ALIEN                 (16777973)
#define PID_FIXIT_MINOR_ALIEN                 (16777974)
#define PID_FIXIT_LESSER_ALIEN                (16777975)
#define PID_FIXIT_NORMAL_ALIEN                (16777976)
#define PID_FIXIT_STRONG_ALIEN                (16777977)
#define PID_FIXIT_RESILIENT_ALIEN             (16777978)
#define PID_FIXIT_TOUGH_ALIEN                 (16777979)
//Floater
#define PID_FIXIT_IMMATURE_FLOATER            (16777980)
#define PID_FIXIT_YOUNG_FLOATER               (16777981)
#define PID_FIXIT_MINOR_FLOATER               (16777982)
#define PID_FIXIT_LESSER_FLOATER              (16777983)
#define PID_FIXIT_NORMAL_FLOATER              (16777984)
#define PID_FIXIT_STRONG_FLOATER              (16777985)
#define PID_FIXIT_RESILIENT_FLOATER           (16777986)
#define PID_FIXIT_TOUGH_FLOATER               (16777987)
//Centaur
#define PID_FIXIT_IMMATURE_CENTAUR            (16777988)
#define PID_FIXIT_YOUNG_CENTAUR               (16777989)
#define PID_FIXIT_MINOR_CENTAUR               (16777990)
#define PID_FIXIT_LESSER_CENTAUR              (16777991)
#define PID_FIXIT_NORMAL_CENTAUR              (16777992)
#define PID_FIXIT_STRONG_CENTAUR              (16777993)
#define PID_FIXIT_RESILIENT_CENTAUR           (16777994)
#define PID_FIXIT_TOUGH_CENTAUR               (16777995)
//Small Cockroach
#define PID_FIXIT_IMMATURE_SMALL_COCKROACH    (16777996)
#define PID_FIXIT_YOUNG_SMALL_COCKROACH       (16777997)
#define PID_FIXIT_MINOR_SMALL_COCKROACH       (16777998)
#define PID_FIXIT_LESSER_SMALL_COCKROACH      (16777999)
#define PID_FIXIT_NORMAL_SMALL_COCKROACH      (16778000)
#define PID_FIXIT_STRONG_SMALL_COCKROACH      (16778001)
#define PID_FIXIT_RESILIENT_SMALL_COCKROACH   (16778002)
#define PID_FIXIT_TOUGH_SMALL_COCKROACH       (16778003)
//Large Cockroach
#define PID_FIXIT_IMMATURE_LARGE_COCKROACH    (16778004)
#define PID_FIXIT_YOUNG_LARGE_COCKROACH       (16778005)
#define PID_FIXIT_MINOR_LARGE_COCKROACH       (16778006)
#define PID_FIXIT_LESSER_LARGE_COCKROACH      (16778007)
#define PID_FIXIT_NORMAL_LARGE_COCKROACH      (16778008)
#define PID_FIXIT_STRONG_LARGE_COCKROACH      (16778009)
#define PID_FIXIT_RESILIENT_LARGE_COCKROACH   (16778010)
#define PID_FIXIT_TOUGH_LARGE_COCKROACH       (16778011)

#define PID_MEGAMOD_SMALL_COCKROACH           (16777755)
#define PID_MEGAMOD_LARGE_COCKROACH           (16777756)

//Fruit Fly
#define PID_MEGAMOD_FRUIT_FLY                 (16777713)

#define PID_FIXIT_IMMATURE_FRUIT_FLY          (16778012)
#define PID_FIXIT_YOUNG_FRUIT_FLY             (16778013)
#define PID_FIXIT_MINOR_FRUIT_FLY             (16778014)
#define PID_FIXIT_LESSER_FRUIT_FLY            (16778015)
#define PID_FIXIT_NORMAL_FRUIT_FLY            (16778016)
#define PID_FIXIT_STRONG_FRUIT_FLY            (16778017)
#define PID_FIXIT_RESILIENT_FRUIT_FLY         (16778018)
#define PID_FIXIT_TOUGH_FRUIT_FLY             (16778019)

//Vanilla Art Ant
#define PID_FIXIT_IMMATURE_ANT                (16778020)
#define PID_FIXIT_YOUNG_ANT                   (16778021)
#define PID_FIXIT_MINOR_ANT                   (16778022)
#define PID_FIXIT_LESSER_ANT                  (16778023)
#define PID_FIXIT_NORMAL_ANT                  (16778024)
#define PID_FIXIT_STRONG_ANT                  (16778025)
#define PID_FIXIT_RESILIENT_ANT               (16778026)
#define PID_FIXIT_TOUGH_ANT                   (16778027)

//Black Ant
#define PID_FIXIT_IMMATURE_BLACK_ANT          (16778028)
#define PID_FIXIT_YOUNG_BLACK_ANT             (16778029)
#define PID_FIXIT_MINOR_BLACK_ANT             (16778030)
#define PID_FIXIT_LESSER_BLACK_ANT            (16778031)
#define PID_FIXIT_NORMAL_BLACK_ANT            (16778032)
#define PID_FIXIT_STRONG_BLACK_ANT            (16778033)
#define PID_FIXIT_RESILIENT_BLACK_ANT         (16778034)
#define PID_FIXIT_TOUGH_BLACK_ANT             (16778035)

//Red Ant
#define PID_FIXIT_IMMATURE_RED_ANT            (16778036)
#define PID_FIXIT_YOUNG_RED_ANT               (16778037)
#define PID_FIXIT_MINOR_RED_ANT               (16778038)
#define PID_FIXIT_LESSER_RED_ANT              (16778039)
#define PID_FIXIT_NORMAL_RED_ANT              (16778040)
#define PID_FIXIT_STRONG_RED_ANT              (16778041)
#define PID_FIXIT_RESILIENT_RED_ANT           (16778042)
#define PID_FIXIT_TOUGH_RED_ANT               (16778043)

//Mantis
#define PID_FIXIT_IMMATURE_MANTIS             (16778044)
#define PID_FIXIT_YOUNG_MANTIS                (16778045)
#define PID_FIXIT_MINOR_MANTIS                (16778046)
#define PID_FIXIT_LESSER_MANTIS               (16778047)
#define PID_FIXIT_NORMAL_MANTIS               (16778048)
#define PID_FIXIT_STRONG_MANTIS               (16778049)
#define PID_FIXIT_RESILIENT_MANTIS            (16778050)
#define PID_FIXIT_TOUGH_MANTIS                (16778051)

//Spore Plants
#define PID_FIXIT_IMMATURE_SPORE_PLANT        (16778052)
#define PID_FIXIT_YOUNG_SPORE_PLANT           (16778053)
#define PID_FIXIT_MINOR_SPORE_PLANT           (16778054)
#define PID_FIXIT_LESSER_SPORE_PLANT          (16778055)
#define PID_FIXIT_NORMAL_SPORE_PLANT          (16778056)
#define PID_FIXIT_STRONG_SPORE_PLANT          (16778057)
#define PID_FIXIT_RESILIENT_SPORE_PLANT       (16778058)
#define PID_FIXIT_TOUGH_SPORE_PLANT           (16778059)

//Mutant
#define PID_FIXIT_IMMATURE_MUTANT             (16778060)
#define PID_FIXIT_YOUNG_MUTANT                (16778061)
#define PID_FIXIT_MINOR_MUTANT                (16778062)
#define PID_FIXIT_LESSER_MUTANT               (16778063)
#define PID_FIXIT_NORMAL_MUTANT               (16778064)
#define PID_FIXIT_STRONG_MUTANT               (16778065)
#define PID_FIXIT_RESILIENT_MUTANT            (16778066)
#define PID_FIXIT_TOUGH_MUTANT                (16778067)

//Ghoul
#define PID_FIXIT_IMMATURE_GLOWING_GHOUL      (16778068)
#define PID_FIXIT_YOUNG_GLOWING_GHOUL         (16778069)
#define PID_FIXIT_MINOR_GLOWING_GHOUL         (16778070)
#define PID_FIXIT_LESSER_GLOWING_GHOUL        (16778071)
#define PID_FIXIT_NORMAL_GLOWING_GHOUL        (16778072)
#define PID_FIXIT_STRONG_GLOWING_GHOUL        (16778073)
#define PID_FIXIT_RESILIENT_GLOWING_GHOUL     (16778074)
#define PID_FIXIT_TOUGH_GLOWING_GHOUL         (16778075)

//Sentry Bot
#define PID_FIXIT_IMMATURE_SENTRY_BOT         (16778076)
#define PID_FIXIT_YOUNG_SENTRY_BOT            (16778077)
#define PID_FIXIT_MINOR_SENTRY_BOT            (16778078)
#define PID_FIXIT_LESSER_SENTRY_BOT           (16778079)
#define PID_FIXIT_NORMAL_SENTRY_BOT           (16778080)
#define PID_FIXIT_STRONG_SENTRY_BOT           (16778081)
#define PID_FIXIT_RESILIENT_SENTRY_BOT        (16778082)
#define PID_FIXIT_TOUGH_SENTRY_BOT            (16778083)

//Woman metal armor - no small machine gun art
#define PID_FIXIT_IMMATURE_WOMAN              (16778084)
#define PID_FIXIT_YOUNG_WOMAN                 (16778085)
#define PID_FIXIT_MINOR_WOMAN                 (16778086)
#define PID_FIXIT_LESSER_WOMAN                (16778087)
#define PID_FIXIT_NORMAL_WOMAN                (16778088)
#define PID_FIXIT_STRONG_WOMAN                (16778089)
#define PID_FIXIT_RESILIENT_WOMAN             (16778090)
#define PID_FIXIT_TOUGH_WOMAN                 (16778091)

//Man metal armor
#define PID_FIXIT_IMMATURE_MAN                (16778092)
#define PID_FIXIT_YOUNG_MAN                   (16778093)
#define PID_FIXIT_MINOR_MAN                   (16778094)
#define PID_FIXIT_LESSER_MAN                  (16778095)
#define PID_FIXIT_NORMAL_MAN                  (16778096)
#define PID_FIXIT_STRONG_MAN                  (16778097)
#define PID_FIXIT_RESILIENT_MAN               (16778098)
#define PID_FIXIT_TOUGH_MAN                   (16778099)

//Dog
#define PID_FIXIT_IMMATURE_DOG                (16778100)
#define PID_FIXIT_YOUNG_DOG                   (16778101)
#define PID_FIXIT_MINOR_DOG                   (16778102)
#define PID_FIXIT_LESSER_DOG                  (16778103)
#define PID_FIXIT_NORMAL_DOG                  (16778104)
#define PID_FIXIT_STRONG_DOG                  (16778105)
#define PID_FIXIT_RESILIENT_DOG               (16778106)
#define PID_FIXIT_TOUGH_DOG                   (16778107)

//Brahmin
#define PID_FIXIT_IMMATURE_BRAHMIN            (16778108)
#define PID_FIXIT_YOUNG_BRAHMIN               (16778109)
#define PID_FIXIT_MINOR_BRAHMIN               (16778110)
#define PID_FIXIT_LESSER_BRAHMIN              (16778111)
#define PID_FIXIT_NORMAL_BRAHMIN              (16778112)
#define PID_FIXIT_STRONG_BRAHMIN              (16778113)
#define PID_FIXIT_RESILIENT_BRAHMIN           (16778114)
#define PID_FIXIT_TOUGH_BRAHMIN               (16778115)

//Small Radscorpion
#define PID_FIXIT_IMMATURE_SMALL_RADSCORPION  (16778116)
#define PID_FIXIT_YOUNG_SMALL_RADSCORPION     (16778117)
#define PID_FIXIT_MINOR_SMALL_RADSCORPION     (16778118)
#define PID_FIXIT_LESSER_SMALL_RADSCORPION    (16778119)
#define PID_FIXIT_NORMAL_SMALL_RADSCORPION    (16778120)
#define PID_FIXIT_STRONG_SMALL_RADSCORPION    (16778121)
#define PID_FIXIT_RESILIENT_SMALL_RADSCORPION (16778122)
#define PID_FIXIT_TOUGH_SMALL_RADSCORPION     (16778123)

//Large Radscorpion
#define PID_FIXIT_IMMATURE_LARGE_RADSCORPION  (16778124)
#define PID_FIXIT_YOUNG_LARGE_RADSCORPION     (16778125)
#define PID_FIXIT_MINOR_LARGE_RADSCORPION     (16778126)
#define PID_FIXIT_LESSER_LARGE_RADSCORPION    (16778127)
#define PID_FIXIT_NORMAL_LARGE_RADSCORPION    (16778128)
#define PID_FIXIT_STRONG_LARGE_RADSCORPION    (16778129)
#define PID_FIXIT_RESILIENT_LARGE_RADSCORPION (16778130)
#define PID_FIXIT_TOUGH_LARGE_RADSCORPION     (16778131)


#endif // CRITRPID_H


