#ifndef H_DIK
#define H_DIK

// Listed are keyboard scan code constants (in decimal), taken from dinput.h

#define DIK_ESCAPE          1
#define DIK_1               2
#define DIK_2               3
#define DIK_3               4
#define DIK_4               5
#define DIK_5               6
#define DIK_6               7
#define DIK_7               8
#define DIK_8               9
#define DIK_9               10
#define DIK_0               11
#define DIK_MINUS           12    /* - on main keyboard */
#define DIK_EQUALS          13
#define DIK_BACK            14    /* backspace */
#define DIK_TAB             15
#define DIK_Q               16
#define DIK_W               17
#define DIK_E               18
#define DIK_R               19
#define DIK_T               20
#define DIK_Y               21
#define DIK_U               22
#define DIK_I               23
#define DIK_O               24
#define DIK_P               25
#define DIK_LBRACKET        26
#define DIK_RBRACKET        27
#define DIK_RETURN          28    /* Enter on main keyboard */
#define DIK_LCONTROL        29
#define DIK_A               30
#define DIK_S               31
#define DIK_D               32
#define DIK_F               33
#define DIK_G               34
#define DIK_H               35
#define DIK_J               36
#define DIK_K               37
#define DIK_L               38
#define DIK_SEMICOLON       39
#define DIK_APOSTROPHE      40
#define DIK_GRAVE           41    /* accent grave */
#define DIK_LSHIFT          42
#define DIK_BACKSLASH       43
#define DIK_Z               44
#define DIK_X               45
#define DIK_C               46
#define DIK_V               47
#define DIK_B               48
#define DIK_N               49
#define DIK_M               50
#define DIK_COMMA           51
#define DIK_PERIOD          52    /* . on main keyboard */
#define DIK_SLASH           53    /* / on main keyboard */
#define DIK_RSHIFT          54
#define DIK_MULTIPLY        55    /* * on numeric keypad */
#define DIK_LMENU           56    /* left Alt */
#define DIK_SPACE           57
#define DIK_CAPITAL         58
#define DIK_F1              59
#define DIK_F2              60
#define DIK_F3              61
#define DIK_F4              62
#define DIK_F5              63
#define DIK_F6              64
#define DIK_F7              65
#define DIK_F8              66
#define DIK_F9              67
#define DIK_F10             68
#define DIK_NUMLOCK         69
#define DIK_SCROLL          70    /* Scroll Lock */
#define DIK_NUMPAD7         71
#define DIK_NUMPAD8         72
#define DIK_NUMPAD9         73
#define DIK_SUBTRACT        74    /* - on numeric keypad */
#define DIK_NUMPAD4         75
#define DIK_NUMPAD5         76
#define DIK_NUMPAD6         77
#define DIK_ADD             78    /* + on numeric keypad */
#define DIK_NUMPAD1         79
#define DIK_NUMPAD2         80
#define DIK_NUMPAD3         81
#define DIK_NUMPAD0         82
#define DIK_DECIMAL         83    /* . on numeric keypad */
#define DIK_F11             87
#define DIK_F12             88

#define DIK_NUMPADEQUALS    0x8D    /* = on numeric keypad (NEC PC98) */
#define DIK_AT              0x91    /*                     (NEC PC98) */
#define DIK_COLON           0x92    /*                     (NEC PC98) */
#define DIK_UNDERLINE       0x93    /*                     (NEC PC98) */
#define DIK_STOP            0x95    /*                     (NEC PC98) */
#define DIK_AX              0x96    /*                     (Japan AX) */
#define DIK_UNLABELED       0x97    /*                        (J3100) */
#define DIK_NUMPADENTER     0x9C    /* Enter on numeric keypad */
#define DIK_RCONTROL        0x9D
#define DIK_NUMPADCOMMA     0xB3    /* , on numeric keypad (NEC PC98) */
#define DIK_DIVIDE          0xB5    /* / on numeric keypad */
#define DIK_SYSRQ           0xB7
#define DIK_RMENU           0xB8    /* right Alt */
#define DIK_HOME            0xC7    /* Home on arrow keypad */
#define DIK_UP              0xC8    /* UpArrow on arrow keypad */
#define DIK_PRIOR           0xC9    /* PgUp on arrow keypad */
#define DIK_LEFT            0xCB    /* LeftArrow on arrow keypad */
#define DIK_RIGHT           0xCD    /* RightArrow on arrow keypad */
#define DIK_END             0xCF    /* End on arrow keypad */
#define DIK_DOWN            0xD0    /* DownArrow on arrow keypad */
#define DIK_NEXT            0xD1    /* PgDn on arrow keypad */
#define DIK_INSERT          0xD2    /* Insert on arrow keypad */
#define DIK_DELETE          0xD3    /* Delete on arrow keypad */
#define DIK_LWIN            0xDB    /* Left Windows key */
#define DIK_RWIN            0xDC    /* Right Windows key */
#define DIK_APPS            0xDD    /* AppMenu key */

#define DIK_BACKSPACE       DIK_BACK        /* backspace */
#define DIK_NUMPADSTAR      DIK_MULTIPLY    /* * on numeric keypad */
#define DIK_LALT            DIK_LMENU       /* left Alt */
#define DIK_CAPSLOCK        DIK_CAPITAL     /* CapsLock */
#define DIK_NUMPADMINUS     DIK_SUBTRACT    /* - on numeric keypad */
#define DIK_NUMPADPLUS      DIK_ADD         /* + on numeric keypad */
#define DIK_NUMPADPERIOD    DIK_DECIMAL     /* . on numeric keypad */
#define DIK_NUMPADSLASH     DIK_DIVIDE      /* / on numeric keypad */
#define DIK_RALT            DIK_RMENU       /* right Alt */
#define DIK_UPARROW         DIK_UP          /* UpArrow on arrow keypad */
#define DIK_PGUP            DIK_PRIOR       /* PgUp on arrow keypad */
#define DIK_LEFTARROW       DIK_LEFT        /* LeftArrow on arrow keypad */
#define DIK_RIGHTARROW      DIK_RIGHT       /* RightArrow on arrow keypad */
#define DIK_DOWNARROW       DIK_DOWN        /* DownArrow on arrow keypad */
#define DIK_PGDN            DIK_NEXT        /* PgDn on arrow keypad */

#endif
